/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.evaluators;

import java.util.Collection;
import org.drools.base.BaseEvaluator;
import org.drools.spi.Evaluator;

public class ObjectFactory {
    public static Evaluator getObjectEvaluator(int n) {
        switch (n) {
            case 1: {
                return ObjectEqualEvaluator.INSTANCE;
            }
            case 10: {
                return ObjectNotEqualEvaluator.INSTANCE;
            }
            case 60: {
                return ObjectContainsEvaluator.INSTANCE;
            }
            case 20: {
                return ObjectLessEvaluator.INSTANCE;
            }
            case 30: {
                return ObjectLessOrEqualEvaluator.INSTANCE;
            }
            case 40: {
                return ObjectGreaterEvaluator.INSTANCE;
            }
            case 50: {
                return ObjectGreaterOrEqualEvaluator.INSTANCE;
            }
            case 80: {
                return ObjectExcludesEvaluator.INSTANCE;
            }
        }
        throw new RuntimeException("Operator '" + n + "' does not exist for ObjectEvaluator");
    }

    static class ObjectExcludesEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 4353038775000051165L;
        public static final Evaluator INSTANCE = new ObjectExcludesEvaluator();

        private ObjectExcludesEvaluator() {
            super(210, 80);
        }

        public boolean evaluate(Object object, Object object2) {
            if (object2 == null) {
                return false;
            }
            Collection collection = (Collection)object;
            return !collection.contains(object2);
        }

        public String toString() {
            return "Object excludes";
        }
    }

    static class ObjectContainsEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 6607233589136455455L;
        public static final Evaluator INSTANCE = new ObjectContainsEvaluator();

        private ObjectContainsEvaluator() {
            super(210, 60);
        }

        public boolean evaluate(Object object, Object object2) {
            if (object2 == null) {
                return false;
            }
            Collection collection = (Collection)object;
            return collection.contains(object2);
        }

        public String toString() {
            return "Object contains";
        }
    }

    static class ObjectGreaterOrEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = -3337081388987517878L;
        public static final Evaluator INSTANCE = new ObjectGreaterOrEqualEvaluator();

        private ObjectGreaterOrEqualEvaluator() {
            super(210, 50);
        }

        public boolean evaluate(Object object, Object object2) {
            Comparable comparable = (Comparable)object;
            return comparable.compareTo(object2) >= 0;
        }

        public String toString() {
            return "Object >=";
        }
    }

    static class ObjectGreaterEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 7808425299326128881L;
        public static final Evaluator INSTANCE = new ObjectGreaterEvaluator();

        private ObjectGreaterEvaluator() {
            super(210, 40);
        }

        public boolean evaluate(Object object, Object object2) {
            Comparable comparable = (Comparable)object;
            return comparable.compareTo(object2) > 0;
        }

        public String toString() {
            return "Object >";
        }
    }

    static class ObjectLessOrEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 3463248146201714137L;
        public static final Evaluator INSTANCE = new ObjectLessOrEqualEvaluator();

        private ObjectLessOrEqualEvaluator() {
            super(210, 30);
        }

        public boolean evaluate(Object object, Object object2) {
            Comparable comparable = (Comparable)object;
            return comparable.compareTo(object2) <= 0;
        }

        public String toString() {
            return "Object <=";
        }
    }

    static class ObjectLessEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 5327278696364237380L;
        public static final Evaluator INSTANCE = new ObjectLessEvaluator();

        private ObjectLessEvaluator() {
            super(210, 20);
        }

        public boolean evaluate(Object object, Object object2) {
            Comparable comparable = (Comparable)object;
            int n = comparable.compareTo(object2);
            return n < 0;
        }

        public String toString() {
            return "Object <";
        }
    }

    static class ObjectNotEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = -6995475512317781516L;
        public static final Evaluator INSTANCE = new ObjectNotEqualEvaluator();

        private ObjectNotEqualEvaluator() {
            super(210, 10);
        }

        public boolean evaluate(Object object, Object object2) {
            if (object == null) {
                return object2 != null;
            }
            return !object.equals(object2);
        }

        public String toString() {
            return "Object !=";
        }
    }

    static class ObjectEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 4532849170161094887L;
        public static final Evaluator INSTANCE = new ObjectEqualEvaluator();

        private ObjectEqualEvaluator() {
            super(210, 1);
        }

        public boolean evaluate(Object object, Object object2) {
            if (object == null) {
                return object2 == null;
            }
            return object.equals(object2);
        }

        public String toString() {
            return "Object ==";
        }
    }
}

