/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import org.drools.rule.And;
import org.drools.rule.Exists;
import org.drools.rule.GroupElement;
import org.drools.rule.InvalidPatternException;
import org.drools.rule.Not;
import org.drools.rule.Or;

class LogicTransformer {
    private final Map duplicateTransformations = new HashMap();
    private final Map orTransformations = new HashMap();
    private static LogicTransformer INSTANCE = null;

    static LogicTransformer getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new LogicTransformer();
        }
        return INSTANCE;
    }

    LogicTransformer() {
        this.initialize();
    }

    private void initialize() {
        this.addTransformationPair(And.class, And.class);
        this.addTransformationPair(Or.class, Or.class);
        this.addTransformationPair(Exists.class, Exists.class);
        this.addTransformationPair(Not.class, Or.class, new NotOrTransformation());
        this.addTransformationPair(Exists.class, Or.class, new ExistOrTransformation());
        this.addTransformationPair(And.class, Or.class, new AndOrTransformation());
    }

    private void addTransformationPair(Class clazz, Class clazz2) {
        Map map = this.duplicateTransformations;
        HashSet<Class> hashSet = (HashSet<Class>)map.get(clazz2);
        if (hashSet == null) {
            hashSet = new HashSet<Class>();
            map.put(clazz, hashSet);
        }
        hashSet.add(clazz2);
    }

    private void addTransformationPair(Class clazz, Class clazz2, Object object) {
        Map map = this.orTransformations;
        HashMap<Class, Object> hashMap = (HashMap<Class, Object>)map.get(clazz);
        if (hashMap == null) {
            hashMap = new HashMap<Class, Object>();
            map.put(clazz, hashMap);
        }
        hashMap.put(clazz2, object);
    }

    And[] transform(And and) throws InvalidPatternException {
        And and2 = (And)and.clone();
        this.processTree(and2);
        GroupElement groupElement = null;
        And[] andArray = and2.getChildren().iterator();
        while (andArray.hasNext()) {
            Object e = andArray.next();
            if (!(e instanceof Or)) continue;
            groupElement = (Or)this.applyOrTransformation(and2, (GroupElement)e);
            break;
        }
        andArray = null;
        if (groupElement == null) {
            andArray = new And[]{and2};
            this.checkForAndRemoveDuplicates(andArray[0]);
        } else {
            andArray = new And[groupElement.getChildren().size()];
            int n = 0;
            Iterator iterator = groupElement.getChildren().iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e.getClass() == (class$org$drools$rule$And == null ? LogicTransformer.class$("org.drools.rule.And") : class$org$drools$rule$And)) {
                    andArray[n] = (And)e;
                } else {
                    And and3 = new And();
                    and3.addChild(and);
                    andArray[n] = and3;
                }
                this.checkForAndRemoveDuplicates(andArray[n++]);
            }
        }
        return andArray;
    }

    void processTree(GroupElement groupElement) throws InvalidPatternException {
        ListIterator<GroupElement> listIterator = groupElement.getChildren().listIterator();
        block0: while (listIterator.hasNext()) {
            Object e = listIterator.next();
            if (!(e instanceof GroupElement)) continue;
            GroupElement groupElement2 = (GroupElement)e;
            this.processTree(groupElement2);
            this.checkForAndRemoveDuplicates(groupElement2);
            Iterator iterator = groupElement2.getChildren().iterator();
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                if (!(e2 instanceof Or)) continue;
                listIterator.remove();
                listIterator.add(this.applyOrTransformation(groupElement2, (GroupElement)e2));
                continue block0;
            }
        }
    }

    boolean removeDuplicate(GroupElement groupElement, GroupElement groupElement2) {
        if (this.duplicateTransformations.get(groupElement.getClass()) != null) {
            return ((HashSet)this.duplicateTransformations.get(groupElement.getClass())).contains(groupElement2.getClass());
        }
        return false;
    }

    void checkForAndRemoveDuplicates(GroupElement groupElement) {
        ListIterator listIterator = groupElement.getChildren().listIterator();
        while (listIterator.hasNext()) {
            Object e = listIterator.next();
            if (!groupElement.getClass().isInstance(e) || !this.removeDuplicate(groupElement, (GroupElement)e)) continue;
            ArrayList arrayList = new ArrayList();
            GroupElement groupElement2 = (GroupElement)e;
            Iterator iterator = groupElement2.getChildren().iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            listIterator.remove();
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                listIterator.add(iterator.next());
            }
        }
    }

    GroupElement applyOrTransformation(GroupElement groupElement, GroupElement groupElement2) throws InvalidPatternException {
        Transformation transformation = null;
        HashMap hashMap = (HashMap)this.orTransformations.get(groupElement.getClass());
        if (hashMap != null) {
            transformation = (Transformation)hashMap.get(groupElement2.getClass());
        }
        if (transformation == null) {
            throw new RuntimeException("applyOrTransformation could not find transformation for parent '" + groupElement.getClass().getName() + "' and child '" + groupElement2.getClass().getName() + "'");
        }
        return transformation.transform(groupElement);
    }

    public class NotOrTransformation
    implements Transformation {
        public GroupElement transform(GroupElement groupElement) throws InvalidPatternException {
            throw new InvalidPatternException("You cannot nest an OR within an Not");
        }
    }

    class ExistOrTransformation
    implements Transformation {
        ExistOrTransformation() {
        }

        public GroupElement transform(GroupElement groupElement) throws InvalidPatternException {
            throw new InvalidPatternException("You cannot nest an OR within an Exists");
        }
    }

    class AndOrTransformation
    implements Transformation {
        AndOrTransformation() {
        }

        public GroupElement transform(GroupElement groupElement) throws InvalidPatternException {
            Or or = new Or();
            this.determinePermutations(0, (And)groupElement, null, or);
            return or;
        }

        private void determinePermutations(int n, And and, And and2, Or or) {
            Object e = and.getChildren().get(n);
            if (e instanceof Or) {
                Or or2 = (Or)e;
                Iterator iterator = or2.getChildren().iterator();
                while (iterator.hasNext()) {
                    And and3 = new And();
                    if (n == 0) {
                        and2 = new And();
                    } else {
                        and3.getChildren().addAll(and2.getChildren());
                    }
                    Object e2 = iterator.next();
                    if (e2 instanceof And) {
                        And and4 = (And)e2;
                        Iterator iterator2 = and4.getChildren().iterator();
                        while (iterator2.hasNext()) {
                            and3.addChild(iterator2.next());
                        }
                    } else {
                        and3.addChild(e2);
                    }
                    if (n < and.getChildren().size() - 1) {
                        this.determinePermutations(n + 1, and, and3, or);
                        continue;
                    }
                    or.addChild(and3);
                }
            } else {
                And and5 = new And();
                if (n == 0) {
                    and2 = new And();
                } else {
                    and5.getChildren().addAll(and2.getChildren());
                }
                and5.addChild(e);
                if (n < and.getChildren().size() - 1) {
                    this.determinePermutations(n + 1, and, and5, or);
                } else {
                    or.addChild(and5);
                }
            }
        }
    }

    static interface Transformation {
        public GroupElement transform(GroupElement var1) throws InvalidPatternException;
    }
}

