/*
 * Decompiled with CFR 0.152.
 */
package org.drools.util;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Comparator;
import java.util.NoSuchElementException;
import org.drools.util.Queue;
import org.drools.util.Queueable;

public class BinaryHeapFifoQueue
implements Queue,
Serializable {
    private static final int DEFAULT_CAPACITY = 13;
    private final Comparator comparator;
    private int size;
    private Queueable[] elements;

    public BinaryHeapFifoQueue(Comparator comparator) {
        this(comparator, 13);
    }

    public BinaryHeapFifoQueue(Comparator comparator, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("invalid capacity");
        }
        this.elements = new Queueable[n + 1];
        this.comparator = comparator;
    }

    public void clear() {
        this.elements = new Queueable[this.elements.length];
        this.size = 0;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean isFull() {
        return this.elements.length == this.size + 1;
    }

    public int size() {
        return this.size;
    }

    public void enqueue(Queueable queueable) {
        if (this.isFull()) {
            this.grow();
        }
        this.percolateUpMinHeap(queueable);
    }

    public Queueable dequeue() throws NoSuchElementException {
        if (this.isEmpty()) {
            return null;
        }
        Queueable queueable = this.elements[1];
        queueable.dequeue();
        return queueable;
    }

    public Queueable dequeue(int n) {
        if (n < 1 || n > this.size) {
            return null;
        }
        Queueable queueable = this.elements[n];
        this.setElement(n, this.elements[this.size]);
        this.elements[this.size] = null;
        --this.size;
        if (this.size != 0 && n <= this.size) {
            int n2 = 0;
            if (n > 1) {
                n2 = this.compare(this.elements[n], this.elements[n / 2]);
            }
            if (n > 1 && n2 < 0) {
                this.percolateUpMinHeap(n);
            } else {
                this.percolateDownMinHeap(n);
            }
        }
        return queueable;
    }

    private void percolateDownMinHeap(int n) {
        Queueable queueable = this.elements[n];
        int n2 = n;
        while (n2 * 2 <= this.size) {
            int n3 = n2 * 2;
            if (n3 != this.size && this.compare(this.elements[n3 + 1], this.elements[n3]) < 0) {
                ++n3;
            }
            if (this.compare(this.elements[n3], queueable) >= 0) break;
            this.setElement(n2, this.elements[n3]);
            n2 = n3;
        }
        this.setElement(n2, queueable);
    }

    private void percolateUpMinHeap(int n) {
        int n2 = n;
        Queueable queueable = this.elements[n2];
        while (n2 > 1 && this.compare(queueable, this.elements[n2 / 2]) < 0) {
            int n3 = n2 / 2;
            this.setElement(n2, this.elements[n3]);
            n2 = n3;
        }
        this.setElement(n2, queueable);
    }

    private void percolateUpMinHeap(Queueable queueable) {
        this.setElement(++this.size, queueable);
        this.percolateUpMinHeap(this.size);
    }

    private int compare(Queueable queueable, Queueable queueable2) {
        return this.comparator.compare(queueable, queueable2);
    }

    private void grow() {
        Queueable[] queueableArray = new Queueable[this.elements.length * 2];
        System.arraycopy(this.elements, 0, queueableArray, 0, this.elements.length);
        this.elements = queueableArray;
    }

    private void setElement(int n, Queueable queueable) {
        this.elements[n] = queueable;
        queueable.enqueued(this, n);
    }

    public Queueable[] getQueueable() {
        return this.elements;
    }

    public Object[] toArray() {
        Object[] objectArray = new Object[this.size];
        System.arraycopy(this.elements, 1, objectArray, 0, this.size);
        return objectArray;
    }

    public Object[] toArray(Object[] objectArray) {
        if (objectArray.length < this.size) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.size);
        }
        System.arraycopy(this.elements, 1, objectArray, 0, this.size);
        if (objectArray.length > this.size) {
            objectArray[this.size] = null;
        }
        return objectArray;
    }
}

