/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.test;

import org.antlr.test.TestCompileAndExecSupport;
import org.antlr.test.unit.TestSuite;

public class TestTreeParsing
extends TestSuite {
    public void testFlatList() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID INT;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = "tree grammar TP;\na : ID INT\n    {System.out.println($ID+\", \"+$INT);}\n  ;\n";
        String string3 = TestCompileAndExecSupport.execTreeParser("t.g", string, "T", "tp.g", string2, "TP", "TLexer", "a", "a", "abc 34");
        String string4 = "abc, 34\n";
        this.assertEqual(string3, string4);
    }

    public void testSimpleTree() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID INT -> ^(ID INT);\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = "tree grammar TP;\na : ^(ID INT)\n    {System.out.println($ID+\", \"+$INT);}\n  ;\n";
        String string3 = TestCompileAndExecSupport.execTreeParser("t.g", string, "T", "tp.g", string2, "TP", "TLexer", "a", "a", "abc 34");
        String string4 = "abc, 34\n";
        this.assertEqual(string3, string4);
    }

    public void testFlatVsTreeDecision() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : b c ;\nb : ID INT -> ^(ID INT);\nc : ID INT;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = "tree grammar TP;\na : b b ;\nb : ID INT    {System.out.print($ID+\" \"+$INT);}\n  | ^(ID INT) {System.out.print(\"^(\"+$ID+\" \"+$INT+')');}\n  ;\n";
        String string3 = TestCompileAndExecSupport.execTreeParser("t.g", string, "T", "tp.g", string2, "TP", "TLexer", "a", "a", "a 1 b 2");
        String string4 = "^(a 1)b 2\n";
        this.assertEqual(string3, string4);
    }

    public void testFlatVsTreeDecision2() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : b c ;\nb : ID INT+ -> ^(ID INT+);\nc : ID INT+;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = "tree grammar TP;\na : b b ;\nb : ID INT+    {System.out.print($ID+\" \"+$INT);}\n  | ^(x=ID (y=INT)+) {System.out.print(\"^(\"+$x+' '+$y+')');}\n  ;\n";
        String string3 = TestCompileAndExecSupport.execTreeParser("t.g", string, "T", "tp.g", string2, "TP", "TLexer", "a", "a", "a 1 2 3 b 4 5");
        String string4 = "^(a 3)b 5\n";
        this.assertEqual(string3, string4);
    }

    public void testTemplateOutput() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID INT;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = "tree grammar TP;\noptions {output=template; ASTLabelType=CommonTree;}\ns : a {System.out.println($a.st);};\na : ID INT -> {new StringTemplate($INT.text)}\n  ;\n";
        String string3 = TestCompileAndExecSupport.execTreeParser("t.g", string, "T", "tp.g", string2, "TP", "TLexer", "a", "s", "abc 34");
        String string4 = "34\n";
        this.assertEqual(string3, string4);
    }
}

