/*
 * Decompiled with CFR 0.152.
 */
package org.drools.semantics.java;

import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.language.AngleBracketTemplateLexer;
import org.drools.RuntimeDroolsException;
import org.drools.base.ClassFieldExtractor;
import org.drools.base.ClassFieldExtractorCache;
import org.drools.base.ClassObjectType;
import org.drools.base.EvaluatorFactory;
import org.drools.base.FieldFactory;
import org.drools.base.FieldImpl;
import org.drools.compiler.RuleError;
import org.drools.lang.descr.AndDescr;
import org.drools.lang.descr.AttributeDescr;
import org.drools.lang.descr.BoundVariableDescr;
import org.drools.lang.descr.ColumnDescr;
import org.drools.lang.descr.ConditionalElementDescr;
import org.drools.lang.descr.EvalDescr;
import org.drools.lang.descr.ExistsDescr;
import org.drools.lang.descr.FieldBindingDescr;
import org.drools.lang.descr.LiteralDescr;
import org.drools.lang.descr.NotDescr;
import org.drools.lang.descr.OrDescr;
import org.drools.lang.descr.PatternDescr;
import org.drools.lang.descr.PredicateDescr;
import org.drools.lang.descr.QueryDescr;
import org.drools.lang.descr.ReturnValueDescr;
import org.drools.lang.descr.RuleDescr;
import org.drools.rule.And;
import org.drools.rule.BoundVariableConstraint;
import org.drools.rule.Column;
import org.drools.rule.ConditionalElement;
import org.drools.rule.Declaration;
import org.drools.rule.EvalCondition;
import org.drools.rule.Exists;
import org.drools.rule.GroupElement;
import org.drools.rule.LiteralConstraint;
import org.drools.rule.Not;
import org.drools.rule.Or;
import org.drools.rule.Package;
import org.drools.rule.PredicateConstraint;
import org.drools.rule.Query;
import org.drools.rule.ReturnValueConstraint;
import org.drools.rule.Rule;
import org.drools.semantics.java.FunctionFixer;
import org.drools.semantics.java.JavaExprAnalyzer;
import org.drools.semantics.java.KnowledgeHelperFixer;
import org.drools.spi.Evaluator;
import org.drools.spi.Extractor;
import org.drools.spi.FieldConstraint;
import org.drools.spi.FieldExtractor;
import org.drools.spi.FieldValue;
import org.drools.spi.ObjectType;
import org.drools.spi.TypeResolver;

public class RuleBuilder {
    private Package pkg;
    private Rule rule;
    private RuleDescr ruleDescr;
    public String ruleClass;
    public List methods;
    public Map invokers;
    private Map invokerLookups;
    private Map descrLookups;
    private Map declarations;
    private int counter;
    private ColumnCounter columnCounter;
    private int columnOffset;
    private List errors;
    private final TypeResolver typeResolver;
    private Map notDeclarations;
    private static final StringTemplateGroup ruleGroup = new StringTemplateGroup((Reader)new InputStreamReader(RuleBuilder.class.getResourceAsStream("javaRule.stg")), AngleBracketTemplateLexer.class);
    private static final StringTemplateGroup invokerGroup = new StringTemplateGroup((Reader)new InputStreamReader(RuleBuilder.class.getResourceAsStream("javaInvokers.stg")), AngleBracketTemplateLexer.class);
    private static final KnowledgeHelperFixer knowledgeHelperFixer = new KnowledgeHelperFixer();
    private static final FunctionFixer functionFixer = new FunctionFixer();
    private final JavaExprAnalyzer analyzer = new JavaExprAnalyzer();
    private ClassFieldExtractorCache classFieldExtractorCache;

    public RuleBuilder(TypeResolver typeResolver, ClassFieldExtractorCache classFieldExtractorCache) {
        this.classFieldExtractorCache = classFieldExtractorCache;
        this.typeResolver = typeResolver;
        this.errors = new ArrayList();
    }

    public Map getInvokers() {
        return this.invokers;
    }

    public Map getDescrLookups() {
        return this.descrLookups;
    }

    public String getRuleClass() {
        return this.ruleClass;
    }

    public Map getInvokerLookups() {
        return this.invokerLookups;
    }

    public List getErrors() {
        return this.errors;
    }

    public Rule getRule() {
        if (!this.errors.isEmpty()) {
            this.rule.setSemanticallyValid(false);
        }
        return this.rule;
    }

    public Package getPackage() {
        return this.pkg;
    }

    public synchronized Rule build(Package package_, RuleDescr ruleDescr) {
        this.pkg = package_;
        this.methods = new ArrayList();
        this.invokers = new HashMap();
        this.invokerLookups = new HashMap();
        this.declarations = new HashMap();
        this.descrLookups = new HashMap();
        this.columnCounter = new ColumnCounter();
        this.ruleDescr = ruleDescr;
        this.rule = ruleDescr instanceof QueryDescr ? new Query(ruleDescr.getName()) : new Rule(ruleDescr.getName());
        this.setAttributes(this.rule, ruleDescr.getAttributes());
        this.build(ruleDescr);
        return this.rule;
    }

    private void setAttributes(Rule rule, List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            AttributeDescr attributeDescr = (AttributeDescr)iterator.next();
            String string = attributeDescr.getName();
            if (string.equals("salience")) {
                rule.setSalience(Integer.parseInt(attributeDescr.getValue()));
                continue;
            }
            if (string.equals("no-loop")) {
                if (attributeDescr.getValue() == null) {
                    rule.setNoLoop(true);
                    continue;
                }
                rule.setNoLoop(Boolean.valueOf(attributeDescr.getValue()).booleanValue());
                continue;
            }
            if (string.equals("auto-focus")) {
                if (attributeDescr.getValue() == null) {
                    rule.setAutoFocus(true);
                    continue;
                }
                rule.setAutoFocus(Boolean.valueOf(attributeDescr.getValue()).booleanValue());
                continue;
            }
            if (string.equals("agenda-group")) {
                rule.setAgendaGroup(attributeDescr.getValue());
                continue;
            }
            if (string.equals("activation-group")) {
                rule.setXorGroup(attributeDescr.getValue());
                continue;
            }
            if (string.equals("duration")) {
                rule.setDuration(Long.parseLong(attributeDescr.getValue()));
                rule.setAgendaGroup("");
                continue;
            }
            if (!string.equals("language")) continue;
        }
    }

    private void build(RuleDescr ruleDescr) {
        Iterator iterator = ruleDescr.getLhs().getDescrs().iterator();
        while (iterator.hasNext()) {
            And and;
            Object e = iterator.next();
            if (e instanceof ConditionalElementDescr) {
                Iterator iterator2;
                if (e instanceof AndDescr) {
                    and = new And();
                    this.columnCounter.setParent((GroupElement)and);
                    this.build(this.rule, (ConditionalElementDescr)e, (GroupElement)and, false, false);
                    this.rule.addPattern((ConditionalElement)and);
                    continue;
                }
                if (e instanceof OrDescr) {
                    and = new Or();
                    this.columnCounter.setParent((GroupElement)and);
                    this.build(this.rule, (ConditionalElementDescr)e, (GroupElement)and, true, false);
                    this.rule.addPattern((ConditionalElement)and);
                    continue;
                }
                if (e instanceof NotDescr) {
                    this.notDeclarations = new HashMap();
                    and = new Not();
                    this.columnCounter.setParent((GroupElement)and);
                    this.build(this.rule, (ConditionalElementDescr)e, (GroupElement)and, true, true);
                    this.rule.addPattern((ConditionalElement)and);
                    iterator2 = this.notDeclarations.keySet().iterator();
                    while (iterator2.hasNext()) {
                        this.declarations.remove(iterator2.next());
                    }
                    this.notDeclarations = null;
                    continue;
                }
                if (e instanceof ExistsDescr) {
                    this.notDeclarations = new HashMap();
                    and = new Exists();
                    this.columnCounter.setParent((GroupElement)and);
                    this.build(this.rule, (ConditionalElementDescr)e, (GroupElement)and, true, true);
                    iterator2 = this.notDeclarations.keySet().iterator();
                    while (iterator2.hasNext()) {
                        this.declarations.remove(iterator2.next());
                    }
                    this.notDeclarations = null;
                    this.rule.addPattern((ConditionalElement)and);
                    continue;
                }
                if (!(e instanceof EvalDescr) || (and = this.build((EvalDescr)e)) == null) continue;
                this.rule.addPattern((ConditionalElement)and);
                continue;
            }
            if (!(e instanceof ColumnDescr) || (and = this.build((ColumnDescr)e)) == null) continue;
            this.rule.addPattern((Column)and);
        }
        if (!(ruleDescr instanceof QueryDescr)) {
            this.buildConsequence(ruleDescr);
        }
        this.buildRule(ruleDescr);
    }

    private void build(Rule rule, ConditionalElementDescr conditionalElementDescr, GroupElement groupElement, boolean bl, boolean bl2) {
        Iterator iterator = conditionalElementDescr.getDescrs().iterator();
        while (iterator.hasNext()) {
            And and;
            Object e = iterator.next();
            if (e instanceof ConditionalElementDescr) {
                if (e instanceof AndDescr) {
                    and = new And();
                    this.columnCounter.setParent((GroupElement)and);
                    this.build(rule, (ConditionalElementDescr)e, (GroupElement)and, false, false);
                    groupElement.addChild((Object)and);
                    continue;
                }
                if (e instanceof OrDescr) {
                    and = new Or();
                    this.columnCounter.setParent((GroupElement)and);
                    this.build(rule, (ConditionalElementDescr)e, (GroupElement)and, true, false);
                    groupElement.addChild((Object)and);
                    continue;
                }
                if (e instanceof NotDescr) {
                    and = new Not();
                    this.columnCounter.setParent((GroupElement)and);
                    this.build(rule, (ConditionalElementDescr)e, (GroupElement)and, true, true);
                    groupElement.addChild((Object)and);
                    continue;
                }
                if (e instanceof ExistsDescr) {
                    and = new Exists();
                    this.columnCounter.setParent((GroupElement)and);
                    this.build(rule, (ConditionalElementDescr)e, (GroupElement)and, true, true);
                    groupElement.addChild((Object)and);
                    continue;
                }
                if (!(e instanceof EvalDescr) || (and = this.build((EvalDescr)e)) == null) continue;
                groupElement.addChild((Object)and);
                continue;
            }
            if (!(e instanceof ColumnDescr)) continue;
            if (bl && bl2) {
                --this.columnOffset;
            } else {
                bl2 = true;
            }
            if ((and = this.build((ColumnDescr)e)) == null) continue;
            groupElement.addChild((Object)and);
        }
    }

    private Column build(ColumnDescr columnDescr) {
        Column column;
        if (columnDescr.getObjectType() == null || columnDescr.getObjectType().equals("")) {
            this.errors.add(new RuleError(this.rule, columnDescr, null, "ObjectType not correctly defined"));
            return null;
        }
        Class clazz = null;
        try {
            clazz = this.typeResolver.resolveType(columnDescr.getObjectType());
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.errors.add(new RuleError(this.rule, columnDescr, null, "Unable to resolve ObjectType '" + columnDescr.getObjectType() + "'"));
            return null;
        }
        if (columnDescr.getIdentifier() != null && !columnDescr.getIdentifier().equals("")) {
            column = new Column(this.columnCounter.getNext(), this.columnOffset, (ObjectType)new ClassObjectType(clazz), columnDescr.getIdentifier());
            this.declarations.put(column.getDeclaration().getIdentifier(), column.getDeclaration());
            if (this.notDeclarations != null) {
                this.notDeclarations.put(column.getDeclaration().getIdentifier(), column.getDeclaration());
            }
        } else {
            column = new Column(this.columnCounter.getNext(), this.columnOffset, (ObjectType)new ClassObjectType(clazz), null);
        }
        Iterator iterator = columnDescr.getDescrs().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof FieldBindingDescr) {
                this.build(column, (FieldBindingDescr)e);
                continue;
            }
            if (e instanceof LiteralDescr) {
                this.build(column, (LiteralDescr)e);
                continue;
            }
            if (e instanceof BoundVariableDescr) {
                this.build(column, (BoundVariableDescr)e);
                continue;
            }
            if (e instanceof ReturnValueDescr) {
                this.build(column, (ReturnValueDescr)e);
                continue;
            }
            if (!(e instanceof PredicateDescr)) continue;
            this.build(column, (PredicateDescr)e);
        }
        return column;
    }

    private void build(Column column, FieldBindingDescr fieldBindingDescr) {
        Declaration declaration = (Declaration)this.declarations.get(fieldBindingDescr.getIdentifier());
        if (declaration != null) {
            this.errors.add(new RuleError(this.rule, fieldBindingDescr, null, "Duplicate declaration for variable '" + fieldBindingDescr.getIdentifier() + "' in the rule '" + this.rule.getName() + "'"));
            return;
        }
        Class clazz = ((ClassObjectType)column.getObjectType()).getClassType();
        FieldExtractor fieldExtractor = this.getFieldExtractor(fieldBindingDescr, clazz, fieldBindingDescr.getFieldName());
        if (fieldExtractor == null) {
            return;
        }
        declaration = column.addDeclaration(fieldBindingDescr.getIdentifier(), (Extractor)fieldExtractor);
        this.declarations.put(declaration.getIdentifier(), declaration);
        if (this.notDeclarations != null) {
            this.notDeclarations.put(declaration.getIdentifier(), declaration);
        }
    }

    private void build(Column column, BoundVariableDescr boundVariableDescr) {
        if (boundVariableDescr.getIdentifier() == null || boundVariableDescr.getIdentifier().equals("")) {
            this.errors.add(new RuleError(this.rule, boundVariableDescr, null, "Identifier not defined for binding field '" + boundVariableDescr.getFieldName() + "'"));
            return;
        }
        Class clazz = ((ClassObjectType)column.getObjectType()).getClassType();
        FieldExtractor fieldExtractor = this.getFieldExtractor(boundVariableDescr, clazz, boundVariableDescr.getFieldName());
        if (fieldExtractor == null) {
            return;
        }
        Declaration declaration = (Declaration)this.declarations.get(boundVariableDescr.getIdentifier());
        if (declaration == null) {
            this.errors.add(new RuleError(this.rule, boundVariableDescr, null, "Unable to return Declaration for identifier '" + boundVariableDescr.getIdentifier() + "'"));
            return;
        }
        Evaluator evaluator = this.getEvaluator(boundVariableDescr, fieldExtractor.getObjectType().getValueType(), boundVariableDescr.getEvaluator());
        if (evaluator == null) {
            return;
        }
        column.addConstraint((FieldConstraint)new BoundVariableConstraint(fieldExtractor, declaration, evaluator));
    }

    private void build(Column column, LiteralDescr literalDescr) {
        Class clazz = ((ClassObjectType)column.getObjectType()).getClassType();
        FieldExtractor fieldExtractor = this.getFieldExtractor(literalDescr, clazz, literalDescr.getFieldName());
        if (fieldExtractor == null) {
            return;
        }
        FieldValue fieldValue = null;
        if (literalDescr.isStaticFieldValue()) {
            int n = literalDescr.getText().lastIndexOf(46);
            String string = literalDescr.getText().substring(0, n);
            String string2 = literalDescr.getText().substring(n + 1);
            try {
                Class clazz2 = this.typeResolver.resolveType(string);
                fieldValue = new FieldImpl(clazz2.getField(string2).get(null));
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.errors.add(new RuleError(this.rule, literalDescr, classNotFoundException, classNotFoundException.getMessage()));
            }
            catch (Exception exception) {
                this.errors.add(new RuleError(this.rule, literalDescr, exception, "Unable to create a Field value of type  '" + fieldExtractor.getObjectType().getValueType() + "' and value '" + literalDescr.getText() + "'"));
            }
        } else {
            try {
                fieldValue = FieldFactory.getFieldValue((String)literalDescr.getText(), (int)fieldExtractor.getObjectType().getValueType());
            }
            catch (Exception exception) {
                this.errors.add(new RuleError(this.rule, literalDescr, exception, "Unable to create a Field value of type  '" + fieldExtractor.getObjectType().getValueType() + "' and value '" + literalDescr.getText() + "'"));
            }
        }
        Evaluator evaluator = this.getEvaluator(literalDescr, fieldExtractor.getObjectType().getValueType(), literalDescr.getEvaluator());
        if (evaluator == null) {
            return;
        }
        column.addConstraint((FieldConstraint)new LiteralConstraint(fieldValue, fieldExtractor, evaluator));
    }

    private void build(Column column, ReturnValueDescr returnValueDescr) {
        String string = "returnValue" + this.counter++;
        returnValueDescr.setClassMethodName(string);
        List[] listArray = this.getUsedIdentifiers(returnValueDescr, returnValueDescr.getText());
        Declaration[] declarationArray = new Declaration[listArray[0].size()];
        int n = listArray[0].size();
        for (int i = 0; i < n; ++i) {
            declarationArray[i] = (Declaration)this.declarations.get((String)listArray[0].get(i));
        }
        Class clazz = ((ClassObjectType)column.getObjectType()).getClassType();
        FieldExtractor fieldExtractor = this.getFieldExtractor(returnValueDescr, clazz, returnValueDescr.getFieldName());
        if (fieldExtractor == null) {
            return;
        }
        Evaluator evaluator = this.getEvaluator(returnValueDescr, fieldExtractor.getObjectType().getValueType(), returnValueDescr.getEvaluator());
        if (evaluator == null) {
            return;
        }
        ReturnValueConstraint returnValueConstraint = new ReturnValueConstraint(fieldExtractor, declarationArray, evaluator);
        column.addConstraint((FieldConstraint)returnValueConstraint);
        StringTemplate stringTemplate = ruleGroup.getInstanceOf("returnValueMethod");
        this.setStringTemplateAttributes(stringTemplate, declarationArray, listArray[1].toArray(new String[listArray[1].size()]), returnValueDescr.getText());
        stringTemplate.setAttribute("methodName", (Object)string);
        String string2 = functionFixer.fix(returnValueDescr.getText());
        stringTemplate.setAttribute("text", (Object)string2);
        this.methods.add(stringTemplate.toString());
        stringTemplate = invokerGroup.getInstanceOf("returnValueInvoker");
        stringTemplate.setAttribute("package", (Object)this.pkg.getName());
        stringTemplate.setAttribute("ruleClassName", (Object)this.ucFirst(this.ruleDescr.getClassName()));
        stringTemplate.setAttribute("invokerClassName", (Object)(this.ruleDescr.getClassName() + this.ucFirst(string) + "Invoker"));
        stringTemplate.setAttribute("methodName", (Object)string);
        this.setStringTemplateAttributes(stringTemplate, declarationArray, listArray[1].toArray(new String[listArray[1].size()]), returnValueDescr.getText());
        stringTemplate.setAttribute("hashCode", string2.hashCode());
        String string3 = this.pkg.getName() + "." + this.ruleDescr.getClassName() + this.ucFirst(string) + "Invoker";
        this.invokers.put(string3, stringTemplate.toString());
        this.invokerLookups.put(string3, returnValueConstraint);
        this.descrLookups.put(string3, returnValueDescr);
    }

    private void build(Column column, PredicateDescr predicateDescr) {
        String string = "predicate" + this.counter++;
        predicateDescr.setClassMethodName(string);
        Class clazz = ((ClassObjectType)column.getObjectType()).getClassType();
        FieldExtractor fieldExtractor = this.getFieldExtractor(predicateDescr, clazz, predicateDescr.getFieldName());
        if (fieldExtractor == null) {
            return;
        }
        Declaration declaration = column.addDeclaration(predicateDescr.getDeclaration(), (Extractor)fieldExtractor);
        this.declarations.put(declaration.getIdentifier(), declaration);
        if (this.notDeclarations != null) {
            this.notDeclarations.put(declaration.getIdentifier(), declaration);
        }
        List[] listArray = this.getUsedIdentifiers(predicateDescr, predicateDescr.getText());
        listArray[0].remove(predicateDescr.getDeclaration());
        Declaration[] declarationArray = new Declaration[listArray[0].size()];
        int n = listArray[0].size();
        for (int i = 0; i < n; ++i) {
            declarationArray[i] = (Declaration)this.declarations.get((String)listArray[0].get(i));
        }
        PredicateConstraint predicateConstraint = new PredicateConstraint(declaration, declarationArray);
        column.addConstraint((FieldConstraint)predicateConstraint);
        StringTemplate stringTemplate = ruleGroup.getInstanceOf("predicateMethod");
        stringTemplate.setAttribute("declaration", (Object)declaration);
        stringTemplate.setAttribute("declarationType", (Object)((ClassObjectType)declaration.getObjectType()).getClassType().getName().replace('$', '.'));
        this.setStringTemplateAttributes(stringTemplate, declarationArray, listArray[1].toArray(new String[listArray[1].size()]), predicateDescr.getText());
        stringTemplate.setAttribute("methodName", (Object)string);
        String string2 = functionFixer.fix(predicateDescr.getText());
        stringTemplate.setAttribute("text", (Object)string2);
        this.methods.add(stringTemplate.toString());
        stringTemplate = invokerGroup.getInstanceOf("predicateInvoker");
        stringTemplate.setAttribute("package", (Object)this.pkg.getName());
        stringTemplate.setAttribute("ruleClassName", (Object)this.ucFirst(this.ruleDescr.getClassName()));
        stringTemplate.setAttribute("invokerClassName", (Object)(this.ruleDescr.getClassName() + this.ucFirst(string) + "Invoker"));
        stringTemplate.setAttribute("methodName", (Object)string);
        stringTemplate.setAttribute("declaration", (Object)declaration);
        stringTemplate.setAttribute("declarationType", (Object)((ClassObjectType)declaration.getObjectType()).getClassType().getName().replace('$', '.'));
        this.setStringTemplateAttributes(stringTemplate, declarationArray, listArray[1].toArray(new String[listArray[1].size()]), predicateDescr.getText());
        stringTemplate.setAttribute("hashCode", string2.hashCode());
        String string3 = this.pkg.getName() + "." + this.ruleDescr.getClassName() + this.ucFirst(string) + "Invoker";
        this.invokers.put(string3, stringTemplate.toString());
        this.invokerLookups.put(string3, predicateConstraint);
        this.descrLookups.put(string3, predicateDescr);
    }

    private EvalCondition build(EvalDescr evalDescr) {
        String string = "eval" + this.counter++;
        evalDescr.setClassMethodName(string);
        List[] listArray = this.getUsedIdentifiers(evalDescr, evalDescr.getText());
        Declaration[] declarationArray = new Declaration[listArray[0].size()];
        int n = listArray[0].size();
        for (int i = 0; i < n; ++i) {
            declarationArray[i] = (Declaration)this.declarations.get((String)listArray[0].get(i));
        }
        EvalCondition evalCondition = new EvalCondition(declarationArray);
        StringTemplate stringTemplate = ruleGroup.getInstanceOf("evalMethod");
        this.setStringTemplateAttributes(stringTemplate, declarationArray, listArray[1].toArray(new String[listArray[1].size()]), evalDescr.getText());
        stringTemplate.setAttribute("methodName", (Object)string);
        String string2 = functionFixer.fix(evalDescr.getText());
        stringTemplate.setAttribute("text", (Object)string2);
        this.methods.add(stringTemplate.toString());
        stringTemplate = invokerGroup.getInstanceOf("evalInvoker");
        stringTemplate.setAttribute("package", (Object)this.pkg.getName());
        stringTemplate.setAttribute("ruleClassName", (Object)this.ucFirst(this.ruleDescr.getClassName()));
        stringTemplate.setAttribute("invokerClassName", (Object)(this.ruleDescr.getClassName() + this.ucFirst(string) + "Invoker"));
        stringTemplate.setAttribute("methodName", (Object)string);
        this.setStringTemplateAttributes(stringTemplate, declarationArray, listArray[1].toArray(new String[listArray[1].size()]), evalDescr.getText());
        stringTemplate.setAttribute("hashCode", string2.hashCode());
        String string3 = this.pkg.getName() + "." + this.ruleDescr.getClassName() + this.ucFirst(string) + "Invoker";
        this.invokers.put(string3, stringTemplate.toString());
        this.invokerLookups.put(string3, evalCondition);
        this.descrLookups.put(string3, evalDescr);
        return evalCondition;
    }

    private void buildConsequence(RuleDescr ruleDescr) {
        StringTemplate stringTemplate = ruleGroup.getInstanceOf("consequenceMethod");
        stringTemplate.setAttribute("methodName", (Object)"consequence");
        List[] listArray = this.getUsedCIdentifiers(ruleDescr, ruleDescr.getConsequence());
        Declaration[] declarationArray = new Declaration[listArray[0].size()];
        int n = listArray[0].size();
        for (int i = 0; i < n; ++i) {
            declarationArray[i] = (Declaration)this.declarations.get((String)listArray[0].get(i));
        }
        this.setStringTemplateAttributes(stringTemplate, declarationArray, listArray[1].toArray(new String[listArray[1].size()]), ruleDescr.getConsequence());
        stringTemplate.setAttribute("text", (Object)functionFixer.fix(knowledgeHelperFixer.fix(ruleDescr.getConsequence())));
        this.methods.add(stringTemplate.toString());
        stringTemplate = invokerGroup.getInstanceOf("consequenceInvoker");
        stringTemplate.setAttribute("package", (Object)this.pkg.getName());
        stringTemplate.setAttribute("ruleClassName", (Object)this.ucFirst(this.ruleDescr.getClassName()));
        stringTemplate.setAttribute("invokerClassName", (Object)(ruleDescr.getClassName() + this.ucFirst("consequence") + "Invoker"));
        stringTemplate.setAttribute("methodName", (Object)"consequence");
        this.setStringTemplateAttributes(stringTemplate, declarationArray, listArray[1].toArray(new String[listArray[1].size()]), ruleDescr.getConsequence());
        List<Declaration> list = Arrays.asList(this.rule.getDeclarations());
        int[] nArray = new int[declarationArray.length];
        int n2 = declarationArray.length;
        for (int i = 0; i < n2; ++i) {
            nArray[i] = list.indexOf(declarationArray[i]);
        }
        stringTemplate.setAttribute("indexes", (Object)nArray);
        stringTemplate.setAttribute("text", (Object)ruleDescr.getConsequence());
        String string = this.pkg.getName() + "." + ruleDescr.getClassName() + this.ucFirst("consequence") + "Invoker";
        this.invokers.put(string, stringTemplate.toString());
        this.invokerLookups.put(string, this.rule);
        this.descrLookups.put(string, ruleDescr);
    }

    private void buildRule(RuleDescr ruleDescr) {
        if (this.methods.isEmpty()) {
            this.ruleClass = null;
            return;
        }
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("package " + this.pkg.getName() + ";" + string);
        Iterator iterator = this.pkg.getImports().iterator();
        while (iterator.hasNext()) {
            stringBuffer.append("import " + iterator.next() + ";" + string);
        }
        stringBuffer.append("public class " + this.ucFirst(this.ruleDescr.getClassName()) + " {" + string);
        stringBuffer.append("    private static final long serialVersionUID  = 7952983928232702826L;" + string);
        int n = this.methods.size() - 1;
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(this.methods.get(i) + string);
        }
        String[] stringArray = stringBuffer.toString().split(string);
        this.ruleDescr.setConsequenceOffset(stringArray.length + 2);
        stringBuffer.append(this.methods.get(this.methods.size() - 1) + string);
        stringBuffer.append("}");
        this.ruleClass = stringBuffer.toString();
    }

    private void setStringTemplateAttributes(StringTemplate stringTemplate, Declaration[] declarationArray, String[] stringArray, String string) {
        String[] stringArray2 = new String[declarationArray.length];
        int n = declarationArray.length;
        for (int i = 0; i < n; ++i) {
            stringArray2[i] = ((ClassObjectType)declarationArray[i].getObjectType()).getClassType().getName().replace('$', '.');
        }
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        int n2 = stringArray.length;
        for (n = 0; n < n2; ++n) {
            arrayList.add(((Class)this.pkg.getGlobals().get(stringArray[n])).getName().replace('$', '.'));
        }
        stringTemplate.setAttribute("declarations", (Object)declarationArray);
        stringTemplate.setAttribute("declarationTypes", (Object)stringArray2);
        stringTemplate.setAttribute("globals", (Object)stringArray);
        stringTemplate.setAttribute("globalTypes", arrayList);
    }

    private String ucFirst(String string) {
        return string.toUpperCase().charAt(0) + string.substring(1);
    }

    private FieldExtractor getFieldExtractor(PatternDescr patternDescr, Class clazz, String string) {
        ClassFieldExtractor classFieldExtractor = null;
        try {
            classFieldExtractor = this.classFieldExtractorCache.getExtractor(clazz, string);
        }
        catch (RuntimeDroolsException runtimeDroolsException) {
            this.errors.add(new RuleError(this.rule, patternDescr, (Object)runtimeDroolsException, "Unable to create Field Extractor for '" + string + "'"));
        }
        return classFieldExtractor;
    }

    private Evaluator getEvaluator(PatternDescr patternDescr, int n, String string) {
        Evaluator evaluator = EvaluatorFactory.getEvaluator((int)n, (String)string);
        if (evaluator == null) {
            this.errors.add(new RuleError(this.rule, patternDescr, null, "Unable to determine the Evaluator for  '" + n + "' and '" + string + "'"));
        }
        return evaluator;
    }

    private List[] getUsedIdentifiers(PatternDescr patternDescr, String string) {
        List[] listArray = null;
        try {
            listArray = this.analyzer.analyzeExpression(string, new Set[]{this.declarations.keySet(), this.pkg.getGlobals().keySet()});
        }
        catch (Exception exception) {
            this.errors.add(new RuleError(this.rule, patternDescr, null, "Unable to determine the used declarations"));
        }
        return listArray;
    }

    private List[] getUsedCIdentifiers(PatternDescr patternDescr, String string) {
        List[] listArray = null;
        try {
            listArray = this.analyzer.analyzeBlock(string, new Set[]{this.declarations.keySet(), this.pkg.getGlobals().keySet()});
        }
        catch (Exception exception) {
            this.errors.add(new RuleError(this.rule, patternDescr, null, "Unable to determine the used declarations"));
        }
        return listArray;
    }

    static class ColumnCounter {
        private int value = -1;
        private GroupElement ge;

        ColumnCounter() {
        }

        public void setParent(GroupElement groupElement) {
            this.ge = groupElement;
        }

        public int getNext() {
            return ++this.value;
        }
    }
}

