/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.drools.FactException;
import org.drools.RuleBaseConfiguration;
import org.drools.common.DefaultFactHandle;
import org.drools.common.NodeMemory;
import org.drools.common.PropagationContextImpl;
import org.drools.reteoo.BaseNode;
import org.drools.reteoo.ObjectSink;
import org.drools.reteoo.ObjectSinkList;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.ReteooWorkingMemory;
import org.drools.spi.FieldConstraint;
import org.drools.spi.PropagationContext;

class AlphaNode
extends ObjectSource
implements ObjectSink,
NodeMemory {
    private static final long serialVersionUID = 8936511451364612838L;
    private final FieldConstraint constraint;
    private final ObjectSource objectSource;

    AlphaNode(int n, FieldConstraint fieldConstraint, ObjectSource objectSource) {
        this(n, null, fieldConstraint, objectSource);
    }

    AlphaNode(int n, ObjectSinkList objectSinkList, FieldConstraint fieldConstraint, ObjectSource objectSource) {
        super(n, objectSinkList);
        this.constraint = fieldConstraint;
        this.objectSource = objectSource;
        this.setHasMemory(true);
    }

    public FieldConstraint getConstraint() {
        return this.constraint;
    }

    public void attach() {
        this.objectSource.addObjectSink(this);
    }

    public void attach(ReteooWorkingMemory[] reteooWorkingMemoryArray) {
        this.attach();
        int n = reteooWorkingMemoryArray.length;
        for (int i = 0; i < n; ++i) {
            ReteooWorkingMemory reteooWorkingMemory = reteooWorkingMemoryArray[i];
            PropagationContextImpl propagationContextImpl = new PropagationContextImpl(reteooWorkingMemory.getNextPropagationIdCounter(), 3, null, null);
            this.objectSource.updateNewNode(reteooWorkingMemory, propagationContextImpl);
        }
    }

    public void assertObject(DefaultFactHandle defaultFactHandle, PropagationContext propagationContext, ReteooWorkingMemory reteooWorkingMemory) throws FactException {
        Set set = (Set)reteooWorkingMemory.getNodeMemory(this);
        if (this.constraint.isAllowed(defaultFactHandle, null, reteooWorkingMemory)) {
            set.add(defaultFactHandle);
            this.propagateAssertObject(defaultFactHandle, propagationContext, reteooWorkingMemory);
        }
    }

    public void retractObject(DefaultFactHandle defaultFactHandle, PropagationContext propagationContext, ReteooWorkingMemory reteooWorkingMemory) {
        Set set = (Set)reteooWorkingMemory.getNodeMemory(this);
        if (set.remove(defaultFactHandle)) {
            this.propagateRetractObject(defaultFactHandle, propagationContext, reteooWorkingMemory);
        }
    }

    public void modifyObject(DefaultFactHandle defaultFactHandle, PropagationContext propagationContext, ReteooWorkingMemory reteooWorkingMemory) {
        Set set = (Set)reteooWorkingMemory.getNodeMemory(this);
        if (this.constraint.isAllowed(defaultFactHandle, null, reteooWorkingMemory)) {
            if (set.add(defaultFactHandle)) {
                this.propagateAssertObject(defaultFactHandle, propagationContext, reteooWorkingMemory);
            } else {
                this.propagateModifyObject(defaultFactHandle, propagationContext, reteooWorkingMemory);
            }
        } else if (set.remove(defaultFactHandle)) {
            this.propagateRetractObject(defaultFactHandle, propagationContext, reteooWorkingMemory);
        }
    }

    public void updateNewNode(ReteooWorkingMemory reteooWorkingMemory, PropagationContext propagationContext) {
        this.attachingNewNode = true;
        Set set = (Set)reteooWorkingMemory.getNodeMemory(this);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            DefaultFactHandle defaultFactHandle = (DefaultFactHandle)iterator.next();
            ObjectSink objectSink = this.objectSinks.getLastObjectSink();
            if (objectSink != null) {
                objectSink.assertObject(defaultFactHandle, propagationContext, reteooWorkingMemory);
                continue;
            }
            throw new RuntimeException("Possible BUG: trying to propagate an assert to a node that was the last added node");
        }
        this.attachingNewNode = false;
    }

    public void remove(BaseNode baseNode, ReteooWorkingMemory[] reteooWorkingMemoryArray) {
        this.objectSinks.remove((ObjectSink)((Object)baseNode));
        this.removeShare();
        if (this.sharedCount < 0) {
            int n = reteooWorkingMemoryArray.length;
            for (int i = 0; i < n; ++i) {
                reteooWorkingMemoryArray[i].clearNodeMemory(this);
            }
            this.objectSource.remove(this, reteooWorkingMemoryArray);
        }
    }

    public Object createMemory(RuleBaseConfiguration ruleBaseConfiguration) {
        return new HashSet();
    }

    public String toString() {
        return "[AlphaNode constraint=" + this.constraint + "]";
    }

    public int hashCode() {
        return this.objectSource.hashCode() * 17 + (this.constraint != null ? this.constraint.hashCode() : 0);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        AlphaNode alphaNode = (AlphaNode)object;
        return this.objectSource.equals(alphaNode.objectSource) && this.constraint.equals(alphaNode.constraint);
    }
}

