/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.drools.model;

import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.messaging.RobustInOnly;
import javax.xml.transform.Source;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.client.ServiceMixClient;
import org.apache.servicemix.client.ServiceMixClientFacade;
import org.apache.servicemix.common.Endpoint;
import org.apache.servicemix.common.EndpointSupport;
import org.apache.servicemix.drools.DroolsEndpoint;
import org.apache.servicemix.drools.model.Exchange;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;
import org.apache.servicemix.jbi.jaxp.StringSource;
import org.apache.servicemix.jbi.resolver.URIResolver;
import org.apache.servicemix.jbi.util.MessageUtil;
import org.drools.FactHandle;
import org.drools.WorkingMemory;
import org.drools.event.ActivationCreatedEvent;
import org.drools.event.AgendaEventListener;
import org.drools.event.DefaultAgendaEventListener;

public class JbiHelper
extends DefaultAgendaEventListener {
    private DroolsEndpoint endpoint;
    private Exchange exchange;
    private WorkingMemory memory;
    private FactHandle exchangeFactHandle;
    private int rulesFired;
    private boolean exchangeHandled;

    public JbiHelper(DroolsEndpoint endpoint, MessageExchange exchange, WorkingMemory memory) {
        this.endpoint = endpoint;
        this.exchange = new Exchange(exchange, endpoint.getNamespaceContext());
        this.memory = memory;
        this.memory.addEventListener((AgendaEventListener)this);
        this.exchangeFactHandle = this.memory.assertObject((Object)this.exchange);
    }

    public DroolsEndpoint getEndpoint() {
        return this.endpoint;
    }

    public ComponentContext getContext() {
        return this.endpoint.getContext();
    }

    public DeliveryChannel getChannel() throws MessagingException {
        return this.getContext().getDeliveryChannel();
    }

    public ServiceMixClient getClient() {
        return new ServiceMixClientFacade(this.getContext());
    }

    public Exchange getExchange() {
        return this.exchange;
    }

    public Log getLogger() {
        return LogFactory.getLog((String)this.memory.getRuleBase().getPackages()[0].getName());
    }

    public void route(String uri) throws MessagingException {
        this.routeTo(null, uri);
    }

    public void routeTo(String content, String uri) throws MessagingException {
        MessageExchange me = this.exchange.getInternalExchange();
        NormalizedMessage in = null;
        if (content == null) {
            in = me.getMessage("in");
        } else {
            in = me.createMessage();
            in.setContent((Source)new StringSource(content));
        }
        MessageExchange newMe = this.getChannel().createExchangeFactory().createExchange(me.getPattern());
        URIResolver.configureExchange((MessageExchange)newMe, (ComponentContext)this.getContext(), (String)uri);
        MessageUtil.transferToIn((NormalizedMessage)in, (MessageExchange)newMe);
        String key = EndpointSupport.getKey((Endpoint)this.endpoint);
        newMe.setProperty("org.apache.servicemix.senderEndpoint", (Object)key);
        newMe.setProperty("org.apache.servicemix.correlationId", (Object)DroolsEndpoint.getCorrelationId(this.exchange.getInternalExchange()));
        newMe.setProperty("org.apache.servicemix.drools.correlation_id", (Object)me.getExchangeId());
        this.getChannel().send(newMe);
    }

    public void routeToDefault(String content) throws MessagingException {
        this.routeTo(content, this.endpoint.getDefaultRouteURI());
    }

    @Deprecated
    public void sendTo(String content, String uri) throws MessagingException {
        NormalizedMessage in;
        MessageExchange me = this.exchange.getInternalExchange();
        if (me instanceof InOnly || me instanceof RobustInOnly) {
            in = null;
            if (content == null) {
                in = me.getMessage("in");
            } else {
                in = me.createMessage();
                in.setContent((Source)new StringSource(content));
            }
        } else {
            throw new IllegalStateException("sendTo() method should be used for InOnly or RobustInOnly");
        }
        MessageExchange newMe = this.getChannel().createExchangeFactory().createExchange(me.getPattern());
        URIResolver.configureExchange((MessageExchange)newMe, (ComponentContext)this.getContext(), (String)uri);
        MessageUtil.transferToIn((NormalizedMessage)in, (MessageExchange)newMe);
        me.setStatus(ExchangeStatus.DONE);
        this.getChannel().send(me);
        this.getChannel().send(newMe);
        this.update();
    }

    public void fault(String content) throws Exception {
        this.fault((Source)new StringSource(content));
    }

    public void fault(Source content) throws Exception {
        MessageExchange me = this.exchange.getInternalExchange();
        if (me instanceof InOnly) {
            me.setError(new Exception(new SourceTransformer().toString(content)));
            this.getChannel().send(me);
        } else {
            Fault fault = me.createFault();
            fault.setContent(content);
            me.setFault(fault);
            this.getChannel().send(me);
        }
        this.exchangeHandled = true;
    }

    public void answer(String content) throws Exception {
        this.answer((Source)new StringSource(content));
    }

    public void answer(Source content) throws Exception {
        MessageExchange me = this.exchange.getInternalExchange();
        NormalizedMessage out = me.createMessage();
        out.setContent(content);
        me.setMessage(out, "out");
        this.getChannel().sendSync(me);
        this.exchangeHandled = true;
        this.update();
    }

    public void update() {
        this.memory.modifyObject(this.exchangeFactHandle, (Object)this.exchange);
    }

    public int getRulesFired() {
        return this.rulesFired;
    }

    public boolean isExchangeHandled() {
        return this.exchangeHandled;
    }

    public void activationCreated(ActivationCreatedEvent event) {
        ++this.rulesFired;
    }
}

