/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang.dsl;

import java.util.StringTokenizer;
import org.drools.lang.Expander;

public class LineBasedExpander {
    private String source;
    private StringBuffer output = new StringBuffer();
    private boolean lhs;
    private boolean rhs;
    private int lineNumber = 0;
    private Expander expander;

    public LineBasedExpander(String string, Expander expander) {
        this.source = string;
        this.expander = expander;
    }

    public String expand() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.source, "\r\n");
        while (stringTokenizer.hasMoreTokens()) {
            ++this.lineNumber;
            String string = stringTokenizer.nextToken();
            String string2 = string.trim();
            if (this.matchesKeyword("when", string2)) {
                this.lhs();
                this.appendLine(string);
                continue;
            }
            if (this.matchesKeyword("then", string2)) {
                this.rhs();
                this.appendLine(string);
                continue;
            }
            if (this.matchesKeyword("end", string2)) {
                this.endRule();
                this.appendLine(string);
                this.output.append("\n");
                continue;
            }
            if (this.matchesKeyword("query", string2)) {
                this.query();
                this.appendLine(string);
                continue;
            }
            this.consume(string);
        }
        return this.output.toString();
    }

    private void appendLine(String string) {
        this.output.append(string);
        this.output.append("\n");
    }

    public String getExpanded() {
        return this.output.toString();
    }

    private void consume(String string) {
        if (this.lhs) {
            this.appendLine(this.expand("when", string));
        } else if (this.rhs) {
            this.appendLine(this.expand("then", string));
        } else {
            this.appendLine(string);
        }
    }

    private String expand(String string, String string2) {
        String string3 = string2.trim();
        if (string3.startsWith(">")) {
            return string2.substring(1);
        }
        return "\t\t" + this.expander.expand(string, this.normaliseSpaces(string2));
    }

    boolean matchesKeyword(String string, String string2) {
        if (string2.length() < string.length()) {
            return false;
        }
        if (!string2.startsWith(string)) {
            return false;
        }
        String string3 = string2.substring(string.length()).trim();
        if (string3.length() == 0) {
            return true;
        }
        char c = string3.charAt(0);
        return c == '#' || c == '/';
    }

    String normaliseSpaces(String string) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.trim().toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (Character.isWhitespace(c) && !bl && !bl2) {
                if (bl3) continue;
                stringBuffer.append(' ');
                bl3 = true;
                continue;
            }
            bl3 = false;
            if (c == '\'') {
                boolean bl4 = bl = !bl;
            }
            if (c == '\"') {
                bl2 = !bl2;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private void query() {
        this.lhs();
    }

    private void endRule() {
        this.lhs = false;
        this.rhs = false;
    }

    private void rhs() {
        this.rhs = true;
        this.lhs = false;
    }

    private void lhs() {
        this.lhs = true;
    }
}

