/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.test;

import org.antlr.analysis.DFA;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.test.unit.TestSuite;
import org.antlr.tool.Grammar;

public class TestDFAMatching
extends TestSuite {
    public void testSimpleAltCharTest() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : {;}'a' | 'b' | 'c';");
        grammar.createNFAs();
        grammar.createLookaheadDFAs();
        DFA dFA = grammar.getLookaheadDFA(1);
        this.checkPrediction(dFA, "a", 1);
        this.checkPrediction(dFA, "b", 2);
        this.checkPrediction(dFA, "c", 3);
        this.checkPrediction(dFA, "d", -1);
    }

    public void testSets() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : {;}'a'..'z' | ';' | '0'..'9' ;");
        grammar.createNFAs();
        grammar.createLookaheadDFAs();
        DFA dFA = grammar.getLookaheadDFA(1);
        this.checkPrediction(dFA, "a", 1);
        this.checkPrediction(dFA, "q", 1);
        this.checkPrediction(dFA, "z", 1);
        this.checkPrediction(dFA, ";", 2);
        this.checkPrediction(dFA, "9", 3);
    }

    public void testFiniteCommonLeftPrefixes() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a' 'b' | 'a' 'c' | 'd' 'e' ;");
        grammar.createNFAs();
        grammar.createLookaheadDFAs();
        DFA dFA = grammar.getLookaheadDFA(1);
        this.checkPrediction(dFA, "ab", 1);
        this.checkPrediction(dFA, "ac", 2);
        this.checkPrediction(dFA, "de", 3);
        this.checkPrediction(dFA, "q", -1);
    }

    public void testSimpleLoops() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : (DIGIT)+ '.' DIGIT | (DIGIT)+ ;\nfragment DIGIT : '0'..'9' ;\n");
        grammar.createNFAs();
        grammar.createLookaheadDFAs();
        DFA dFA = grammar.getLookaheadDFA(3);
        this.checkPrediction(dFA, "32", 2);
        this.checkPrediction(dFA, "999.2", 1);
        this.checkPrediction(dFA, ".2", -1);
    }

    protected void checkPrediction(DFA dFA, String string, int n) throws Exception {
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream(string);
        this.assertEqual(dFA.predict(aNTLRStringStream), n);
    }
}

