/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.tool;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.antlr.tool.ErrorManager;
import org.antlr.tool.Grammar;
import org.antlr.tool.Rule;

public class GrammarReport {
    public static final String Version = "1";
    public static final String GRAMMAR_STATS_FILENAME = "grammar.stats";
    public static final String ANTLRWORKS_DIR = "antlrworks";
    public static final int NUM_GRAMMAR_STATS = 32;
    public Grammar grammar;

    public GrammarReport(Grammar grammar) {
        this.grammar = grammar;
    }

    public String toNotifyString() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Version);
        stringBuffer.append('\t');
        stringBuffer.append(this.grammar.name);
        stringBuffer.append('\t');
        stringBuffer.append(Grammar.grammarTypeToString[this.grammar.type]);
        stringBuffer.append('\t');
        stringBuffer.append(this.grammar.getOption("language"));
        stringBuffer.append('\t');
        stringBuffer.append(this.grammar.getRules().size());
        stringBuffer.append('\t');
        int n = 0;
        Collection collection = this.grammar.getRules();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            object = (Rule)iterator.next();
            n += ((Rule)object).numberOfAlts;
        }
        stringBuffer.append(n);
        stringBuffer.append('\t');
        stringBuffer.append(this.grammar.getNumberOfDecisions());
        stringBuffer.append('\t');
        stringBuffer.append(this.grammar.getNumberOfCyclicDecisions());
        stringBuffer.append('\t');
        int n2 = this.grammar.getNumberOfDecisions() - this.grammar.getNumberOfCyclicDecisions();
        object = new int[n2];
        int[] nArray = new int[n2];
        int[] nArray2 = new int[this.grammar.getNumberOfCyclicDecisions()];
        int n3 = 0;
        int n4 = 0;
        for (int i = 1; i <= this.grammar.getNumberOfDecisions(); ++i) {
            Grammar.Decision decision = this.grammar.getDecision(i);
            if (!decision.dfa.isCyclic()) {
                int n5 = decision.dfa.getMaxLookaheadDepth();
                object[n3] = n5;
                nArray[n3] = decision.dfa.getNumberOfStates();
                ++n3;
                continue;
            }
            nArray2[n4] = decision.dfa.getNumberOfStates();
            ++n4;
        }
        stringBuffer.append(GrammarReport.min((int[])object));
        stringBuffer.append('\t');
        stringBuffer.append(GrammarReport.max((int[])object));
        stringBuffer.append('\t');
        stringBuffer.append(GrammarReport.avg((int[])object));
        stringBuffer.append('\t');
        stringBuffer.append(GrammarReport.stddev((int[])object));
        stringBuffer.append('\t');
        stringBuffer.append(GrammarReport.min(nArray));
        stringBuffer.append('\t');
        stringBuffer.append(GrammarReport.max(nArray));
        stringBuffer.append('\t');
        stringBuffer.append(GrammarReport.avg(nArray));
        stringBuffer.append('\t');
        stringBuffer.append(GrammarReport.stddev(nArray));
        stringBuffer.append('\t');
        stringBuffer.append(GrammarReport.sum(nArray));
        stringBuffer.append('\t');
        stringBuffer.append(GrammarReport.min(nArray2));
        stringBuffer.append('\t');
        stringBuffer.append(GrammarReport.max(nArray2));
        stringBuffer.append('\t');
        stringBuffer.append(GrammarReport.avg(nArray2));
        stringBuffer.append('\t');
        stringBuffer.append(GrammarReport.stddev(nArray2));
        stringBuffer.append('\t');
        stringBuffer.append(GrammarReport.sum(nArray2));
        stringBuffer.append('\t');
        stringBuffer.append(this.grammar.getTokenTypes().size());
        stringBuffer.append('\t');
        stringBuffer.append(this.grammar.DFACreationWallClockTimeInMS);
        stringBuffer.append('\t');
        stringBuffer.append(this.grammar.numberOfSemanticPredicates);
        stringBuffer.append('\t');
        stringBuffer.append(this.grammar.numberOfManualLookaheadOptions);
        stringBuffer.append('\t');
        stringBuffer.append(this.grammar.setOfNondeterministicDecisionNumbers.size());
        stringBuffer.append('\t');
        stringBuffer.append(this.grammar.setOfNondeterministicDecisionNumbersResolvedWithPredicates.size());
        stringBuffer.append('\t');
        stringBuffer.append(this.grammar.numberOfDFAConversionsTerminatedEarly);
        stringBuffer.append('\t');
        stringBuffer.append(ErrorManager.getErrorCount().errors);
        stringBuffer.append('\t');
        stringBuffer.append(ErrorManager.getErrorCount().warnings);
        stringBuffer.append('\t');
        stringBuffer.append(ErrorManager.getErrorCount().infos);
        return stringBuffer.toString();
    }

    public String toString() {
        return GrammarReport.toString(this.toNotifyString());
    }

    protected static String[] decodeReportData(String string) {
        String[] stringArray = new String[32];
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n] = stringTokenizer.nextToken();
            ++n;
        }
        if (n != 32) {
            return null;
        }
        return stringArray;
    }

    public static String toString(String string) {
        String[] stringArray = GrammarReport.decodeReportData(string);
        if (stringArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ANTLR Grammar Report; Stats Version ");
        stringBuffer.append(stringArray[0]);
        stringBuffer.append('\n');
        stringBuffer.append("Grammar: ");
        stringBuffer.append(stringArray[1]);
        stringBuffer.append('\n');
        stringBuffer.append("Type: ");
        stringBuffer.append(stringArray[2]);
        stringBuffer.append('\n');
        stringBuffer.append("Target language: ");
        stringBuffer.append(stringArray[3]);
        stringBuffer.append('\n');
        stringBuffer.append("Rules: ");
        stringBuffer.append(stringArray[4]);
        stringBuffer.append('\n');
        stringBuffer.append("Productions: ");
        stringBuffer.append(stringArray[5]);
        stringBuffer.append('\n');
        stringBuffer.append("Decisions: ");
        stringBuffer.append(stringArray[6]);
        stringBuffer.append('\n');
        stringBuffer.append("Cyclic DFA decisions: ");
        stringBuffer.append(stringArray[7]);
        stringBuffer.append('\n');
        stringBuffer.append("Min fixed k: ");
        stringBuffer.append(stringArray[8]);
        stringBuffer.append('\n');
        stringBuffer.append("Max fixed k: ");
        stringBuffer.append(stringArray[9]);
        stringBuffer.append('\n');
        stringBuffer.append("Average fixed k: ");
        stringBuffer.append(stringArray[10]);
        stringBuffer.append('\n');
        stringBuffer.append("Standard deviation of fixed k: ");
        stringBuffer.append(stringArray[11]);
        stringBuffer.append('\n');
        stringBuffer.append("Min acyclic DFA states: ");
        stringBuffer.append(stringArray[12]);
        stringBuffer.append('\n');
        stringBuffer.append("Max acyclic DFA states: ");
        stringBuffer.append(stringArray[13]);
        stringBuffer.append('\n');
        stringBuffer.append("Average acyclic DFA states: ");
        stringBuffer.append(stringArray[14]);
        stringBuffer.append('\n');
        stringBuffer.append("Standard deviation of acyclic DFA states: ");
        stringBuffer.append(stringArray[15]);
        stringBuffer.append('\n');
        stringBuffer.append("Total acyclic DFA states: ");
        stringBuffer.append(stringArray[16]);
        stringBuffer.append('\n');
        stringBuffer.append("Min cyclic DFA states: ");
        stringBuffer.append(stringArray[17]);
        stringBuffer.append('\n');
        stringBuffer.append("Max cyclic DFA states: ");
        stringBuffer.append(stringArray[18]);
        stringBuffer.append('\n');
        stringBuffer.append("Average cyclic DFA states: ");
        stringBuffer.append(stringArray[19]);
        stringBuffer.append('\n');
        stringBuffer.append("Standard deviation of cyclic DFA states: ");
        stringBuffer.append(stringArray[20]);
        stringBuffer.append('\n');
        stringBuffer.append("Total cyclic DFA states: ");
        stringBuffer.append(stringArray[21]);
        stringBuffer.append('\n');
        stringBuffer.append("Vocabulary size: ");
        stringBuffer.append(stringArray[22]);
        stringBuffer.append('\n');
        stringBuffer.append("DFA creation time in ms: ");
        stringBuffer.append(stringArray[23]);
        stringBuffer.append('\n');
        stringBuffer.append("Number of semantic predicates: ");
        stringBuffer.append(stringArray[24]);
        stringBuffer.append('\n');
        stringBuffer.append("Number of manual fixed lookahead k=value options: ");
        stringBuffer.append(stringArray[25]);
        stringBuffer.append('\n');
        stringBuffer.append("Number of nondeterministic decisions: ");
        stringBuffer.append(stringArray[26]);
        stringBuffer.append('\n');
        stringBuffer.append("Number of nondeterministic decisions resolved with predicates: ");
        stringBuffer.append(stringArray[27]);
        stringBuffer.append('\n');
        stringBuffer.append("Number of DFA conversions terminated early: ");
        stringBuffer.append(stringArray[28]);
        stringBuffer.append('\n');
        stringBuffer.append("Number of errors: ");
        stringBuffer.append(stringArray[29]);
        stringBuffer.append('\n');
        stringBuffer.append("Number of warnings: ");
        stringBuffer.append(stringArray[30]);
        stringBuffer.append('\n');
        stringBuffer.append("Number of infos: ");
        stringBuffer.append(stringArray[31]);
        stringBuffer.append('\n');
        return stringBuffer.toString();
    }

    public static void writeReport(String string, String string2) {
        String string3 = GrammarReport.getAbsoluteFileName(string);
        File file = new File(string3);
        File file2 = file.getParentFile();
        file2.mkdirs();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file, true);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            PrintStream printStream = new PrintStream(bufferedOutputStream);
            printStream.println(string2);
            printStream.close();
            bufferedOutputStream.close();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            ErrorManager.internalError("can't write stats to " + string3, iOException);
        }
    }

    public static String getAbsoluteFileName(String string) {
        return System.getProperty("user.home") + File.separator + ANTLRWORKS_DIR + File.separator + string;
    }

    public static double stddev(int[] nArray) {
        int n = nArray.length;
        if (n <= 1) {
            return 0.0;
        }
        double d = GrammarReport.avg(nArray);
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            d2 += ((double)nArray[i] - d) * ((double)nArray[i] - d);
        }
        return Math.sqrt(d2 /= (double)(n - 1));
    }

    public static double avg(int[] nArray) {
        double d = 0.0;
        int n = nArray.length;
        if (n == 0) {
            return 0.0;
        }
        for (int i = 0; i < n; ++i) {
            d += (double)nArray[i];
        }
        if (d >= 0.0) {
            return d / (double)n;
        }
        return 0.0;
    }

    public static int min(int[] nArray) {
        int n = Integer.MAX_VALUE;
        int n2 = nArray.length;
        if (n2 == 0) {
            return 0;
        }
        for (int i = 0; i < n2; ++i) {
            if (nArray[i] >= n) continue;
            n = nArray[i];
        }
        return n;
    }

    public static int max(int[] nArray) {
        int n = Integer.MIN_VALUE;
        int n2 = nArray.length;
        if (n2 == 0) {
            return 0;
        }
        for (int i = 0; i < n2; ++i) {
            if (nArray[i] <= n) continue;
            n = nArray[i];
        }
        return n;
    }

    public static int sum(int[] nArray) {
        int n = 0;
        int n2 = nArray.length;
        if (n2 == 0) {
            return 0;
        }
        for (int i = 0; i < n2; ++i) {
            n += nArray[i];
        }
        return n;
    }
}

