/*
 * Decompiled with CFR 0.152.
 */
package org.drools.util.concurrent.locks;

import java.io.Serializable;
import java.util.Collection;
import org.drools.util.concurrent.locks.Lock;

public class ReentrantLock
implements Lock,
Serializable {
    private static final long serialVersionUID = 7373984872572414699L;
    private final NonfairSync sync = new NonfairSync();

    public void lock() {
        this.sync.lock();
    }

    public void lockInterruptibly() throws InterruptedException {
        this.sync.lockInterruptibly();
    }

    public boolean tryLock() {
        return this.sync.tryLock();
    }

    public void unlock() {
        this.sync.unlock();
    }

    public int getHoldCount() {
        return this.sync.getHoldCount();
    }

    public boolean isHeldByCurrentThread() {
        return this.sync.isHeldByCurrentThread();
    }

    public boolean isLocked() {
        return this.sync.isLocked();
    }

    protected Thread getOwner() {
        return this.sync.getOwner();
    }

    public final boolean hasQueuedThreads() {
        return this.sync.hasQueuedThreads();
    }

    public final boolean hasQueuedThread(Thread thread) {
        return this.sync.isQueued(thread);
    }

    public final int getQueueLength() {
        return this.sync.getQueueLength();
    }

    protected Collection getQueuedThreads() {
        return this.sync.getQueuedThreads();
    }

    public String toString() {
        Thread thread = this.getOwner();
        return super.toString() + (thread == null ? "[Unlocked]" : "[Locked by thread " + thread.getName() + "]");
    }

    static final class NonfairSync
    implements Serializable {
        private static final long serialVersionUID = 7316153563782823691L;
        protected transient Thread owner_ = null;
        protected transient int holds_ = 0;

        NonfairSync() {
        }

        final void incHolds() {
            int n;
            if ((n = ++this.holds_) < 0) {
                throw new Error("Maximum lock count exceeded");
            }
            this.holds_ = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean tryLock() {
            Thread thread = Thread.currentThread();
            NonfairSync nonfairSync = this;
            synchronized (nonfairSync) {
                if (this.owner_ == null) {
                    this.owner_ = thread;
                    this.holds_ = 1;
                    return true;
                }
                if (thread == this.owner_) {
                    this.incHolds();
                    return true;
                }
            }
            return false;
        }

        public synchronized int getHoldCount() {
            return this.isHeldByCurrentThread() ? this.holds_ : 0;
        }

        public synchronized boolean isHeldByCurrentThread() {
            return this.holds_ > 0 && Thread.currentThread() == this.owner_;
        }

        public synchronized boolean isLocked() {
            return this.owner_ != null;
        }

        protected synchronized Thread getOwner() {
            return this.owner_;
        }

        public boolean hasQueuedThreads() {
            throw new UnsupportedOperationException("Use FAIR version");
        }

        public int getQueueLength() {
            throw new UnsupportedOperationException("Use FAIR version");
        }

        public Collection getQueuedThreads() {
            throw new UnsupportedOperationException("Use FAIR version");
        }

        public boolean isQueued(Thread thread) {
            throw new UnsupportedOperationException("Use FAIR version");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void lock() {
            Thread thread = Thread.currentThread();
            NonfairSync nonfairSync = this;
            synchronized (nonfairSync) {
                if (this.owner_ == null) {
                    this.owner_ = thread;
                    this.holds_ = 1;
                    return;
                }
                if (thread == this.owner_) {
                    this.incHolds();
                    return;
                }
                boolean bl = Thread.interrupted();
                try {
                    do {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            bl = true;
                        }
                    } while (this.owner_ != null);
                    this.owner_ = thread;
                    this.holds_ = 1;
                    return;
                }
                finally {
                    if (bl) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        public void lockInterruptibly() throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Thread thread = Thread.currentThread();
            NonfairSync nonfairSync = this;
            synchronized (nonfairSync) {
                if (this.owner_ == null) {
                    this.owner_ = thread;
                    this.holds_ = 1;
                    return;
                }
                if (thread == this.owner_) {
                    this.incHolds();
                    return;
                }
                try {
                    do {
                        this.wait();
                    } while (this.owner_ != null);
                    this.owner_ = thread;
                    this.holds_ = 1;
                    return;
                }
                catch (InterruptedException interruptedException) {
                    if (this.owner_ == null) {
                        this.notify();
                    }
                    throw interruptedException;
                }
            }
        }

        public synchronized void unlock() {
            if (Thread.currentThread() != this.owner_) {
                throw new IllegalMonitorStateException("Not owner");
            }
            if (--this.holds_ == 0) {
                this.owner_ = null;
                this.notify();
            }
        }
    }
}

