/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.drools;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.jbi.JBIException;
import javax.jbi.management.DeploymentException;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import org.apache.servicemix.common.DefaultComponent;
import org.apache.servicemix.common.ServiceUnit;
import org.apache.servicemix.common.endpoints.ProviderEndpoint;
import org.apache.servicemix.drools.model.JbiHelper;
import org.drools.RuleBase;
import org.drools.WorkingMemory;
import org.drools.compiler.RuleBaseLoader;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DroolsEndpoint
extends ProviderEndpoint {
    private RuleBase ruleBase;
    private Resource ruleBaseResource;
    private URL ruleBaseURL;
    private NamespaceContext namespaceContext;
    private QName defaultTargetService;
    private String defaultTargetURI;
    private Map<String, Object> globals;
    private List<Object> assertedObjects;

    public DroolsEndpoint() {
    }

    public DroolsEndpoint(DefaultComponent component, ServiceEndpoint endpoint) {
        super(component, endpoint);
    }

    public DroolsEndpoint(ServiceUnit su, QName service, String endpoint) {
        super(su, service, endpoint);
    }

    public RuleBase getRuleBase() {
        return this.ruleBase;
    }

    public void setRuleBase(RuleBase ruleBase) {
        this.ruleBase = ruleBase;
    }

    public Resource getRuleBaseResource() {
        return this.ruleBaseResource;
    }

    public void setRuleBaseResource(Resource ruleBaseResource) {
        this.ruleBaseResource = ruleBaseResource;
    }

    public URL getRuleBaseURL() {
        return this.ruleBaseURL;
    }

    public void setRuleBaseURL(URL ruleBaseURL) {
        this.ruleBaseURL = ruleBaseURL;
    }

    public NamespaceContext getNamespaceContext() {
        return this.namespaceContext;
    }

    public void setNamespaceContext(NamespaceContext namespaceContext) {
        this.namespaceContext = namespaceContext;
    }

    public Map<String, Object> getGlobals() {
        return this.globals;
    }

    public void setGlobals(Map<String, Object> variables) {
        this.globals = variables;
    }

    public void validate() throws DeploymentException {
        super.validate();
        if (this.ruleBase == null && this.ruleBaseResource == null && this.ruleBaseURL == null) {
            throw new DeploymentException("Property ruleBase, ruleBaseResource or ruleBaseURL must be set");
        }
    }

    public void start() throws Exception {
        super.start();
        if (this.ruleBase == null) {
            InputStream is = null;
            try {
                if (this.ruleBaseResource != null) {
                    is = this.ruleBaseResource.getInputStream();
                } else if (this.ruleBaseURL != null) {
                    is = this.ruleBaseURL.openStream();
                } else {
                    throw new IllegalArgumentException("Property ruleBase, ruleBaseResource or ruleBaseURL must be set");
                }
                RuleBaseLoader loader = RuleBaseLoader.getInstance();
                this.ruleBase = loader.loadFromReader((Reader)new InputStreamReader(is));
            }
            catch (Exception e) {
                throw new JBIException((Throwable)e);
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
    }

    public void process(MessageExchange exchange) throws Exception {
        this.drools(exchange);
    }

    protected void drools(MessageExchange exchange) throws Exception {
        WorkingMemory memory = this.createWorkingMemory(exchange);
        this.populateWorkingMemory(memory, exchange);
        memory.fireAllRules();
        this.postProcess(exchange, memory);
    }

    protected void postProcess(MessageExchange exchange, WorkingMemory memory) throws Exception {
        String uri;
        if (exchange.getStatus() == ExchangeStatus.ACTIVE && (uri = this.getDefaultRouteURI()) != null) {
            JbiHelper helper = (JbiHelper)memory.getGlobal("jbi");
            helper.route(uri);
        }
        if (exchange.getStatus() == ExchangeStatus.ACTIVE) {
            this.fail(exchange, new Exception("No rules have handled the exchange. Check your rule base."));
        }
    }

    protected WorkingMemory createWorkingMemory(MessageExchange exchange) throws Exception {
        return this.ruleBase.newWorkingMemory();
    }

    protected void populateWorkingMemory(WorkingMemory memory, MessageExchange exchange) throws Exception {
        memory.setGlobal("jbi", (Object)new JbiHelper(this, exchange, memory));
        if (this.assertedObjects != null) {
            for (Object object : this.assertedObjects) {
                memory.assertObject(object);
            }
        }
        if (this.globals != null) {
            for (Map.Entry entry : this.globals.entrySet()) {
                memory.setGlobal((String)entry.getKey(), entry.getValue());
            }
        }
    }

    public QName getDefaultTargetService() {
        return this.defaultTargetService;
    }

    public void setDefaultTargetService(QName defaultTargetService) {
        this.defaultTargetService = defaultTargetService;
    }

    public String getDefaultTargetURI() {
        return this.defaultTargetURI;
    }

    public void setDefaultTargetURI(String defaultTargetURI) {
        this.defaultTargetURI = defaultTargetURI;
    }

    public List<Object> getAssertedObjects() {
        return this.assertedObjects;
    }

    public void setAssertedObjects(List<Object> assertedObjects) {
        this.assertedObjects = assertedObjects;
    }

    public String getDefaultRouteURI() {
        if (this.defaultTargetURI != null) {
            return this.defaultTargetURI;
        }
        if (this.defaultTargetService != null) {
            String nsURI = this.defaultTargetService.getNamespaceURI();
            String sep = nsURI.indexOf("/") > 0 ? "/" : ":";
            return "service:" + nsURI + sep + this.defaultTargetService.getLocalPart();
        }
        return null;
    }
}

