/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler;

import java.io.IOException;
import java.io.Reader;
import org.drools.CheckedDroolsException;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.compiler.PackageBuilder;
import org.drools.rule.Package;

public class RuleBaseLoader {
    private static final RuleBaseLoader INSTANCE = new RuleBaseLoader();
    private static int engineType = 1;

    private RuleBaseLoader() {
    }

    public static RuleBaseLoader getInstance() {
        return INSTANCE;
    }

    public RuleBase loadFromReader(Reader reader) throws CheckedDroolsException, IOException {
        PackageBuilder packageBuilder = new PackageBuilder();
        packageBuilder.addPackageFromDrl(reader);
        return this.makeRuleBase(packageBuilder);
    }

    public RuleBase loadFromReader(Reader reader, Reader reader2) throws CheckedDroolsException, IOException {
        PackageBuilder packageBuilder = new PackageBuilder();
        packageBuilder.addPackageFromDrl(reader, reader2);
        return this.makeRuleBase(packageBuilder);
    }

    public void setDefaultEngineType(int n) {
        engineType = n;
    }

    private RuleBase makeRuleBase(PackageBuilder packageBuilder) throws CheckedDroolsException {
        if (packageBuilder.hasErrors()) {
            throw new CheckedDroolsException("There were errors in the rule source: " + packageBuilder.printErrors());
        }
        Package package_ = packageBuilder.getPackage();
        RuleBase ruleBase = RuleBaseFactory.newRuleBase((int)engineType);
        try {
            ruleBase.addPackage(package_);
        }
        catch (Exception exception) {
            throw new CheckedDroolsException("Unable to add compiled package to rulebase. Nested error is: " + exception.getMessage());
        }
        return ruleBase;
    }
}

