/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import org.drools.RuntimeDroolsException;
import org.drools.WorkingMemory;
import org.drools.rule.ConditionalElement;
import org.drools.rule.Declaration;
import org.drools.spi.EvalExpression;
import org.drools.spi.Tuple;

public class EvalCondition
extends ConditionalElement {
    private static final long serialVersionUID = 4479634725392322326L;
    private EvalExpression expression;
    private final Declaration[] requiredDeclarations;
    private static final Declaration[] EMPTY_DECLARATIONS = new Declaration[0];

    public EvalCondition(Declaration[] declarationArray) {
        this(null, declarationArray);
    }

    public EvalCondition(EvalExpression evalExpression, Declaration[] declarationArray) {
        this.expression = evalExpression;
        this.requiredDeclarations = declarationArray == null ? EMPTY_DECLARATIONS : declarationArray;
    }

    public EvalExpression getEvalExpression() {
        return this.expression;
    }

    public void setEvalExpression(EvalExpression evalExpression) {
        this.expression = evalExpression;
    }

    public Declaration[] getRequiredDeclarations() {
        return this.requiredDeclarations;
    }

    public boolean isAllowed(Tuple tuple, WorkingMemory workingMemory) {
        try {
            return this.expression.evaluate(tuple, this.requiredDeclarations, workingMemory);
        }
        catch (Exception exception) {
            throw new RuntimeDroolsException(exception);
        }
    }

    public Object clone() {
        EvalCondition evalCondition = new EvalCondition(this.expression, this.requiredDeclarations);
        return evalCondition;
    }

    public int hashCode() {
        return this.expression.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != EvalCondition.class) {
            return false;
        }
        EvalCondition evalCondition = (EvalCondition)object;
        if (this.requiredDeclarations.length != evalCondition.requiredDeclarations.length) {
            return false;
        }
        int n = this.requiredDeclarations.length;
        for (int i = 0; i < n; ++i) {
            if (this.requiredDeclarations[i].getColumn() != evalCondition.requiredDeclarations[i].getColumn()) {
                return false;
            }
            if (this.requiredDeclarations[i].getExtractor().equals(evalCondition.requiredDeclarations[i].getExtractor())) continue;
            return false;
        }
        return this.expression.equals(evalCondition.expression);
    }
}

