/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.eip.patterns;

import javax.jbi.management.DeploymentException;
import javax.xml.namespace.NamespaceContext;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFunctionResolver;
import org.apache.servicemix.eip.support.AbstractSplitter;
import org.apache.servicemix.expression.JAXPNodeSetXPathExpression;
import org.apache.servicemix.expression.MessageVariableResolver;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathSplitter
extends AbstractSplitter {
    private JAXPNodeSetXPathExpression xpathExpression = new JAXPNodeSetXPathExpression();
    private SourceTransformer sourceTransformer = new SourceTransformer();

    public void validate() throws DeploymentException {
        super.validate();
        try {
            this.xpathExpression.afterPropertiesSet();
        }
        catch (Exception e) {
            throw new DeploymentException("Error validating xpath expression", (Throwable)e);
        }
    }

    protected Source[] split(Source main) throws Exception {
        Node doc = this.sourceTransformer.toDOMNode(main);
        NodeList nodes = (NodeList)this.xpathExpression.evaluateXPath((Object)doc);
        Source[] parts = new Source[nodes.getLength()];
        for (int i = 0; i < parts.length; ++i) {
            Document part = this.sourceTransformer.toDOMDocument(nodes.item(i));
            parts[i] = new DOMSource(part);
        }
        return parts;
    }

    public XPathFactory getFactory() {
        return this.xpathExpression.getFactory();
    }

    public XPathFunctionResolver getFunctionResolver() {
        return this.xpathExpression.getFunctionResolver();
    }

    public NamespaceContext getNamespaceContext() {
        return this.xpathExpression.getNamespaceContext();
    }

    public SourceTransformer getTransformer() {
        return this.xpathExpression.getTransformer();
    }

    public MessageVariableResolver getVariableResolver() {
        return this.xpathExpression.getVariableResolver();
    }

    public String getXPath() {
        return this.xpathExpression.getXPath();
    }

    public void setFactory(XPathFactory factory) {
        this.xpathExpression.setFactory(factory);
    }

    public void setFunctionResolver(XPathFunctionResolver functionResolver) {
        this.xpathExpression.setFunctionResolver(functionResolver);
    }

    public void setNamespaceContext(NamespaceContext namespaceContext) {
        this.xpathExpression.setNamespaceContext(namespaceContext);
    }

    public void setTransformer(SourceTransformer transformer) {
        this.xpathExpression.setTransformer(transformer);
    }

    public void setVariableResolver(MessageVariableResolver variableResolver) {
        this.xpathExpression.setVariableResolver(variableResolver);
    }

    public void setXPath(String xpath) {
        this.xpathExpression.setXPath(xpath);
    }
}

