/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.eip.support;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import javax.jbi.messaging.MessageExchange;
import org.apache.servicemix.eip.support.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;

public class SwitchPredicate
implements InitializingBean,
Predicate {
    private final Logger logger = LoggerFactory.getLogger(SwitchPredicate.class);
    private Resource propertyResource;
    private boolean fromExchange;
    private String propertyName = "on";
    private Boolean on = Boolean.FALSE;
    private File propertyFile;
    private boolean dirty;

    public void afterPropertiesSet() throws Exception {
        try {
            Properties props = null;
            if (this.propertyResource != null && this.propertyResource.exists()) {
                this.propertyFile = this.propertyResource.getFile();
                this.logger.debug("loading property file: {}", (Object)this.propertyFile.getAbsolutePath());
                props = new Properties();
                props.load(this.propertyResource.getInputStream());
            } else {
                props = System.getProperties();
            }
            String value = props.getProperty(this.propertyName);
            if (value != null) {
                this.on = Boolean.valueOf(value);
            }
        }
        catch (IOException e) {
            this.logger.error("could not load switch property file - filter is off", (Throwable)e);
            this.on = Boolean.FALSE;
        }
        this.dirty = false;
    }

    public boolean isOn() {
        return this.on;
    }

    public void setOn(boolean status) {
        this.on = status;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String newPropertyName) {
        this.propertyName = newPropertyName;
        this.dirty = true;
    }

    public Resource getPropertyResource() {
        return this.propertyResource;
    }

    public void setPropertyResource(Resource newPropertyResource) {
        this.propertyResource = newPropertyResource;
    }

    public boolean getFromExchange() {
        return this.fromExchange;
    }

    public void setFromExchange(boolean fromExchange) {
        this.fromExchange = fromExchange;
    }

    public void createResource(String resource) {
        DefaultResourceLoader resourceLoader;
        Resource tempPropertyResource;
        if (resource != null && (tempPropertyResource = (resourceLoader = new DefaultResourceLoader()).getResource(resource)) != null && tempPropertyResource.exists()) {
            this.propertyResource = tempPropertyResource;
            this.dirty = true;
        }
    }

    public String showResource() throws IOException {
        return this.propertyResource.getURL().toExternalForm();
    }

    public boolean matches(MessageExchange exchange) {
        if (this.dirty) {
            try {
                this.afterPropertiesSet();
            }
            catch (Exception e) {
                return false;
            }
        }
        Boolean match = Boolean.FALSE;
        if (this.fromExchange) {
            try {
                Object value = exchange.getProperty(this.propertyName);
                if (value != null) {
                    match = Boolean.valueOf(value.toString());
                }
            }
            catch (Exception e) {
                this.logger.warn("Could not evaluate xpath expression", (Throwable)e);
                match = Boolean.FALSE;
            }
        } else {
            match = this.on;
        }
        return match;
    }
}

