/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.eip.patterns;

import java.util.HashSet;
import javax.jbi.management.DeploymentException;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import org.apache.servicemix.eip.EIPEndpoint;
import org.apache.servicemix.eip.support.ExchangeTarget;
import org.apache.servicemix.jbi.util.MessageUtil;

public class StaticRoutingSlip
extends EIPEndpoint {
    private boolean transferingProperties = true;
    private ExchangeTarget[] targets;
    private String correlation;
    private String index;
    private String previous;

    public ExchangeTarget[] getTargets() {
        return this.targets;
    }

    public void setTargets(ExchangeTarget[] targets) {
        this.targets = targets;
    }

    public void validate() throws DeploymentException {
        super.validate();
        if (this.targets == null || this.targets.length == 0) {
            throw new IllegalArgumentException("targets should contain at least one ExchangeTarget");
        }
        this.correlation = "RoutingSlip.Correlation." + this.getService() + "." + this.getEndpoint();
        this.index = "RoutingSlip.Index." + this.getService() + "." + this.getEndpoint();
        this.previous = "RoutingSlip.Previous." + this.getService() + "." + this.getEndpoint();
    }

    protected void processSync(MessageExchange exchange) throws Exception {
        if (!(exchange instanceof InOut)) {
            throw new IllegalStateException("Use an InOut MEP");
        }
        MessageExchange current = exchange;
        for (int i = 0; i < this.targets.length; ++i) {
            InOut me = this.getExchangeFactory().createInOutExchange();
            this.targets[i].configureTarget((MessageExchange)me, this.getContext());
            if (i == 0) {
                MessageUtil.transferInToIn((MessageExchange)current, (MessageExchange)me);
            } else {
                MessageUtil.transferOutToIn((MessageExchange)current, (MessageExchange)me);
                this.transferPropertiesOfInMessage(current, (MessageExchange)me);
            }
            this.sendSync((MessageExchange)me);
            if (i != 0) {
                this.done(current);
            }
            if (me.getStatus() == ExchangeStatus.DONE) {
                throw new IllegalStateException("Exchange status is " + ExchangeStatus.DONE);
            }
            if (me.getStatus() == ExchangeStatus.ERROR) {
                this.fail(exchange, me.getError());
                return;
            }
            if (me.getFault() != null) {
                Fault fault = MessageUtil.copyFault((MessageExchange)me);
                MessageUtil.transferToFault((Fault)fault, (MessageExchange)exchange);
                this.done((MessageExchange)me);
                this.sendSync(exchange);
                return;
            }
            if (me.getOutMessage() == null) {
                throw new IllegalStateException("Exchange status is " + ExchangeStatus.ACTIVE + " but has no Out nor Fault message");
            }
            current = me;
        }
        MessageUtil.transferToOut((NormalizedMessage)MessageUtil.copyOut((MessageExchange)current), (MessageExchange)exchange);
        this.done(current);
        this.sendSync(exchange);
    }

    protected void processAsync(MessageExchange exchange) throws Exception {
        if (exchange.getRole() == MessageExchange.Role.PROVIDER) {
            this.processProviderAsync(exchange);
        } else {
            this.processConsumerAsync(exchange);
        }
    }

    protected void processProviderAsync(MessageExchange exchange) throws Exception {
        if (exchange.getStatus() == ExchangeStatus.DONE) {
            String correlationId = (String)exchange.getProperty(this.correlation);
            if (correlationId == null) {
                throw new IllegalStateException(this.correlation + " property not found");
            }
            MessageExchange me = (MessageExchange)this.store.load(correlationId);
            this.done(me);
        } else if (exchange.getStatus() == ExchangeStatus.ERROR) {
            String correlationId = (String)exchange.getProperty(this.correlation);
            if (correlationId == null) {
                throw new IllegalStateException(this.correlation + " property not found");
            }
            MessageExchange me = (MessageExchange)this.store.load(correlationId);
            this.done(me);
        } else {
            if (!(exchange instanceof InOut)) {
                throw new IllegalStateException("Use an InOut MEP");
            }
            InOut me = this.getExchangeFactory().createInOutExchange();
            me.setProperty(this.correlation, (Object)exchange.getExchangeId());
            me.setProperty(this.index, (Object)0);
            this.targets[0].configureTarget((MessageExchange)me, this.getContext());
            this.store.store(exchange.getExchangeId(), (Object)exchange);
            MessageUtil.transferInToIn((MessageExchange)exchange, (MessageExchange)me);
            this.send((MessageExchange)me);
        }
    }

    private void processConsumerAsync(MessageExchange exchange) throws Exception {
        String correlationId = (String)exchange.getProperty(this.correlation);
        String previousId = (String)exchange.getProperty(this.previous);
        Integer prevIndex = (Integer)exchange.getProperty(this.index);
        if (correlationId == null) {
            throw new IllegalStateException(this.correlation + " property not found");
        }
        if (prevIndex == null) {
            throw new IllegalStateException(this.previous + " property not found");
        }
        if (exchange.getStatus() == ExchangeStatus.DONE) {
            throw new IllegalStateException("Exchange status is " + ExchangeStatus.DONE);
        }
        if (exchange.getStatus() == ExchangeStatus.ERROR) {
            MessageExchange me = (MessageExchange)this.store.load(correlationId);
            this.fail(me, exchange.getError());
            if (previousId != null) {
                me = (MessageExchange)this.store.load(previousId);
                this.done(me);
            }
        } else if (exchange.getFault() != null) {
            MessageExchange me = (MessageExchange)this.store.load(correlationId);
            me.setProperty(this.correlation, (Object)exchange.getExchangeId());
            this.store.store(exchange.getExchangeId(), (Object)exchange);
            MessageUtil.transferFaultToFault((MessageExchange)exchange, (MessageExchange)me);
            this.send(me);
            if (previousId != null) {
                me = (MessageExchange)this.store.load(previousId);
                this.done(me);
            }
        } else if (exchange.getMessage("out") != null) {
            if (prevIndex == this.targets.length - 1) {
                MessageExchange me = (MessageExchange)this.store.load(correlationId);
                me.setProperty(this.correlation, (Object)exchange.getExchangeId());
                this.store.store(exchange.getExchangeId(), (Object)exchange);
                MessageUtil.transferOutToOut((MessageExchange)exchange, (MessageExchange)me);
                this.send(me);
                if (previousId != null) {
                    me = (MessageExchange)this.store.load(previousId);
                    this.done(me);
                }
            } else {
                InOut me = this.getExchangeFactory().createInOutExchange();
                Integer curIndex = prevIndex + 1;
                me.setProperty(this.correlation, (Object)correlationId);
                me.setProperty(this.index, (Object)curIndex);
                me.setProperty(this.previous, (Object)exchange.getExchangeId());
                this.targets[curIndex].configureTarget((MessageExchange)me, this.getContext());
                this.store.store(exchange.getExchangeId(), (Object)exchange);
                MessageUtil.transferOutToIn((MessageExchange)exchange, (MessageExchange)me);
                this.transferPropertiesOfInMessage(exchange, (MessageExchange)me);
                this.send((MessageExchange)me);
                if (previousId != null) {
                    me = (MessageExchange)this.store.load(previousId);
                    this.done((MessageExchange)me);
                }
            }
        } else {
            throw new IllegalStateException("Exchange status is " + ExchangeStatus.ACTIVE + " but has no Out nor Fault message");
        }
    }

    private void transferPropertiesOfInMessage(MessageExchange original, MessageExchange destination) {
        if (this.transferingProperties) {
            NormalizedMessage originalIn = original.getMessage("in");
            NormalizedMessage destinationIn = destination.getMessage("in");
            HashSet propertiesToTransfer = new HashSet(originalIn.getPropertyNames());
            propertiesToTransfer.removeAll(destinationIn.getPropertyNames());
            for (String propertyName : propertiesToTransfer) {
                if (this.isServiceMixProperty(propertyName)) continue;
                destinationIn.setProperty(propertyName, originalIn.getProperty(propertyName));
            }
        }
    }

    private boolean isServiceMixProperty(String propertyName) {
        String prefix = "org.apache.servicemix";
        return propertyName.startsWith(prefix);
    }

    public void setTransferingProperties(boolean transferingProperties) {
        this.transferingProperties = transferingProperties;
    }
}

