/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.eip.support;

import java.net.URI;
import java.util.Set;
import javax.jbi.management.DeploymentException;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.messaging.RobustInOnly;
import javax.xml.transform.Source;
import org.apache.servicemix.eip.EIPEndpoint;
import org.apache.servicemix.eip.support.ExchangeTarget;
import org.apache.servicemix.jbi.util.MessageUtil;

public abstract class AbstractSplitter
extends EIPEndpoint {
    public static final String SPLITTER_COUNT = "org.apache.servicemix.eip.splitter.count";
    public static final String SPLITTER_INDEX = "org.apache.servicemix.eip.splitter.index";
    public static final String SPLITTER_CORRID = "org.apache.servicemix.eip.splitter.corrid";
    private ExchangeTarget target;
    private boolean reportErrors;
    private boolean forwardAttachments;
    private boolean forwardProperties;
    private boolean synchronous;

    public boolean isSynchronous() {
        return this.synchronous;
    }

    public void setSynchronous(boolean synchronous) {
        this.synchronous = synchronous;
    }

    public boolean isReportErrors() {
        return this.reportErrors;
    }

    public void setReportErrors(boolean reportErrors) {
        this.reportErrors = reportErrors;
    }

    public ExchangeTarget getTarget() {
        return this.target;
    }

    public void setTarget(ExchangeTarget target) {
        this.target = target;
    }

    public boolean isForwardAttachments() {
        return this.forwardAttachments;
    }

    public void setForwardAttachments(boolean forwardAttachments) {
        this.forwardAttachments = forwardAttachments;
    }

    public boolean isForwardProperties() {
        return this.forwardProperties;
    }

    public void setForwardProperties(boolean forwardProperties) {
        this.forwardProperties = forwardProperties;
    }

    public void validate() throws DeploymentException {
        super.validate();
        if (this.target == null) {
            throw new IllegalArgumentException("target should be set to a valid ExchangeTarget");
        }
    }

    public void start() throws Exception {
        super.start();
    }

    protected void processSync(MessageExchange exchange) throws Exception {
        if (!(exchange instanceof InOnly) && !(exchange instanceof RobustInOnly)) {
            this.fail(exchange, new UnsupportedOperationException("Use an InOnly or RobustInOnly MEP"));
            return;
        }
        MessageExchange[] parts = this.createParts(exchange);
        for (int i = 0; i < parts.length; ++i) {
            this.target.configureTarget(parts[i], this.getContext());
            if (this.reportErrors || this.isSynchronous()) {
                this.sendSync(parts[i]);
                if (parts[i].getStatus() == ExchangeStatus.DONE) continue;
                if (parts[i].getStatus() == ExchangeStatus.ERROR) {
                    if (!this.reportErrors) continue;
                    this.fail(exchange, parts[i].getError());
                    return;
                }
                if (parts[i].getFault() != null) {
                    if (this.reportErrors) {
                        MessageUtil.transferToFault((Fault)MessageUtil.copyFault((MessageExchange)parts[i]), (MessageExchange)exchange);
                        this.done(parts[i]);
                        this.sendSync(exchange);
                        return;
                    }
                    this.done(parts[i]);
                    continue;
                }
                throw new IllegalStateException("Exchange status is " + ExchangeStatus.ACTIVE + " but has no Fault message");
            }
            this.send(parts[i]);
        }
        this.done(exchange);
    }

    protected void processAsync(MessageExchange exchange) throws Exception {
        if (this.reportErrors) {
            throw new UnsupportedOperationException("Not implemented");
        }
        if (exchange.getStatus() == ExchangeStatus.DONE) {
            return;
        }
        if (exchange.getStatus() == ExchangeStatus.ERROR) {
            return;
        }
        if (!(exchange instanceof InOnly) && !(exchange instanceof RobustInOnly)) {
            this.fail(exchange, new UnsupportedOperationException("Use an InOnly or RobustInOnly MEP"));
        } else if (exchange.getFault() != null) {
            this.done(exchange);
        } else {
            MessageExchange[] parts = this.createParts(exchange);
            for (int i = 0; i < parts.length; ++i) {
                this.target.configureTarget(parts[i], this.getContext());
                this.send(parts[i]);
            }
            this.done(exchange);
        }
    }

    protected MessageExchange[] createParts(MessageExchange exchange) throws Exception {
        NormalizedMessage in = MessageUtil.copyIn((MessageExchange)exchange);
        Source[] srcParts = this.split(in.getContent());
        MessageExchange[] parts = new MessageExchange[srcParts.length];
        for (int i = 0; i < srcParts.length; ++i) {
            parts[i] = this.createPart(exchange.getPattern(), in, srcParts[i]);
            NormalizedMessage msg = parts[i].getMessage("in");
            msg.setProperty(SPLITTER_COUNT, (Object)srcParts.length);
            msg.setProperty(SPLITTER_INDEX, (Object)i);
            msg.setProperty(SPLITTER_CORRID, (Object)exchange.getExchangeId());
        }
        return parts;
    }

    protected MessageExchange createPart(URI pattern, NormalizedMessage srcMessage, Source content) throws Exception {
        Set names;
        MessageExchange me = this.getExchangeFactory().createExchange(pattern);
        NormalizedMessage in = me.createMessage();
        in.setContent(content);
        me.setMessage(in, "in");
        if (this.forwardAttachments) {
            names = srcMessage.getAttachmentNames();
            for (String name : names) {
                in.addAttachment(name, srcMessage.getAttachment(name));
            }
        }
        if (this.forwardProperties) {
            names = srcMessage.getPropertyNames();
            for (String name : names) {
                in.setProperty(name, srcMessage.getProperty(name));
            }
        }
        return me;
    }

    protected abstract Source[] split(Source var1) throws Exception;
}

