/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.eip.patterns;

import java.util.Date;
import java.util.concurrent.TimeoutException;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.messaging.RobustInOnly;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.eip.EIPEndpoint;
import org.apache.servicemix.eip.support.ExchangeTarget;
import org.apache.servicemix.expression.Expression;
import org.apache.servicemix.expression.PropertyExpression;
import org.apache.servicemix.jbi.util.MessageUtil;
import org.apache.servicemix.timers.Timer;
import org.apache.servicemix.timers.TimerListener;

public class AsyncBridge
extends EIPEndpoint {
    public static final String CORRID = "org.apache.servicemix.eip.asyncbridge.corrid";
    private static final Log LOG = LogFactory.getLog(AsyncBridge.class);
    private Expression requestCorrId = new Expression(){

        public Object evaluate(MessageExchange exchange, NormalizedMessage message) throws MessagingException {
            return exchange.getExchangeId();
        }
    };
    private String responseCorrIdProperty = "org.apache.servicemix.eip.asyncbridge.corrid";
    private Expression responseCorrId;
    private long timeout;
    private ExchangeTarget target;
    private boolean useRobustInOnly;

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public ExchangeTarget getTarget() {
        return this.target;
    }

    public void setTarget(ExchangeTarget target) {
        this.target = target;
    }

    public Expression getRequestCorrId() {
        return this.requestCorrId;
    }

    public void setRequestCorrId(Expression requestCorrId) {
        this.requestCorrId = requestCorrId;
    }

    public String getResponseCorrIdProperty() {
        return this.responseCorrIdProperty;
    }

    public void setResponseCorrIdProperty(String responseCorrIdProperty) {
        this.responseCorrIdProperty = responseCorrIdProperty;
    }

    public Expression getResponseCorrId() {
        return this.responseCorrId;
    }

    public void setResponseCorrId(Expression responseCorrId) {
        this.responseCorrId = responseCorrId;
    }

    public boolean isUseRobustInOnly() {
        return this.useRobustInOnly;
    }

    public void setUseRobustInOnly(boolean useRobustInOnly) {
        this.useRobustInOnly = useRobustInOnly;
    }

    public void start() throws Exception {
        super.start();
        if (this.responseCorrId == null) {
            this.responseCorrId = new PropertyExpression(this.responseCorrIdProperty);
        }
    }

    protected void processSync(MessageExchange exchange) throws Exception {
        throw new IllegalStateException();
    }

    protected void processAsync(MessageExchange exchange) throws Exception {
        throw new IllegalStateException();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void process(MessageExchange exchange) throws Exception {
        if (exchange.getRole() != MessageExchange.Role.PROVIDER) throw new IllegalStateException();
        if (exchange instanceof InOut && exchange.getStatus() == ExchangeStatus.ACTIVE) {
            final String correlationId = (String)this.requestCorrId.evaluate(exchange, exchange.getMessage("in"));
            if (correlationId == null || correlationId.length() == 0) {
                throw new IllegalArgumentException("Could not retrieve correlation id for incoming exchange");
            }
            this.store.store(correlationId, (Object)exchange);
            RobustInOnly tme = this.useRobustInOnly ? this.getExchangeFactory().createRobustInOnlyExchange() : this.getExchangeFactory().createInOnlyExchange();
            this.target.configureTarget((MessageExchange)tme, this.getContext());
            MessageUtil.transferInToIn((MessageExchange)exchange, (MessageExchange)tme);
            tme.setProperty(this.responseCorrIdProperty, (Object)correlationId);
            tme.getMessage("in").setProperty(this.responseCorrIdProperty, (Object)correlationId);
            this.sendSync((MessageExchange)tme);
            if (tme.getStatus() == ExchangeStatus.ERROR) {
                this.store.load(correlationId);
                this.fail(exchange, tme.getError());
                return;
            }
            if (tme.getStatus() == ExchangeStatus.ACTIVE) {
                this.store.load(correlationId);
                MessageUtil.transferFaultToFault((MessageExchange)tme, (MessageExchange)exchange);
                this.send((MessageExchange)tme);
                this.done((MessageExchange)tme);
                return;
            }
            Date dt = this.getTimeout(exchange);
            if (dt == null) return;
            this.getTimerManager().schedule(new TimerListener(){

                public void timerExpired(Timer timer) {
                    AsyncBridge.this.onTimeout(correlationId);
                }
            }, dt);
            return;
        } else {
            if (exchange instanceof InOut && exchange.getStatus() != ExchangeStatus.ACTIVE) return;
            if (!(exchange instanceof InOnly) && !(exchange instanceof RobustInOnly)) throw new IllegalStateException();
            String correlationId = (String)this.responseCorrId.evaluate(exchange, exchange.getMessage("in"));
            if (correlationId == null || correlationId.length() == 0) {
                throw new IllegalArgumentException("Could not retrieve correlation id for incoming exchange");
            }
            MessageExchange request = (MessageExchange)this.store.load(correlationId);
            if (request != null) {
                MessageUtil.transferInToOut((MessageExchange)exchange, (MessageExchange)request);
                this.sendSync(request);
            }
            this.done(exchange);
        }
    }

    protected void onTimeout(String correlationId) {
        try {
            MessageExchange request = (MessageExchange)this.store.load(correlationId);
            if (request != null) {
                this.fail(request, new TimeoutException());
            }
        }
        catch (Exception e) {
            LOG.debug((Object)"Exception caught when handling timeout", (Throwable)e);
        }
    }

    protected Date getTimeout(MessageExchange exchange) {
        if (this.timeout > 0L) {
            return new Date(System.currentTimeMillis() + this.timeout);
        }
        return null;
    }
}

