/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.eip.patterns;

import javax.jbi.management.DeploymentException;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import org.apache.servicemix.eip.EIPEndpoint;
import org.apache.servicemix.eip.support.ExchangeTarget;
import org.apache.servicemix.jbi.util.MessageUtil;

public class WireTap
extends EIPEndpoint {
    private ExchangeTarget target;
    private ExchangeTarget inListener;
    private ExchangeTarget outListener;
    private ExchangeTarget faultListener;
    private String correlation;
    private boolean copyProperties;

    public ExchangeTarget getTarget() {
        return this.target;
    }

    public void setTarget(ExchangeTarget target) {
        this.target = target;
        this.wsdlExchangeTarget = target;
    }

    public ExchangeTarget getFaultListener() {
        return this.faultListener;
    }

    public void setFaultListener(ExchangeTarget faultListener) {
        this.faultListener = faultListener;
    }

    public ExchangeTarget getInListener() {
        return this.inListener;
    }

    public void setInListener(ExchangeTarget inListener) {
        this.inListener = inListener;
    }

    public ExchangeTarget getOutListener() {
        return this.outListener;
    }

    public void setOutListener(ExchangeTarget outListener) {
        this.outListener = outListener;
    }

    public boolean isCopyProperties() {
        return this.copyProperties;
    }

    public void setCopyProperties(boolean copyProperties) {
        this.copyProperties = copyProperties;
    }

    public void validate() throws DeploymentException {
        super.validate();
        if (this.target == null) {
            throw new IllegalArgumentException("target should be set to a valid ExchangeTarget");
        }
        this.correlation = "WireTap.Correlation." + this.getService() + "." + this.getEndpoint();
    }

    protected void processSync(MessageExchange exchange) throws Exception {
        MessageExchange tme = this.getExchangeFactory().createExchange(exchange.getPattern());
        this.target.configureTarget(tme, this.getContext());
        this.sendSyncToListenerAndTarget(exchange, tme, this.inListener, "in", false);
        if (tme.getStatus() == ExchangeStatus.DONE) {
            this.done(exchange);
        } else if (tme.getStatus() == ExchangeStatus.ERROR) {
            this.fail(exchange, tme.getError());
        } else if (tme.getFault() != null) {
            this.sendSyncToListenerAndTarget(tme, exchange, this.faultListener, "fault", this.isCopyProperties());
            this.done(tme);
        } else if (tme.getMessage("out") != null) {
            this.sendSyncToListenerAndTarget(tme, exchange, this.outListener, "out", this.isCopyProperties());
            this.done(tme);
        } else {
            this.done(tme);
            throw new IllegalStateException("Exchange status is " + ExchangeStatus.ACTIVE + " but has no Out nor Fault message");
        }
    }

    protected void processAsync(MessageExchange exchange) throws Exception {
        if (exchange.getRole() == MessageExchange.Role.PROVIDER && exchange.getProperty(this.correlation) == null) {
            MessageExchange tme = this.getExchangeFactory().createExchange(exchange.getPattern());
            if (this.store.hasFeature("Clustered")) {
                exchange.setProperty("org.apache.servicemix.provider.stateless", (Object)Boolean.TRUE);
                tme.setProperty("org.apache.servicemix.consumer.stateless", (Object)Boolean.TRUE);
            }
            this.target.configureTarget(tme, this.getContext());
            exchange.setProperty(this.correlation, (Object)tme.getExchangeId());
            tme.setProperty(this.correlation, (Object)exchange.getExchangeId());
            this.store.store(exchange.getExchangeId(), (Object)exchange);
            this.sendToListenerAndTarget(exchange, tme, this.inListener, "in", false);
        } else {
            String id = (String)exchange.getProperty(this.correlation);
            if (id == null) {
                if (exchange.getRole() == MessageExchange.Role.CONSUMER && exchange.getStatus() != ExchangeStatus.ACTIVE) {
                    return;
                }
                throw new IllegalStateException(this.correlation + " property not found");
            }
            MessageExchange org = (MessageExchange)this.store.load(id);
            if (org == null) {
                throw new IllegalStateException("Could not load original exchange with id " + id);
            }
            if (exchange.getStatus() == ExchangeStatus.DONE) {
                this.done(org);
            } else if (exchange.getStatus() == ExchangeStatus.ERROR) {
                this.fail(org, exchange.getError());
            } else if (exchange.getFault() != null) {
                this.store.store(exchange.getExchangeId(), (Object)exchange);
                this.sendToListenerAndTarget(exchange, org, this.faultListener, "fault", this.isCopyProperties());
            } else if (exchange.getMessage("out") != null) {
                this.store.store(exchange.getExchangeId(), (Object)exchange);
                this.sendToListenerAndTarget(exchange, org, this.outListener, "out", this.isCopyProperties());
            } else {
                throw new IllegalStateException("Exchange status is " + ExchangeStatus.ACTIVE + " but has no Out nor Fault message");
            }
        }
    }

    private void sendToListenerAndTarget(MessageExchange source, MessageExchange dest, ExchangeTarget listener, String message, boolean copy) throws Exception {
        if (listener != null) {
            NormalizedMessage msg = MessageUtil.copy((NormalizedMessage)source.getMessage(message));
            InOnly lme = this.getExchangeFactory().createInOnlyExchange();
            if (this.store.hasFeature("Clustered")) {
                lme.setProperty("org.apache.servicemix.consumer.stateless", (Object)Boolean.TRUE);
            }
            listener.configureTarget((MessageExchange)lme, this.getContext());
            MessageUtil.transferToIn((NormalizedMessage)msg, (MessageExchange)lme);
            this.send((MessageExchange)lme);
            MessageUtil.transferTo((NormalizedMessage)msg, (MessageExchange)dest, (String)message);
            if (copy) {
                this.copyExchangeProperties(dest, "in", message);
            }
            this.send(dest);
        } else {
            MessageUtil.transferTo((MessageExchange)source, (MessageExchange)dest, (String)message);
            if (copy) {
                this.copyExchangeProperties(dest, "in", message);
            }
            this.send(dest);
        }
    }

    private void sendSyncToListenerAndTarget(MessageExchange source, MessageExchange dest, ExchangeTarget listener, String message, boolean copy) throws Exception {
        if (listener != null) {
            NormalizedMessage msg = MessageUtil.copy((NormalizedMessage)source.getMessage(message));
            InOnly lme = this.getExchangeFactory().createInOnlyExchange();
            if (this.store.hasFeature("Clustered")) {
                lme.setProperty("org.apache.servicemix.consumer.stateless", (Object)Boolean.TRUE);
            }
            listener.configureTarget((MessageExchange)lme, this.getContext());
            MessageUtil.transferToIn((NormalizedMessage)msg, (MessageExchange)lme);
            this.sendSync((MessageExchange)lme);
            MessageUtil.transferTo((NormalizedMessage)msg, (MessageExchange)dest, (String)message);
            if (copy) {
                this.copyExchangeProperties(dest, "in", message);
            }
            this.sendSync(dest);
        } else {
            MessageUtil.transferTo((MessageExchange)source, (MessageExchange)dest, (String)message);
            if (copy) {
                this.copyExchangeProperties(dest, "in", message);
            }
            this.sendSync(dest);
        }
    }

    private void copyExchangeProperties(MessageExchange exchange, String srcMessage, String dstMessage) {
        NormalizedMessage src = exchange.getMessage(srcMessage);
        NormalizedMessage dst = exchange.getMessage(dstMessage);
        for (String name : src.getPropertyNames()) {
            if (dst.getProperty(name) != null) continue;
            Object prop = src.getProperty(name);
            dst.setProperty(name, prop);
        }
    }
}

