/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.eip.patterns;

import java.util.concurrent.locks.Lock;
import javax.jbi.management.DeploymentException;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.messaging.RobustInOnly;
import org.apache.servicemix.eip.EIPEndpoint;
import org.apache.servicemix.eip.support.ExchangeTarget;
import org.apache.servicemix.jbi.util.MessageUtil;

public class StaticRecipientList
extends EIPEndpoint {
    public static final String RECIPIENT_LIST_COUNT = "org.apache.servicemix.eip.recipientList.count";
    public static final String RECIPIENT_LIST_INDEX = "org.apache.servicemix.eip.recipientList.index";
    public static final String RECIPIENT_LIST_CORRID = "org.apache.servicemix.eip.recipientList.corrid";
    private ExchangeTarget[] recipients;
    private boolean reportErrors;

    public ExchangeTarget[] getRecipients() {
        return this.recipients;
    }

    public void setRecipients(ExchangeTarget[] recipients) {
        this.recipients = recipients;
    }

    public boolean isReportErrors() {
        return this.reportErrors;
    }

    public void setReportErrors(boolean reportErrors) {
        this.reportErrors = reportErrors;
    }

    public void validate() throws DeploymentException {
        super.validate();
        if (this.recipients == null || this.recipients.length == 0) {
            throw new IllegalArgumentException("recipients should contain at least one ExchangeTarget");
        }
    }

    protected void processSync(MessageExchange exchange) throws Exception {
        if (!(exchange instanceof InOnly) && !(exchange instanceof RobustInOnly)) {
            this.fail(exchange, new UnsupportedOperationException("Use an InOnly or RobustInOnly MEP"));
            return;
        }
        NormalizedMessage in = MessageUtil.copyIn((MessageExchange)exchange);
        for (int i = 0; i < this.recipients.length; ++i) {
            MessageExchange me = this.getExchangeFactory().createExchange(exchange.getPattern());
            this.recipients[i].configureTarget(me, this.getContext());
            in.setProperty(RECIPIENT_LIST_COUNT, (Object)new Integer(this.recipients.length));
            in.setProperty(RECIPIENT_LIST_INDEX, (Object)new Integer(i));
            in.setProperty(RECIPIENT_LIST_CORRID, (Object)exchange.getExchangeId());
            MessageUtil.transferToIn((NormalizedMessage)in, (MessageExchange)me);
            this.sendSync(me);
            if (me.getStatus() == ExchangeStatus.ERROR && this.reportErrors) {
                this.fail(exchange, me.getError());
                return;
            }
            if (me.getFault() == null || !this.reportErrors) continue;
            MessageUtil.transferFaultToFault((MessageExchange)me, (MessageExchange)exchange);
            this.sendSync(exchange);
            this.done(me);
            return;
        }
        this.done(exchange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void processAsync(MessageExchange exchange) throws Exception {
        if (exchange.getRole() == MessageExchange.Role.CONSUMER) {
            String corrId = (String)exchange.getMessage("in").getProperty(RECIPIENT_LIST_CORRID);
            int count = (Integer)exchange.getMessage("in").getProperty(RECIPIENT_LIST_COUNT);
            Lock lock = this.lockManager.getLock(corrId);
            lock.lock();
            try {
                Integer acks = (Integer)this.store.load(corrId + ".acks");
                if (exchange.getStatus() == ExchangeStatus.DONE) {
                    if (acks == null) return;
                    if (acks + 1 >= count) {
                        MessageExchange me = (MessageExchange)this.store.load(corrId);
                        this.done(me);
                        return;
                    }
                    this.store.store(corrId + ".acks", (Object)(acks + 1));
                    return;
                }
                if (exchange.getStatus() == ExchangeStatus.ERROR) {
                    if (acks == null) return;
                    if (this.reportErrors) {
                        MessageExchange me = (MessageExchange)this.store.load(corrId);
                        this.fail(me, exchange.getError());
                        return;
                    }
                    if (acks + 1 >= count) {
                        MessageExchange me = (MessageExchange)this.store.load(corrId);
                        this.done(me);
                        return;
                    }
                    this.store.store(corrId + ".acks", (Object)(acks + 1));
                    return;
                }
                if (exchange.getFault() == null) return;
                if (acks != null) {
                    if (this.reportErrors) {
                        MessageExchange me = (MessageExchange)this.store.load(corrId);
                        MessageUtil.transferToFault((Fault)MessageUtil.copyFault((MessageExchange)exchange), (MessageExchange)me);
                        this.send(me);
                        this.done(exchange);
                        return;
                    }
                    if (acks + 1 >= count) {
                        MessageExchange me = (MessageExchange)this.store.load(corrId);
                        this.done(me);
                        return;
                    }
                    this.store.store(corrId + ".acks", (Object)(acks + 1));
                    return;
                }
                this.done(exchange);
                return;
            }
            finally {
                lock.unlock();
            }
        } else if (!(exchange instanceof InOnly) && !(exchange instanceof RobustInOnly)) {
            this.fail(exchange, new UnsupportedOperationException("Use an InOnly or RobustInOnly MEP"));
            return;
        } else {
            if (exchange.getStatus() != ExchangeStatus.ACTIVE) return;
            this.store.store(exchange.getExchangeId(), (Object)exchange);
            this.store.store(exchange.getExchangeId() + ".acks", (Object)0);
            NormalizedMessage in = MessageUtil.copyIn((MessageExchange)exchange);
            for (int i = 0; i < this.recipients.length; ++i) {
                MessageExchange me = this.getExchangeFactory().createExchange(exchange.getPattern());
                this.recipients[i].configureTarget(me, this.getContext());
                in.setProperty(RECIPIENT_LIST_COUNT, (Object)new Integer(this.recipients.length));
                in.setProperty(RECIPIENT_LIST_INDEX, (Object)new Integer(i));
                in.setProperty(RECIPIENT_LIST_CORRID, (Object)exchange.getExchangeId());
                MessageUtil.transferToIn((NormalizedMessage)in, (MessageExchange)me);
                this.send(me);
            }
        }
    }
}

