/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.eip.support;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.messaging.RobustInOnly;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.eip.EIPEndpoint;
import org.apache.servicemix.eip.support.ExchangeTarget;
import org.apache.servicemix.jbi.util.MessageUtil;
import org.apache.servicemix.store.Store;
import org.apache.servicemix.store.StoreFactory;
import org.apache.servicemix.store.memory.MemoryStoreFactory;
import org.apache.servicemix.timers.Timer;
import org.apache.servicemix.timers.TimerListener;

public abstract class AbstractAggregator
extends EIPEndpoint {
    private static final Log LOG = LogFactory.getLog(AbstractAggregator.class);
    private ExchangeTarget target;
    private boolean rescheduleTimeouts;
    private boolean synchronous;
    private Store closedAggregates;
    private StoreFactory closedAggregatesStoreFactory;
    private boolean copyProperties = true;
    private boolean copyAttachments = true;
    private boolean reportErrors;
    private boolean reportClosedAggregatesAsErrors;
    private boolean reportTimeoutAsErrors;
    private ConcurrentMap<String, Timer> timers = new ConcurrentHashMap<String, Timer>();

    public boolean isSynchronous() {
        return this.synchronous;
    }

    public void setSynchronous(boolean synchronous) {
        this.synchronous = synchronous;
    }

    public boolean isRescheduleTimeouts() {
        return this.rescheduleTimeouts;
    }

    public void setRescheduleTimeouts(boolean rescheduleTimeouts) {
        this.rescheduleTimeouts = rescheduleTimeouts;
    }

    public ExchangeTarget getTarget() {
        return this.target;
    }

    public void setTarget(ExchangeTarget target) {
        this.target = target;
    }

    public boolean isCopyProperties() {
        return this.copyProperties;
    }

    public void setCopyProperties(boolean copyProperties) {
        this.copyProperties = copyProperties;
    }

    public boolean isCopyAttachments() {
        return this.copyAttachments;
    }

    public void setCopyAttachments(boolean copyAttachments) {
        this.copyAttachments = copyAttachments;
    }

    public boolean isReportErrors() {
        return this.reportErrors;
    }

    public void setReportErrors(boolean reportErrors) {
        this.reportErrors = reportErrors;
    }

    public boolean isReportClosedAggregatesAsErrors() {
        return this.reportClosedAggregatesAsErrors;
    }

    public void setReportClosedAggregatesAsErrors(boolean reportClosedAggregatesAsErrors) {
        this.reportClosedAggregatesAsErrors = reportClosedAggregatesAsErrors;
    }

    public void setReportTimeoutAsErrors(boolean reportTimeoutAsErrors) {
        this.reportTimeoutAsErrors = reportTimeoutAsErrors;
    }

    public boolean isReportTimeoutAsErrors() {
        return this.reportTimeoutAsErrors;
    }

    protected void processSync(MessageExchange exchange) throws Exception {
        throw new IllegalStateException();
    }

    public StoreFactory getClosedAggregatesStoreFactory() {
        return this.closedAggregatesStoreFactory;
    }

    public void setClosedAggregatesStoreFactory(StoreFactory closedAggregatesStoreFactory) {
        this.closedAggregatesStoreFactory = closedAggregatesStoreFactory;
    }

    protected void processAsync(MessageExchange exchange) throws Exception {
        throw new IllegalStateException();
    }

    public void start() throws Exception {
        super.start();
        if (this.closedAggregatesStoreFactory == null) {
            this.closedAggregatesStoreFactory = new MemoryStoreFactory();
        }
        this.closedAggregates = this.closedAggregatesStoreFactory.open(this.getService().toString() + this.getEndpoint() + "-closed-aggregates");
        if (this.reportTimeoutAsErrors && !this.reportErrors) {
            throw new IllegalArgumentException("ReportTimeoutAsErrors property may only be set if ReportTimeout property is also set!");
        }
    }

    public void process(MessageExchange exchange) throws Exception {
        if (exchange.getRole() == MessageExchange.Role.PROVIDER) {
            if (exchange.getStatus() != ExchangeStatus.ACTIVE) {
                return;
            }
            if (!(exchange instanceof InOnly) && !(exchange instanceof RobustInOnly)) {
                this.fail(exchange, new UnsupportedOperationException("Use an InOnly or RobustInOnly MEP"));
            } else {
                this.processProvider(exchange);
            }
        } else {
            String corrId;
            List exchanges;
            if (exchange.getStatus() == ExchangeStatus.ACTIVE) {
                throw new IllegalStateException("Unexpected active consumer exchange received");
            }
            if (this.reportErrors && (exchanges = (List)this.store.load((corrId = (String)exchange.getProperty(this.getService().toString() + ":" + this.getEndpoint() + ":correlation")) + "-exchanges")) != null) {
                for (MessageExchange me : exchanges) {
                    if (exchange.getStatus() == ExchangeStatus.ERROR) {
                        me.setError(exchange.getError());
                    }
                    me.setStatus(exchange.getStatus());
                    this.send(me);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processProvider(MessageExchange exchange) throws Exception {
        final String processCorrelationId = (String)exchange.getProperty("org.apache.servicemix.correlationId");
        NormalizedMessage in = MessageUtil.copyIn((MessageExchange)exchange);
        final String correlationId = this.getCorrelationID(exchange, in);
        if (correlationId == null || correlationId.length() == 0) {
            throw new IllegalArgumentException("Could not retrieve correlation id for incoming exchange");
        }
        Lock lock = this.getLockManager().getLock(correlationId);
        lock.lock();
        try {
            Object aggregation = this.store.load(correlationId);
            Date timeout = null;
            if (aggregation == null) {
                if (!this.isAggregationClosed(correlationId)) {
                    aggregation = this.createAggregation(correlationId);
                    timeout = this.getTimeout(aggregation);
                }
            } else if (this.isRescheduleTimeouts()) {
                timeout = this.getTimeout(aggregation);
            }
            if (aggregation != null) {
                if (this.reportErrors) {
                    ArrayList<MessageExchange> exchanges = (ArrayList<MessageExchange>)this.store.load(correlationId + "-exchanges");
                    if (exchanges == null) {
                        exchanges = new ArrayList<MessageExchange>();
                    }
                    exchanges.add(exchange);
                    this.store.store(correlationId + "-exchanges", exchanges);
                }
                if (this.addMessage(aggregation, in, exchange)) {
                    this.sendAggregate(processCorrelationId, correlationId, aggregation, false, this.isSynchronous(exchange));
                } else {
                    this.store.store(correlationId, aggregation);
                    if (timeout != null) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Scheduling timeout at " + timeout + " for aggregate " + correlationId));
                        }
                        Timer t = this.getTimerManager().schedule(new TimerListener(){

                            public void timerExpired(Timer timer) {
                                AbstractAggregator.this.onTimeout(processCorrelationId, correlationId, timer);
                            }
                        }, timeout);
                        this.timers.put(correlationId, t);
                    }
                }
                if (!this.reportErrors) {
                    this.done(exchange);
                }
            } else if (this.reportClosedAggregatesAsErrors) {
                this.fail(exchange, new ClosedAggregateException());
            } else {
                this.done(exchange);
            }
        }
        finally {
            lock.unlock();
        }
    }

    protected void sendAggregate(String processCorrelationId, String correlationId, Object aggregation, boolean timeout, boolean sync) throws Exception {
        InOnly me = this.getExchangeFactory().createInOnlyExchange();
        if (processCorrelationId != null) {
            me.setProperty("org.apache.servicemix.correlationId", (Object)processCorrelationId);
        }
        me.setProperty(this.getService().toString() + ":" + this.getEndpoint() + ":correlation", (Object)correlationId);
        this.target.configureTarget((MessageExchange)me, this.getContext());
        NormalizedMessage nm = me.createMessage();
        me.setInMessage(nm);
        this.buildAggregate(aggregation, nm, (MessageExchange)me, timeout);
        this.closeAggregation(correlationId);
        if (sync) {
            this.sendSync((MessageExchange)me);
        } else {
            this.send((MessageExchange)me);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onTimeout(String processCorrelationId, String correlationId, Timer timer) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Timeout expired for aggregate " + correlationId));
        }
        Lock lock = this.getLockManager().getLock(correlationId);
        lock.lock();
        try {
            Timer t = (Timer)this.timers.get(correlationId);
            if (t == null || !t.equals(timer)) {
                return;
            }
            this.timers.remove(correlationId);
            Object aggregation = this.store.load(correlationId);
            if (aggregation != null) {
                if (this.reportTimeoutAsErrors) {
                    List exchanges = (List)this.store.load(correlationId + "-exchanges");
                    if (exchanges != null) {
                        TimeoutException timeoutException = new TimeoutException();
                        for (MessageExchange me : exchanges) {
                            me.setError((Exception)timeoutException);
                            me.setStatus(ExchangeStatus.ERROR);
                            this.send(me);
                        }
                    }
                    this.closeAggregation(correlationId);
                } else {
                    this.sendAggregate(processCorrelationId, correlationId, aggregation, true, this.isSynchronous());
                }
            } else {
                if (!this.isAggregationClosed(correlationId)) {
                    throw new IllegalStateException("Aggregation is not closed, but can not be retrieved from the store");
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Aggregate " + correlationId + " is closed"));
                }
            }
        }
        catch (Exception e) {
            LOG.info((Object)"Caught exception while processing timeout aggregation", (Throwable)e);
        }
        finally {
            lock.unlock();
        }
    }

    protected boolean isAggregationClosed(String correlationId) throws Exception {
        Object data = this.closedAggregates.load(correlationId);
        if (data != null) {
            this.closedAggregates.store(correlationId, data);
        }
        return data != null;
    }

    protected void closeAggregation(String correlationId) throws Exception {
        this.closedAggregates.store(correlationId, (Object)Boolean.TRUE);
    }

    private boolean isSynchronous(MessageExchange exchange) {
        return this.isSynchronous() || exchange.isTransacted() && Boolean.TRUE.equals(exchange.getProperty("javax.jbi.messaging.sendSync"));
    }

    protected abstract String getCorrelationID(MessageExchange var1, NormalizedMessage var2) throws Exception;

    protected abstract Object createAggregation(String var1) throws Exception;

    protected abstract Date getTimeout(Object var1);

    protected abstract boolean addMessage(Object var1, NormalizedMessage var2, MessageExchange var3) throws Exception;

    protected abstract void buildAggregate(Object var1, NormalizedMessage var2, MessageExchange var3, boolean var4) throws Exception;

    public static class ClosedAggregateException
    extends Exception {
    }
}

