/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.eip.support.resequence;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.BlockingQueue;
import javax.jbi.messaging.MessageExchange;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.eip.support.resequence.SequenceSender;
import org.apache.servicemix.executors.Executor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceReader
implements Runnable {
    private static final Log LOG = LogFactory.getLog(SequenceReader.class);
    private static final MessageExchange STOP = SequenceReader.createStopSignal();
    private BlockingQueue<MessageExchange> queue;
    private SequenceSender sender;

    public SequenceReader(SequenceSender sender) {
        this.sender = sender;
    }

    public void setQueue(BlockingQueue<MessageExchange> queue) {
        this.queue = queue;
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    MessageExchange me;
                    if ((me = this.queue.take()) == STOP) {
                        LOG.info((Object)"exit processing loop after cancellation");
                        return;
                    }
                    this.sender.sendSync(me);
                }
            }
            catch (InterruptedException e) {
                LOG.info((Object)"exit processing loop after interrupt");
                return;
            }
            catch (Exception e) {
                LOG.error((Object)"caught and ignored exception", (Throwable)e);
                continue;
            }
            break;
        }
    }

    public void start(Executor executor) {
        executor.execute((Runnable)this);
    }

    public void stop() throws InterruptedException {
        this.queue.put(STOP);
    }

    private static MessageExchange createStopSignal() {
        return (MessageExchange)Proxy.newProxyInstance(SequenceReader.class.getClassLoader(), new Class[]{MessageExchange.class}, SequenceReader.createStopHandler());
    }

    private static InvocationHandler createStopHandler() {
        return new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                throw new IllegalStateException("illegal method invocation on stop signal");
            }
        };
    }
}

