/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.exec.marshaler;

import javax.jbi.messaging.NormalizedMessage;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.apache.servicemix.exec.marshaler.ExecMarshalerSupport;
import org.apache.servicemix.exec.marshaler.ExecRequest;
import org.apache.servicemix.exec.marshaler.ExecResponse;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DefaultExecMarshaler
implements ExecMarshalerSupport {
    private final Logger logger = LoggerFactory.getLogger(DefaultExecMarshaler.class);

    public ExecRequest unmarshal(NormalizedMessage in) throws Exception {
        this.logger.debug("Create a JAXB context with ExecRequest class.");
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ExecRequest.class});
        this.logger.debug("Create the JAXB unmarshaller.");
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        this.logger.debug("Unmarshal the in message context.");
        return (ExecRequest)unmarshaller.unmarshal(in.getContent());
    }

    public void marshal(ExecResponse execResponse, NormalizedMessage out) throws Exception {
        this.logger.debug("Create a JAXB context with ExecResponse class.");
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ExecResponse.class});
        this.logger.debug("Create the JAXB marshaller.");
        Marshaller marshaller = jaxbContext.createMarshaller();
        this.logger.debug("Marshal the ExecResponse into a DOM node.");
        SourceTransformer transformer = new SourceTransformer();
        Document document = transformer.createDocument();
        marshaller.marshal((Object)execResponse, (Node)document);
        this.logger.debug("Populate the out message content using the DOM node.");
        out.setContent((Source)new DOMSource(document));
    }
}

