/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.ftp;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import javax.jbi.JBIException;
import javax.jbi.management.DeploymentException;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.apache.commons.net.SocketClient;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.servicemix.common.DefaultComponent;
import org.apache.servicemix.common.ServiceUnit;
import org.apache.servicemix.common.endpoints.PollingEndpoint;
import org.apache.servicemix.common.locks.LockManager;
import org.apache.servicemix.common.locks.impl.SimpleLockManager;
import org.apache.servicemix.components.util.DefaultFileMarshaler;
import org.apache.servicemix.components.util.FileMarshaler;
import org.apache.servicemix.ftp.FTPClientPool;
import org.apache.servicemix.ftp.FtpEndpointType;

public class FtpPollerEndpoint
extends PollingEndpoint
implements FtpEndpointType {
    private FTPClientPool clientPool;
    private FileFilter filter;
    private boolean deleteFile = true;
    private boolean recursive = true;
    private boolean changeWorkingDirectory;
    private FileMarshaler marshaler = new DefaultFileMarshaler();
    private LockManager lockManager;
    private ConcurrentMap<String, FtpData> openExchanges = new ConcurrentHashMap<String, FtpData>();
    private QName targetOperation;
    private URI uri;
    private boolean stateless = true;
    private URI archive;
    private boolean autoCreateDirectory = true;

    public FtpPollerEndpoint() {
    }

    public FtpPollerEndpoint(ServiceUnit serviceUnit, QName service, String endpoint) {
        super(serviceUnit, service, endpoint);
    }

    public FtpPollerEndpoint(DefaultComponent component, ServiceEndpoint endpoint) {
        super(component, endpoint);
    }

    public void poll() throws Exception {
        this.pollFileOrDirectory(this.getWorkingPath());
    }

    public void validate() throws DeploymentException {
        super.validate();
        if (this.uri == null && (this.getClientPool() == null || this.getClientPool().getHost() == null)) {
            throw new DeploymentException("Property uri or clientPool.host must be configured");
        }
        if (this.uri != null && this.getClientPool() != null && this.getClientPool().getHost() != null) {
            throw new DeploymentException("Properties uri and clientPool.host can not be configured at the same time");
        }
        if (this.changeWorkingDirectory && this.recursive) {
            throw new DeploymentException("changeWorkingDirectory='true' can not be set when recursive='true'");
        }
        if (this.archive != null && this.archive.getPath() == null) {
            throw new DeploymentException("Archive specified without path information.");
        }
        if (this.archive != null && !this.deleteFile) {
            throw new DeploymentException("Archive shouldn't be specified unless deleteFile='true'");
        }
    }

    public synchronized void activate() throws Exception {
        if (this.uri == null && this.clientPool != null) {
            String str = "ftp://" + this.clientPool.getHost();
            if (this.clientPool.getPort() >= 0) {
                str = str + ":" + this.clientPool.getPort();
            }
            str = str + "/";
            this.uri = new URI(str);
        }
        super.activate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        if (this.lockManager == null) {
            this.lockManager = this.createLockManager();
        }
        if (this.clientPool == null) {
            this.clientPool = this.createClientPool();
        }
        if (this.uri != null) {
            this.clientPool.setHost(this.uri.getHost());
            this.clientPool.setPort(this.uri.getPort());
            if (this.uri.getUserInfo() != null) {
                String[] infos = this.uri.getUserInfo().split(":");
                this.clientPool.setUsername(infos[0]);
                if (infos.length > 1) {
                    this.clientPool.setPassword(infos[1]);
                }
            }
        }
        FTPClient ftp = this.borrowClient();
        String folderName = "";
        try {
            StringTokenizer strTok = null;
            if (this.isAutoCreateDirectory() && !ftp.changeWorkingDirectory(this.getWorkingPath())) {
                strTok = new StringTokenizer(this.getWorkingPath(), "/");
                while (strTok.hasMoreTokens()) {
                    folderName = folderName + '/';
                    if (ftp.changeWorkingDirectory(folderName = folderName + strTok.nextToken()) || ftp.makeDirectory(folderName)) continue;
                    throw new IOException("The defined folder " + this.getWorkingPath() + " doesn't exist on the server and it can't be created automatically.");
                }
            }
            folderName = "";
            if (this.getArchivePath() != null && this.isAutoCreateDirectory() && !ftp.changeWorkingDirectory(this.getArchivePath())) {
                strTok = new StringTokenizer(this.getArchivePath(), "/");
                while (strTok.hasMoreTokens()) {
                    folderName = folderName + '/';
                    if (ftp.changeWorkingDirectory(folderName = folderName + strTok.nextToken()) || ftp.makeDirectory(folderName)) continue;
                    throw new IOException("The defined archive folder " + this.getArchivePath() + " doesn't exist on the server and it can't be created automatically.");
                }
            }
            Object var5_4 = null;
            this.returnClient(ftp);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.returnClient(ftp);
            throw throwable;
        }
        super.start();
    }

    protected LockManager createLockManager() {
        return new SimpleLockManager();
    }

    private String getArchivePath() {
        return this.archive != null && this.archive.getPath() != null ? this.archive.getPath() : null;
    }

    private String getWorkingPath() {
        return this.uri != null && this.uri.getPath() != null ? this.uri.getPath() : ".";
    }

    public FTPClientPool getClientPool() {
        return this.clientPool;
    }

    public void setClientPool(FTPClientPool clientPool) {
        this.clientPool = clientPool;
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public FileFilter getFilter() {
        return this.filter;
    }

    public void setFilter(FileFilter filter) {
        this.filter = filter;
    }

    public boolean isDeleteFile() {
        return this.deleteFile;
    }

    public void setDeleteFile(boolean deleteFile) {
        this.deleteFile = deleteFile;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public FileMarshaler getMarshaler() {
        return this.marshaler;
    }

    public void setMarshaler(FileMarshaler marshaler) {
        this.marshaler = marshaler;
    }

    public QName getTargetOperation() {
        return this.targetOperation;
    }

    public void setTargetOperation(QName targetOperation) {
        this.targetOperation = targetOperation;
    }

    public void setChangeWorkingDirectory(boolean changeWorkingDirectory) {
        this.changeWorkingDirectory = changeWorkingDirectory;
    }

    public boolean isStateless() {
        return this.stateless;
    }

    public void setStateless(boolean stateless) {
        this.stateless = stateless;
    }

    public void setAutoCreateDirectory(boolean autoCreateDirectory) {
        this.autoCreateDirectory = autoCreateDirectory;
    }

    public boolean isAutoCreateDirectory() {
        return this.autoCreateDirectory;
    }

    public void setArchive(URI archive) {
        this.archive = archive;
    }

    public URI getArchive() {
        return this.archive;
    }

    public void setLockManager(LockManager lockManager) {
        this.lockManager = lockManager;
    }

    public LockManager getLockManager() {
        return this.lockManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pollFileOrDirectory(String fileOrDirectory) throws Exception {
        FTPClient ftp = this.borrowClient();
        try {
            logger.debug("Polling directory {}", (Object)fileOrDirectory);
            this.pollFileOrDirectory(ftp, fileOrDirectory, this.isRecursive());
            Object var4_3 = null;
            this.returnClient(ftp);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.returnClient(ftp);
            throw throwable;
        }
    }

    protected void pollFileOrDirectory(FTPClient ftp, String fileOrDirectory, boolean processDir) throws Exception {
        FTPFile[] files = this.listFiles(ftp, fileOrDirectory);
        for (int i = 0; i < files.length; ++i) {
            String name = files[i].getName();
            if (".".equals(name) || "..".equals(name)) continue;
            String file = fileOrDirectory + "/" + name;
            if (!files[i].isDirectory()) {
                if (this.getFilter() != null && !this.getFilter().accept(new File(file))) continue;
                this.pollFile(file);
                continue;
            }
            if (processDir) {
                logger.debug("Polling directory {}", (Object)file);
                this.pollFileOrDirectory(ftp, file, this.isRecursive());
                continue;
            }
            logger.debug("Skipping directory {}", (Object)file);
        }
    }

    private FTPFile[] listFiles(FTPClient ftp, String directory) throws IOException {
        if (this.changeWorkingDirectory) {
            ftp.changeWorkingDirectory(directory);
            return ftp.listFiles();
        }
        return ftp.listFiles(directory);
    }

    protected void pollFile(final String file) {
        logger.debug("Scheduling file {} for processing", (Object)file);
        this.getExecutor().execute(new Runnable(){

            public void run() {
                Lock lock = FtpPollerEndpoint.this.lockManager.getLock(file);
                if (lock.tryLock()) {
                    FtpPollerEndpoint.this.processFileNow(file);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processFileNow(String file) {
        FTPClient ftp = null;
        try {
            block8: {
                try {
                    ftp = this.borrowClient();
                    logger.debug("Processing file {}", (Object)file);
                    if (this.isFileExistingOnServer(ftp, file)) {
                        this.processFile(ftp, file);
                        ftp = null;
                        break block8;
                    }
                    logger.debug("Skipping {}: the file no longer exists on the server", (Object)file);
                }
                catch (Exception e) {
                    logger.error("Failed to process file: {}. Reason: {}", (Object)file, (Object)e);
                    Object var5_4 = null;
                    if (ftp != null) {
                        this.returnClient(ftp);
                    }
                }
            }
            Object var5_3 = null;
            if (ftp != null) {
                this.returnClient(ftp);
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (ftp != null) {
                this.returnClient(ftp);
            }
            throw throwable;
        }
    }

    private boolean isFileExistingOnServer(FTPClient ftp, String file) throws IOException {
        FTPFile[] files;
        boolean foundFile = false;
        int lastIndex = file.lastIndexOf("/");
        String directory = ".";
        String rawName = file;
        if (lastIndex > 0) {
            directory = file.substring(0, lastIndex);
            rawName = file.substring(lastIndex + 1);
        }
        if ((files = this.listFiles(ftp, directory)).length > 0) {
            for (FTPFile f : files) {
                if (!f.getName().equals(rawName)) continue;
                foundFile = true;
                break;
            }
        }
        return foundFile;
    }

    protected void processFile(FTPClient ftp, String file) throws Exception {
        InputStream in = ftp.retrieveFileStream(file);
        InOnly exchange = this.getExchangeFactory().createInOnlyExchange();
        this.configureExchangeTarget((MessageExchange)exchange);
        NormalizedMessage message = exchange.createMessage();
        exchange.setInMessage(message);
        if (this.getTargetOperation() != null) {
            exchange.setOperation(this.getTargetOperation());
        }
        this.marshaler.readMessage((MessageExchange)exchange, message, in, file);
        if (this.stateless) {
            exchange.setProperty(FtpData.class.getName(), (Object)new FtpData(file, ftp, in));
        } else {
            this.openExchanges.put(exchange.getExchangeId(), new FtpData(file, ftp, in));
        }
        this.send((MessageExchange)exchange);
    }

    public String getLocationURI() {
        return this.uri.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(MessageExchange exchange) throws Exception {
        FtpData data = this.stateless ? (FtpData)exchange.getProperty(FtpData.class.getName()) : (FtpData)this.openExchanges.remove(exchange.getExchangeId());
        if (data != null) {
            logger.debug("Releasing {}", (Object)data.file);
            try {
                data.in.close();
                data.ftp.completePendingCommand();
                if (exchange.getStatus() == ExchangeStatus.DONE) {
                    if (this.isDeleteFile()) {
                        if (this.getArchivePath() != null) {
                            String newPath = String.format("%s/%d_%s", this.getArchivePath(), System.currentTimeMillis(), data.file.substring(data.file.lastIndexOf(47) + 1));
                            data.ftp.rename(data.file, newPath);
                        } else if (!data.ftp.deleteFile(data.file)) {
                            throw new IOException("Could not delete file " + data.file);
                        }
                    }
                } else {
                    Throwable e = exchange.getError();
                    if (e == null) {
                        e = new JBIException("Unknown error");
                    }
                    throw e;
                }
                Object var5_5 = null;
                this.unlockAsyncFile(data.file);
                this.returnClient(data.ftp);
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.unlockAsyncFile(data.file);
                this.returnClient(data.ftp);
                throw throwable;
            }
        } else {
            logger.debug("Received unknown exchange. Will be ignored...");
        }
    }

    private void unlockAsyncFile(String file) {
        Lock lock = this.lockManager.getLock(file);
        if (lock != null) {
            try {
                lock.unlock();
            }
            catch (Exception ex) {
                logger.error("Can't release the lock", (Throwable)ex);
            }
            this.lockManager.removeLock(file);
        }
    }

    protected FTPClientPool createClientPool() throws Exception {
        FTPClientPool pool = new FTPClientPool();
        pool.afterPropertiesSet();
        return pool;
    }

    protected FTPClient borrowClient() throws JBIException {
        try {
            return (FTPClient)this.getClientPool().borrowClient();
        }
        catch (Exception e) {
            throw new JBIException((Throwable)e);
        }
    }

    protected void returnClient(FTPClient client) {
        if (client != null) {
            try {
                this.getClientPool().returnClient((SocketClient)client);
            }
            catch (Exception e) {
                logger.error("Failed to return client to pool: {}", (Object)e, (Object)e);
            }
        }
    }

    protected class FtpData {
        final String file;
        final FTPClient ftp;
        final InputStream in;

        public FtpData(String file, FTPClient ftp, InputStream in) {
            this.file = file;
            this.ftp = ftp;
            this.in = in;
        }
    }
}

