/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.ftp;

import java.io.IOException;
import java.net.InetAddress;
import javax.jbi.JBIException;
import org.apache.commons.net.SocketClient;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public abstract class SocketClientPoolSupport
implements InitializingBean,
DisposableBean,
PoolableObjectFactory {
    private ObjectPool pool;
    private InetAddress address;
    private String host;
    private int port = -1;
    private InetAddress localAddress;
    private int localPort;

    public void afterPropertiesSet() throws Exception {
        if (this.pool == null) {
            GenericObjectPool goPool = new GenericObjectPool();
            goPool.setTestOnBorrow(true);
            goPool.setWhenExhaustedAction((byte)2);
            this.pool = goPool;
        }
        this.pool.setFactory((PoolableObjectFactory)this);
    }

    public void destroy() throws Exception {
        if (this.pool != null) {
            this.pool.close();
        }
    }

    public SocketClient borrowClient() throws Exception {
        return (SocketClient)this.getPool().borrowObject();
    }

    public void returnClient(SocketClient client) throws Exception {
        this.getPool().returnObject((Object)client);
    }

    public Object makeObject() throws Exception {
        SocketClient client = this.createSocketClient();
        this.connect(client);
        return client;
    }

    public void destroyObject(Object object) throws Exception {
        SocketClient client = (SocketClient)object;
        this.disconnect(client);
    }

    public boolean validateObject(Object object) {
        return true;
    }

    public void activateObject(Object object) throws Exception {
    }

    public void passivateObject(Object object) throws Exception {
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public void setAddress(InetAddress address) {
        this.address = address;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public InetAddress getLocalAddress() {
        return this.localAddress;
    }

    public void setLocalAddress(InetAddress localAddress) {
        this.localAddress = localAddress;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public void setLocalPort(int localPort) {
        this.localPort = localPort;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public ObjectPool getPool() {
        return this.pool;
    }

    public void setPool(ObjectPool pool) {
        if (pool != null) {
            pool.setFactory((PoolableObjectFactory)this);
        }
        this.pool = pool;
    }

    protected void connect(SocketClient client) throws IOException, JBIException, Exception {
        if (this.host != null) {
            if (this.localAddress != null) {
                client.connect(this.host, this.port, this.localAddress, this.localPort);
            } else if (this.port >= 0) {
                client.connect(this.host, this.port);
            } else {
                client.connect(this.host);
            }
        } else if (this.address != null) {
            if (this.localAddress != null) {
                client.connect(this.address, this.port, this.localAddress, this.localPort);
            } else if (this.port >= 0) {
                client.connect(this.address, this.port);
            } else {
                client.connect(this.address);
            }
        } else {
            throw new JBIException("You must configure the address or host property");
        }
    }

    protected void disconnect(SocketClient client) throws Exception {
        if (client.isConnected()) {
            client.disconnect();
        }
    }

    protected abstract SocketClient createSocketClient();
}

