/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.ftp;

import java.io.IOException;
import org.apache.commons.net.SocketClient;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.servicemix.ftp.ConnectionRefusedException;
import org.apache.servicemix.ftp.SocketClientPoolSupport;

public class FTPClientPool
extends SocketClientPoolSupport {
    public static final int DEFAULT_DATA_TIMEOUT = -1;
    public static final String DEFAULT_CONTROL_ENCODING = "ISO-8859-1";
    private String username;
    private String password;
    private boolean binaryMode = true;
    private boolean passiveMode;
    private FTPClientConfig config;
    private String controlEncoding = "ISO-8859-1";
    private int dataTimeout = -1;

    public boolean validateObject(Object object) {
        FTPClient client = (FTPClient)object;
        try {
            return client.sendNoOp();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to validate client: " + e, e);
        }
    }

    public void activateObject(Object object) throws Exception {
        FTPClient client = (FTPClient)object;
        client.setReaderThread(true);
    }

    public void passivateObject(Object object) throws Exception {
        FTPClient client = (FTPClient)object;
        client.setReaderThread(false);
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isBinaryMode() {
        return this.binaryMode;
    }

    public void setBinaryMode(boolean binaryMode) {
        this.binaryMode = binaryMode;
    }

    public boolean isPassiveMode() {
        return this.passiveMode;
    }

    public void setPassiveMode(boolean passiveMode) {
        this.passiveMode = passiveMode;
    }

    public FTPClientConfig getConfig() {
        return this.config;
    }

    public void setConfig(FTPClientConfig config) {
        this.config = config;
    }

    public String getControlEncoding() {
        return this.controlEncoding;
    }

    public void setControlEncoding(String controlEncoding) {
        this.controlEncoding = controlEncoding;
    }

    public int getDataTimeout() {
        return this.dataTimeout;
    }

    public void setDataTimeout(int dataTimeout) {
        this.dataTimeout = dataTimeout;
    }

    protected void connect(SocketClient client) throws Exception {
        FTPClient ftp = (FTPClient)client;
        if (this.config != null) {
            ftp.configure(this.config);
        }
        ftp.setDataTimeout(this.getDataTimeout());
        ftp.setControlEncoding(this.getControlEncoding());
        super.connect((SocketClient)ftp);
        int code = ftp.getReplyCode();
        if (!FTPReply.isPositiveCompletion((int)code)) {
            ftp.disconnect();
            throw new ConnectionRefusedException(code);
        }
        if (!ftp.login(this.getUsername(), this.getPassword())) {
            ftp.disconnect();
            throw new ConnectionRefusedException(ftp.getReplyCode());
        }
        if (this.isBinaryMode()) {
            ftp.setFileType(2);
        }
        if (this.isPassiveMode()) {
            ftp.enterLocalPassiveMode();
        }
    }

    protected void disconnect(SocketClient client) throws Exception {
        FTPClient ftp = (FTPClient)client;
        if (ftp.isConnected()) {
            ftp.logout();
        }
        super.disconnect(client);
    }

    protected SocketClient createSocketClient() {
        return new FTPClient();
    }
}

