/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.ftp;

import java.io.IOException;
import org.apache.commons.net.SocketClient;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.servicemix.ftp.ConnectionRefusedException;
import org.apache.servicemix.ftp.SocketClientPoolSupport;

public class FTPClientPool
extends SocketClientPoolSupport {
    private String username;
    private String password;
    private boolean binaryMode = true;
    private boolean passiveMode = false;
    private FTPClientConfig config;

    public boolean validateObject(Object object) {
        FTPClient client = (FTPClient)object;
        try {
            return client.sendNoOp();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to validate client: " + e, e);
        }
    }

    public void activateObject(Object object) throws Exception {
        FTPClient client = (FTPClient)object;
        client.setReaderThread(true);
    }

    public void passivateObject(Object object) throws Exception {
        FTPClient client = (FTPClient)object;
        client.setReaderThread(false);
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isBinaryMode() {
        return this.binaryMode;
    }

    public void setBinaryMode(boolean binaryMode) {
        this.binaryMode = binaryMode;
    }

    public boolean isPassiveMode() {
        return this.passiveMode;
    }

    public void setPassiveMode(boolean passiveMode) {
        this.passiveMode = passiveMode;
    }

    public FTPClientConfig getConfig() {
        return this.config;
    }

    public void setConfig(FTPClientConfig config) {
        this.config = config;
    }

    protected void connect(SocketClient client) throws Exception {
        FTPClient ftp = (FTPClient)client;
        if (this.config != null) {
            ftp.configure(this.config);
        }
        super.connect(client);
        int code = ftp.getReplyCode();
        if (!FTPReply.isPositiveCompletion((int)code)) {
            ftp.disconnect();
            throw new ConnectionRefusedException(code);
        }
        if (!ftp.login(this.getUsername(), this.getPassword())) {
            ftp.disconnect();
            throw new ConnectionRefusedException(ftp.getReplyCode());
        }
        if (this.isBinaryMode()) {
            ftp.setFileType(2);
        }
        if (this.isPassiveMode()) {
            ftp.enterLocalPassiveMode();
        }
    }

    protected void disconnect(SocketClient client) throws Exception {
        FTPClient ftp = (FTPClient)client;
        if (ftp.isConnected()) {
            ftp.logout();
        }
        super.disconnect(client);
    }

    protected SocketClient createSocketClient() {
        return new FTPClient();
    }
}

