/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.ftp;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import javax.jbi.JBIException;
import javax.jbi.management.DeploymentException;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import org.apache.commons.net.SocketClient;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.servicemix.common.DefaultComponent;
import org.apache.servicemix.common.Endpoint;
import org.apache.servicemix.common.endpoints.ProviderEndpoint;
import org.apache.servicemix.components.util.DefaultFileMarshaler;
import org.apache.servicemix.components.util.FileMarshaler;
import org.apache.servicemix.ftp.FTPClientPool;
import org.apache.servicemix.ftp.FtpComponent;

public class FtpEndpoint
extends ProviderEndpoint {
    private FTPClientPool clientPool;
    private FileMarshaler marshaler = new DefaultFileMarshaler();
    private String uniqueFileName = "ServiceMix";
    private boolean overwrite = false;
    private URI uri;

    public FtpEndpoint() {
    }

    public FtpEndpoint(FtpComponent component, ServiceEndpoint endpoint) {
        super((DefaultComponent)component, endpoint);
    }

    public void validate() throws DeploymentException {
        super.validate();
        if (this.uri == null && (this.getClientPool() == null || this.getClientPool().getHost() == null)) {
            throw new DeploymentException("Property uri or clientPool.host must be configured");
        }
        if (this.uri != null && this.getClientPool() != null && this.getClientPool().getHost() != null) {
            throw new DeploymentException("Properties uri and clientPool.host can not be configured at the same time");
        }
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public void start() throws Exception {
        super.start();
        if (this.clientPool == null) {
            this.clientPool = this.createClientPool();
        }
        if (this.uri != null) {
            this.clientPool.setHost(this.uri.getHost());
            this.clientPool.setPort(this.uri.getPort());
            if (this.uri.getUserInfo() != null) {
                String[] infos = this.uri.getUserInfo().split(":");
                this.clientPool.setUsername(infos[0]);
                if (infos.length > 1) {
                    this.clientPool.setPassword(infos[1]);
                }
            }
        }
    }

    public FTPClientPool getClientPool() {
        return this.clientPool;
    }

    public void setClientPool(FTPClientPool clientPool) {
        this.clientPool = clientPool;
    }

    public FileMarshaler getMarshaler() {
        return this.marshaler;
    }

    public void setMarshaler(FileMarshaler marshaler) {
        this.marshaler = marshaler;
    }

    public String getUniqueFileName() {
        return this.uniqueFileName;
    }

    public void setUniqueFileName(String uniqueFileName) {
        this.uniqueFileName = uniqueFileName;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processInOnly(MessageExchange exchange, NormalizedMessage message) throws Exception {
        FTPClient client = null;
        OutputStream out = null;
        try {
            String name;
            client = this.borrowClient();
            if (this.uri != null && this.uri.getPath() != null) {
                client.changeWorkingDirectory(this.uri.getPath());
            }
            if ((name = this.marshaler.getOutputName(exchange, message)) == null) {
                out = this.uniqueFileName != null ? client.storeUniqueFileStream(this.uniqueFileName) : client.storeUniqueFileStream();
            } else {
                out = client.storeFileStream(name);
                if (out == null) {
                    if (this.overwrite) {
                        client.deleteFile(name);
                    }
                    out = client.storeFileStream(name);
                }
            }
            if (out == null) {
                throw new IOException("No output stream available for output name: " + name + ". Maybe the file already exists?");
            }
            this.marshaler.writeMessage(exchange, message, out, name);
        }
        finally {
            this.returnClient(client);
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    ((Endpoint)this).logger.error((Object)("Caught exception while closing stream on error: " + e), (Throwable)e);
                }
            }
        }
    }

    protected FTPClientPool createClientPool() throws Exception {
        FTPClientPool pool = new FTPClientPool();
        pool.afterPropertiesSet();
        return pool;
    }

    protected FTPClient borrowClient() throws JBIException {
        try {
            return (FTPClient)this.getClientPool().borrowClient();
        }
        catch (Exception e) {
            throw new JBIException((Throwable)e);
        }
    }

    protected void returnClient(FTPClient client) {
        if (client != null) {
            try {
                this.getClientPool().returnClient((SocketClient)client);
            }
            catch (Exception e) {
                ((Endpoint)this).logger.error((Object)("Failed to return client to pool: " + e), (Throwable)e);
            }
        }
    }
}

