/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jms;

import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.Iterator;
import java.util.Properties;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ResourceAdapter;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import org.apache.servicemix.common.ExternalEndpoint;
import org.apache.servicemix.common.security.AuthenticationService;
import org.apache.servicemix.common.security.KeystoreManager;
import org.apache.servicemix.jms.DefaultJmsMarshaler;
import org.apache.servicemix.jms.JmsComponent;
import org.apache.servicemix.jms.JmsConfiguration;
import org.apache.servicemix.jms.JmsEndpointType;
import org.apache.servicemix.jms.JmsMarshaler;
import org.apache.servicemix.soap.SoapEndpoint;
import org.apache.servicemix.soap.SoapExchangeProcessor;
import org.apache.servicemix.store.Store;
import org.apache.servicemix.store.StoreFactory;

public class JmsEndpoint
extends SoapEndpoint
implements JmsEndpointType {
    protected String initialContextFactory;
    protected String jndiProviderURL;
    protected String destinationStyle;
    protected String jndiConnectionFactoryName;
    protected String jndiDestinationName;
    protected String jmsProviderDestinationName;
    protected String jndiReplyToName;
    protected String jmsProviderReplyToName;
    protected boolean useMsgIdInResponse;
    protected ConnectionFactory connectionFactory;
    protected Destination destination;
    protected String processorName;
    protected JmsMarshaler marshaler = new DefaultJmsMarshaler(this);
    protected ResourceAdapter resourceAdapter;
    protected ActivationSpec activationSpec;
    protected BootstrapContext bootstrapContext;
    protected boolean synchronous;
    protected boolean rollbackOnError;
    protected boolean needJavaIdentifiers;
    protected Store store;
    protected StoreFactory storeFactory;

    public JmsEndpoint() {
    }

    public JmsEndpoint(boolean dynamic) {
        super(dynamic);
    }

    public BootstrapContext getBootstrapContext() {
        return this.bootstrapContext;
    }

    public void setBootstrapContext(BootstrapContext bootstrapContext) {
        this.bootstrapContext = bootstrapContext;
    }

    public boolean isSynchronous() {
        return this.synchronous;
    }

    public void setSynchronous(boolean synchronous) {
        this.synchronous = synchronous;
    }

    public boolean isRollbackOnError() {
        return this.rollbackOnError;
    }

    public void setRollbackOnError(boolean rollbackOnError) {
        this.rollbackOnError = rollbackOnError;
    }

    public ActivationSpec getActivationSpec() {
        return this.activationSpec;
    }

    public void setActivationSpec(ActivationSpec activationSpec) {
        this.activationSpec = activationSpec;
    }

    public ResourceAdapter getResourceAdapter() {
        return this.resourceAdapter;
    }

    public void setResourceAdapter(ResourceAdapter resourceAdapter) {
        this.resourceAdapter = resourceAdapter;
    }

    public String getInitialContextFactory() {
        return this.initialContextFactory;
    }

    public void setInitialContextFactory(String initialContextFactory) {
        this.initialContextFactory = initialContextFactory;
    }

    public String getJmsProviderDestinationName() {
        return this.jmsProviderDestinationName;
    }

    public void setJmsProviderDestinationName(String jmsProviderDestinationName) {
        this.jmsProviderDestinationName = jmsProviderDestinationName;
    }

    public String getJndiReplyToName() {
        return this.jndiReplyToName;
    }

    public void setJndiReplyToName(String jndiReplyToName) {
        this.jndiReplyToName = jndiReplyToName;
    }

    public String getJmsProviderReplyToName() {
        return this.jmsProviderReplyToName;
    }

    public void setJmsProviderReplyToName(String jmsProviderReplyToName) {
        this.jmsProviderReplyToName = jmsProviderReplyToName;
    }

    public String getJndiConnectionFactoryName() {
        return this.jndiConnectionFactoryName;
    }

    public void setJndiConnectionFactoryName(String jndiConnectionFactoryName) {
        this.jndiConnectionFactoryName = jndiConnectionFactoryName;
    }

    public String getJndiDestinationName() {
        return this.jndiDestinationName;
    }

    public void setJndiDestinationName(String jndiDestinationName) {
        this.jndiDestinationName = jndiDestinationName;
    }

    public String getJndiProviderURL() {
        return this.jndiProviderURL;
    }

    public void setJndiProviderURL(String jndiProviderURL) {
        this.jndiProviderURL = jndiProviderURL;
    }

    public String getDestinationStyle() {
        return this.destinationStyle;
    }

    public void setDestinationStyle(String destinationStyle) {
        this.destinationStyle = destinationStyle;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public Destination getDestination() {
        return this.destination;
    }

    public void setDestination(Destination destination) {
        this.destination = destination;
    }

    public boolean isNeedJavaIdentifiers() {
        return this.needJavaIdentifiers;
    }

    public void setNeedJavaIdentifiers(boolean needJavaIdentifiers) {
        this.needJavaIdentifiers = needJavaIdentifiers;
    }

    public void setRoleAsString(String role) {
        super.setRoleAsString(role);
    }

    public Store getStore() {
        return this.store;
    }

    public void setStore(Store store) {
        this.store = store;
    }

    public StoreFactory getStoreFactory() {
        return this.storeFactory;
    }

    public void setStoreFactory(StoreFactory storeFactory) {
        this.storeFactory = storeFactory;
    }

    protected SoapExchangeProcessor createProviderProcessor() {
        return this.createProcessor("provider");
    }

    protected SoapExchangeProcessor createConsumerProcessor() {
        return this.createProcessor("consumer");
    }

    protected SoapExchangeProcessor createProcessor(String type) {
        try {
            String procName = this.processorName;
            if (this.processorName == null) {
                procName = this.getConfiguration().getProcessorName();
            }
            String uri = "META-INF/services/org/apache/servicemix/jms/" + procName;
            InputStream in = this.loadResource(uri);
            Properties props = new Properties();
            props.load(in);
            String className = props.getProperty(type);
            Class cl = this.loadClass(className);
            Constructor cns = cl.getConstructor(this.getClass());
            return (SoapExchangeProcessor)cns.newInstance(this);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create processor of type " + type + " and name " + this.processorName, e);
        }
    }

    protected Class loadClass(String name) throws ClassNotFoundException {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader != null) {
            try {
                return contextClassLoader.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return this.getClass().getClassLoader().loadClass(name);
    }

    protected InputStream loadResource(String uri) {
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(uri);
        if (in == null && (in = this.getClass().getClassLoader().getResourceAsStream(uri)) == null) {
            this.logger.debug("Could not find resource: {}", (Object)uri);
        }
        return in;
    }

    protected ServiceEndpoint createExternalEndpoint() {
        return new ExternalEndpoint(this.getServiceUnit().getComponent().getEPRElementName(), this.getLocationURI(), this.getService(), this.getEndpoint(), this.getInterfaceName());
    }

    protected String getLocationURI() {
        return this.getService() + "#" + this.getEndpoint();
    }

    protected void overrideDefinition(Definition def) {
        Service svc = null;
        Port port = null;
        if (this.targetService != null && this.targetEndpoint != null) {
            svc = def.getService(this.targetService);
            port = svc != null ? svc.getPort(this.targetEndpoint) : null;
        } else if (this.targetService != null) {
            svc = def.getService(this.targetService);
            if (svc != null) {
                Iterator it = svc.getPorts().values().iterator();
                port = it.hasNext() ? (Port)it.next() : null;
            }
        } else if (this.targetInterfaceName != null) {
            Iterator it = def.getServices().values().iterator();
            Service service = svc = it.hasNext() ? (Service)it.next() : null;
            if (svc != null) {
                it = svc.getPorts().values().iterator();
                port = it.hasNext() ? (Port)it.next() : null;
            }
        } else {
            svc = def.getService(this.service);
            Port port2 = port = svc != null ? svc.getPort(this.endpoint) : null;
        }
        if (port != null) {
            port.getExtensibilityElements().clear();
            svc.getPorts().clear();
            svc.addPort(port);
            this.definition = def;
        }
    }

    public String toString() {
        return "JMSEndpoint[service: " + this.service + ", " + "endpoint: " + this.endpoint + ", " + "address: " + this.jndiDestinationName + "(" + this.destinationStyle + "), " + "soap: " + this.soap + "]";
    }

    public String getProcessorName() {
        return this.processorName;
    }

    public void setProcessorName(String processorName) {
        this.processorName = processorName;
    }

    public JmsConfiguration getConfiguration() {
        JmsComponent component = (JmsComponent)this.getServiceUnit().getComponent();
        return component.getConfiguration();
    }

    public AuthenticationService getAuthenticationService() {
        JmsComponent comp = (JmsComponent)this.getServiceUnit().getComponent();
        return AuthenticationService.Proxy.create((Object)comp.getAuthenticationService());
    }

    public KeystoreManager getKeystoreManager() {
        JmsComponent comp = (JmsComponent)this.getServiceUnit().getComponent();
        return KeystoreManager.Proxy.create((Object)comp.getKeystoreManager());
    }

    public boolean isUseMsgIdInResponse() {
        return this.useMsgIdInResponse;
    }

    public void setUseMsgIdInResponse(boolean useMsgIdInResponse) {
        this.useMsgIdInResponse = useMsgIdInResponse;
    }

    public JmsMarshaler getMarshaler() {
        return this.marshaler;
    }

    public void setMarshaler(JmsMarshaler marshaler) {
        this.marshaler = marshaler;
    }
}

