/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jms.multiplexing;

import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.messaging.RobustInOnly;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.naming.InitialContext;
import org.apache.servicemix.jms.AbstractJmsProcessor;
import org.apache.servicemix.jms.JmsEndpoint;
import org.apache.servicemix.soap.SoapFault;
import org.apache.servicemix.soap.marshalers.SoapMessage;

public class MultiplexingProviderProcessor
extends AbstractJmsProcessor
implements MessageListener {
    protected MessageConsumer consumer;
    protected MessageProducer producer;

    public MultiplexingProviderProcessor(JmsEndpoint endpoint) throws Exception {
        super(endpoint);
    }

    protected void doInit(InitialContext ctx) throws Exception {
        this.commonDoStartTasks(ctx);
        if (this.endpoint.getJndiReplyToName() == null && this.endpoint.getJmsProviderReplyToName() == null) {
            this.replyToDestination = this.destination instanceof Queue ? this.session.createTemporaryQueue() : this.session.createTemporaryTopic();
        }
        this.producer = this.session.createProducer(this.destination);
        this.consumer = this.session.createConsumer(this.replyToDestination);
        this.consumer.setMessageListener((MessageListener)this);
    }

    protected void doShutdown() throws Exception {
        this.session = null;
        this.destination = null;
        this.consumer = null;
        this.producer = null;
        this.replyToDestination = null;
    }

    public void onMessage(final Message message) {
        this.logger.debug("Received jms message {}", (Object)message);
        this.endpoint.getServiceUnit().getComponent().getExecutor(MessageExchange.Role.PROVIDER).execute(new Runnable(){

            public void run() {
                InOut exchange = null;
                MultiplexingProviderProcessor.this.logger.debug("Handling jms message {}", (Object)message);
                String correlationID = null;
                try {
                    correlationID = message.getJMSCorrelationID();
                    exchange = (InOut)MultiplexingProviderProcessor.this.store.load(correlationID);
                    if (exchange == null) {
                        throw new IllegalStateException();
                    }
                }
                catch (Exception e) {
                    MultiplexingProviderProcessor.this.logger.error("Could not find exchange {}", (Object)(correlationID == null ? "" : correlationID), (Object)e);
                    return;
                }
                try {
                    SoapMessage soap = MultiplexingProviderProcessor.this.endpoint.getMarshaler().toSOAP(message);
                    SoapFault soapFault = soap.getFault();
                    if (soapFault != null) {
                        Fault fault = exchange.createFault();
                        fault.setContent(soapFault.getDetails());
                        exchange.setFault(fault);
                    } else {
                        NormalizedMessage msg = exchange.createMessage();
                        MultiplexingProviderProcessor.this.soapHelper.getJBIMarshaler().toNMS(msg, soap);
                        exchange.setOutMessage(msg);
                    }
                }
                catch (Exception e) {
                    MultiplexingProviderProcessor.this.logger.error("Error while handling jms message", (Throwable)e);
                    exchange.setError(e);
                }
                try {
                    MultiplexingProviderProcessor.this.channel.send((MessageExchange)exchange);
                }
                catch (MessagingException e) {
                    MultiplexingProviderProcessor.this.logger.error("Error while handling jms message", (Throwable)e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(MessageExchange exchange) throws Exception {
        block13: {
            if (exchange.getStatus() == ExchangeStatus.DONE) {
                return;
            }
            if (exchange.getStatus() == ExchangeStatus.ERROR) {
                return;
            }
            Message msg = this.createMessageFromExchange(this.session, exchange);
            if (exchange instanceof InOnly || exchange instanceof RobustInOnly) {
                MessageProducer messageProducer = this.producer;
                synchronized (messageProducer) {
                    this.producer.send(msg);
                }
                exchange.setStatus(ExchangeStatus.DONE);
                this.channel.send(exchange);
            } else {
                if (exchange instanceof InOut) {
                    msg.setJMSCorrelationID(exchange.getExchangeId());
                    msg.setJMSReplyTo(this.replyToDestination);
                    this.store.store(exchange.getExchangeId(), (Object)exchange);
                    try {
                        MessageProducer messageProducer = this.producer;
                        synchronized (messageProducer) {
                            this.producer.send(msg);
                            break block13;
                        }
                    }
                    catch (Exception e) {
                        this.store.load(exchange.getExchangeId());
                        throw e;
                    }
                }
                throw new IllegalStateException(exchange.getPattern() + " not implemented");
            }
        }
    }
}

