/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.common.management;

import javax.jbi.JBIException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MBeanServerHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(MBeanServerHelper.class);

    public static ObjectName register(MBeanServer server, ObjectName name, Object object) throws JBIException {
        if (server == null) {
            throw new JBIException("MBeanServer is null when registering MBean " + name);
        }
        try {
            MBeanServerHelper.doUnregister(server, name);
            LOGGER.debug("Registering MBean {}", (Object)name);
            ObjectInstance instance = MBeanServerHelper.doRegister(server, name, object);
            ObjectName result = instance.getObjectName();
            LOGGER.debug("Successfully registered MBean {}", (Object)result);
            return result;
        }
        catch (JMException e) {
            throw new JBIException("Exception occured while registering JMX MBean " + name, (Throwable)e);
        }
    }

    private static ObjectInstance doRegister(MBeanServer server, ObjectName name, Object object) throws JMException, JBIException {
        try {
            return server.registerMBean(object, name);
        }
        catch (InstanceAlreadyExistsException e) {
            ObjectName existing = new ObjectName(e.getMessage());
            if (existing.equals(name)) {
                throw e;
            }
            LOGGER.debug("Existing MBean {} matches {} - unregistering it before continuing", (Object)existing, (Object)name);
            MBeanServerHelper.doUnregister(server, existing);
            return MBeanServerHelper.doRegister(server, name, object);
        }
    }

    public static void unregister(MBeanServer server, ObjectName name) throws JBIException {
        if (name != null) {
            if (server == null) {
                throw new JBIException("MBeanServer is null when registering MBean " + name);
            }
            try {
                MBeanServerHelper.doUnregister(server, name);
            }
            catch (JMException e) {
                throw new JBIException("Unable to unregister object with name " + name, (Throwable)e);
            }
        }
    }

    private static void doUnregister(MBeanServer server, ObjectName name) throws JMException {
        if (server.isRegistered(name)) {
            LOGGER.debug("Unregistering MBean {}", (Object)name);
            server.unregisterMBean(name);
        }
    }
}

