/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jms;

import javax.jbi.JBIException;
import javax.jbi.component.Bootstrap;
import javax.jbi.component.InstallationContext;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.servicemix.common.management.MBeanServerHelper;
import org.apache.servicemix.jms.JmsConfiguration;

public class JmsBootstrap
implements Bootstrap {
    protected InstallationContext context;
    protected ObjectName mbeanName;
    protected JmsConfiguration configuration;

    public ObjectName getExtensionMBeanName() {
        return this.mbeanName;
    }

    protected Object getExtensionMBean() throws Exception {
        return this.configuration;
    }

    protected ObjectName createExtensionMBeanName() throws Exception {
        return this.context.getContext().getMBeanNames().createCustomComponentMBeanName("bootstrap");
    }

    public void init(InstallationContext installContext) throws JBIException {
        try {
            this.context = installContext;
            this.doInit();
        }
        catch (JBIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JBIException("Error calling init", (Throwable)e);
        }
    }

    protected void doInit() throws Exception {
        this.configuration = new JmsConfiguration();
        this.configuration.setRootDir(this.context.getInstallRoot());
        this.configuration.setComponentName(this.context.getComponentName());
        this.configuration.load();
        Object mbean = this.getExtensionMBean();
        if (mbean != null) {
            this.mbeanName = MBeanServerHelper.register((MBeanServer)this.getMBeanServer(), (ObjectName)this.createExtensionMBeanName(), (Object)mbean);
        }
    }

    public void cleanUp() throws JBIException {
        try {
            this.doCleanUp();
        }
        catch (JBIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JBIException("Error calling cleanUp", (Throwable)e);
        }
    }

    protected void doCleanUp() throws Exception {
        MBeanServerHelper.unregister((MBeanServer)this.getMBeanServer(), (ObjectName)this.mbeanName);
    }

    public void onInstall() throws JBIException {
        try {
            this.doOnInstall();
        }
        catch (JBIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JBIException("Error calling onInstall", (Throwable)e);
        }
    }

    protected void doOnInstall() throws Exception {
    }

    public void onUninstall() throws JBIException {
        try {
            this.doOnUninstall();
        }
        catch (JBIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JBIException("Error calling onUninstall", (Throwable)e);
        }
    }

    protected void doOnUninstall() throws Exception {
    }

    private MBeanServer getMBeanServer() {
        return this.context.getContext().getMBeanServer();
    }
}

