/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jms;

import java.util.Hashtable;
import javax.jbi.messaging.MessageExchange;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.naming.InitialContext;
import org.apache.servicemix.common.ExchangeProcessor;
import org.apache.servicemix.jms.JmsEndpoint;

public abstract class AbstractJmsProcessor
implements ExchangeProcessor {
    public static final String STYLE_QUEUE = "queue";
    public static final String STYLE_TOPIC = "topic";
    protected JmsEndpoint endpoint;
    protected Connection connection;

    public AbstractJmsProcessor(JmsEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    public void start() throws Exception {
        InitialContext ctx = null;
        ConnectionFactory connectionFactory = null;
        try {
            Hashtable<String, String> props;
            connectionFactory = this.endpoint.getConnectionFactory();
            if (connectionFactory == null && this.endpoint.getJndiConnectionFactoryName() != null) {
                props = new Hashtable<String, String>();
                if (this.endpoint.getInitialContextFactory() != null && this.endpoint.getJndiProviderURL() != null) {
                    props.put("java.naming.factory.initial", this.endpoint.getInitialContextFactory());
                    props.put("java.naming.provider.url", this.endpoint.getJndiProviderURL());
                } else if (this.endpoint.getConfiguration().getJndiInitialContextFactory() != null && this.endpoint.getConfiguration().getJndiProviderUrl() != null) {
                    props.put("java.naming.factory.initial", this.endpoint.getConfiguration().getJndiInitialContextFactory());
                    props.put("java.naming.provider.url", this.endpoint.getConfiguration().getJndiProviderUrl());
                }
                ctx = new InitialContext(props);
                connectionFactory = (ConnectionFactory)ctx.lookup(this.endpoint.getJndiConnectionFactoryName());
            }
            if (connectionFactory == null && this.endpoint.getConfiguration().getConnectionFactory() != null) {
                connectionFactory = this.endpoint.getConfiguration().getConnectionFactory();
            }
            if (connectionFactory == null && this.endpoint.getConfiguration().getJndiConnectionFactoryName() != null) {
                props = new Hashtable();
                if (this.endpoint.getInitialContextFactory() != null && this.endpoint.getJndiProviderURL() != null) {
                    props.put("java.naming.factory.initial", this.endpoint.getInitialContextFactory());
                    props.put("java.naming.provider.url", this.endpoint.getJndiProviderURL());
                } else if (this.endpoint.getConfiguration().getJndiInitialContextFactory() != null && this.endpoint.getConfiguration().getJndiProviderUrl() != null) {
                    props.put("java.naming.factory.initial", this.endpoint.getConfiguration().getJndiInitialContextFactory());
                    props.put("java.naming.provider.url", this.endpoint.getConfiguration().getJndiProviderUrl());
                }
                ctx = new InitialContext(props);
                connectionFactory = (ConnectionFactory)ctx.lookup(this.endpoint.getConfiguration().getJndiConnectionFactoryName());
            }
            this.connection = connectionFactory.createConnection();
            this.connection.start();
            this.doStart(ctx);
        }
        catch (Exception e) {
            try {
                this.stop();
            }
            catch (Exception inner) {
                // empty catch block
            }
            throw e;
        }
        finally {
            if (ctx != null) {
                ctx.close();
            }
        }
    }

    protected void doStart(InitialContext ctx) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        try {
            this.doStop();
            if (this.connection != null) {
                this.connection.close();
            }
        }
        finally {
            this.connection = null;
        }
    }

    protected void doStop() throws Exception {
    }

    public abstract /* synthetic */ void process(MessageExchange var1) throws Exception;
}

