/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jms;

import javax.jms.ConnectionFactory;
import org.apache.servicemix.common.PersistentConfiguration;
import org.apache.servicemix.jbi.security.auth.AuthenticationService;
import org.apache.servicemix.jbi.security.keystore.KeystoreManager;
import org.apache.servicemix.jms.JmsConfigurationMBean;

public class JmsConfiguration
extends PersistentConfiguration
implements JmsConfigurationMBean {
    private String userName;
    private String password;
    private String jndiInitialContextFactory;
    private String jndiProviderUrl;
    private String jndiConnectionFactoryName;
    private String processorName = "multiplexing";
    private transient ConnectionFactory connectionFactory;
    private transient KeystoreManager keystoreManager;
    private transient AuthenticationService authenticationService;
    private String authenticationServiceName = "java:comp/env/smx/AuthenticationService";
    private String keystoreManagerName = "java:comp/env/smx/KeystoreManager";

    public AuthenticationService getAuthenticationService() {
        return this.authenticationService;
    }

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public String getAuthenticationServiceName() {
        return this.authenticationServiceName;
    }

    public void setAuthenticationServiceName(String authenticationServiceName) {
        this.authenticationServiceName = authenticationServiceName;
    }

    public KeystoreManager getKeystoreManager() {
        return this.keystoreManager;
    }

    public void setKeystoreManager(KeystoreManager keystoreManager) {
        this.keystoreManager = keystoreManager;
        this.save();
    }

    public String getKeystoreManagerName() {
        return this.keystoreManagerName;
    }

    public void setKeystoreManagerName(String keystoreManagerName) {
        this.keystoreManagerName = keystoreManagerName;
        this.save();
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
        this.save();
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
        this.save();
    }

    public String getJndiConnectionFactoryName() {
        return this.jndiConnectionFactoryName;
    }

    public void setJndiConnectionFactoryName(String jndiName) {
        this.jndiConnectionFactoryName = jndiName;
        this.save();
    }

    public String getJndiInitialContextFactory() {
        return this.jndiInitialContextFactory;
    }

    public void setJndiInitialContextFactory(String jndiInitialContextFactory) {
        this.jndiInitialContextFactory = jndiInitialContextFactory;
        this.save();
    }

    public String getJndiProviderUrl() {
        return this.jndiProviderUrl;
    }

    public void setJndiProviderUrl(String jndiProviderUrl) {
        this.jndiProviderUrl = jndiProviderUrl;
        this.save();
    }

    public String getProcessorName() {
        return this.processorName;
    }

    public void setProcessorName(String processorName) {
        this.processorName = processorName;
        this.save();
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public void save() {
        this.properties.setProperty("userName", this.userName);
        this.properties.setProperty("password", this.password);
        this.properties.setProperty("jndiInitialContextFactory", this.jndiInitialContextFactory);
        this.properties.setProperty("jndiProviderUrl", this.jndiProviderUrl);
        this.properties.setProperty("jndiName", this.jndiConnectionFactoryName);
        this.properties.setProperty("processorName", this.processorName);
        this.properties.setProperty("keystoreManagerName", this.keystoreManagerName);
        this.properties.setProperty("authenticationServiceName", this.authenticationServiceName);
        super.save();
    }

    public boolean load() {
        if (super.load()) {
            if (this.properties.getProperty("userName") != null) {
                this.userName = this.properties.getProperty("userName");
            }
            if (this.properties.getProperty("password") != null) {
                this.password = this.properties.getProperty("password");
            }
            if (this.properties.getProperty("jndiInitialContextFactory") != null) {
                this.jndiInitialContextFactory = this.properties.getProperty("jndiInitialContextFactory");
            }
            if (this.properties.getProperty("jndiProviderUrl") != null) {
                this.jndiProviderUrl = this.properties.getProperty("jndiProviderUrl");
            }
            if (this.properties.getProperty("jndiName") != null) {
                this.jndiConnectionFactoryName = this.properties.getProperty("jndiName");
            }
            if (this.properties.getProperty("processorName") != null) {
                this.processorName = this.properties.getProperty("processorName");
            }
            if (this.properties.getProperty("keystoreManagerName") != null) {
                this.keystoreManagerName = this.properties.getProperty("keystoreManagerName");
            }
            if (this.properties.getProperty("authenticationServiceName") != null) {
                this.authenticationServiceName = this.properties.getProperty("authenticationServiceName");
            }
            return true;
        }
        return false;
    }
}

