/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jms;

import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.Iterator;
import java.util.Properties;
import javax.jbi.component.ComponentLifeCycle;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import org.apache.servicemix.common.Endpoint;
import org.apache.servicemix.common.ExchangeProcessor;
import org.apache.servicemix.jbi.security.auth.AuthenticationService;
import org.apache.servicemix.jbi.security.keystore.KeystoreManager;
import org.apache.servicemix.jms.JmsConfiguration;
import org.apache.servicemix.jms.JmsExternalEndpoint;
import org.apache.servicemix.jms.JmsLifeCycle;
import org.apache.servicemix.jms.wsdl.JmsBinding;
import org.apache.servicemix.soap.SoapEndpoint;

public class JmsEndpoint
extends SoapEndpoint {
    protected JmsBinding binding;
    protected String initialContextFactory;
    protected String jndiProviderURL;
    protected String destinationStyle;
    protected String jndiConnectionFactoryName;
    protected String jndiDestinationName;
    protected String jmsProviderDestinationName;
    protected ConnectionFactory connectionFactory;
    protected Destination destination;
    protected String processorName;

    public JmsBinding getBinding() {
        return this.binding;
    }

    public void setBinding(JmsBinding binding) {
        this.binding = binding;
    }

    public String getInitialContextFactory() {
        return this.initialContextFactory;
    }

    public void setInitialContextFactory(String initialContextFactory) {
        this.initialContextFactory = initialContextFactory;
    }

    public String getJmsProviderDestinationName() {
        return this.jmsProviderDestinationName;
    }

    public void setJmsProviderDestinationName(String jmsProviderDestinationName) {
        this.jmsProviderDestinationName = jmsProviderDestinationName;
    }

    public String getJndiConnectionFactoryName() {
        return this.jndiConnectionFactoryName;
    }

    public void setJndiConnectionFactoryName(String jndiConnectionFactoryName) {
        this.jndiConnectionFactoryName = jndiConnectionFactoryName;
    }

    public String getJndiDestinationName() {
        return this.jndiDestinationName;
    }

    public void setJndiDestinationName(String jndiDestinationName) {
        this.jndiDestinationName = jndiDestinationName;
    }

    public String getJndiProviderURL() {
        return this.jndiProviderURL;
    }

    public void setJndiProviderURL(String jndiProviderURL) {
        this.jndiProviderURL = jndiProviderURL;
    }

    public String getDestinationStyle() {
        return this.destinationStyle;
    }

    public void setDestinationStyle(String destinationStyle) {
        this.destinationStyle = destinationStyle;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public Destination getDestination() {
        return this.destination;
    }

    public void setDestination(Destination destination) {
        this.destination = destination;
    }

    public void setRoleAsString(String role) {
        super.setRoleAsString(role);
    }

    protected ExchangeProcessor createProviderProcessor() {
        return this.createProcessor("provider");
    }

    protected ExchangeProcessor createConsumerProcessor() {
        return this.createProcessor("consumer");
    }

    protected ExchangeProcessor createProcessor(String type) {
        try {
            String procName = this.processorName;
            if (this.processorName == null) {
                JmsLifeCycle lf = (JmsLifeCycle)this.getServiceUnit().getComponent().getLifeCycle();
                procName = lf.getConfiguration().getProcessorName();
            }
            String uri = "META-INF/services/org/apache/servicemix/jms/" + procName;
            InputStream in = this.loadResource(uri);
            Properties props = new Properties();
            props.load(in);
            String className = props.getProperty(type);
            Class cl = this.loadClass(className);
            Constructor cns = cl.getConstructor(((Object)((Object)this)).getClass());
            return (ExchangeProcessor)cns.newInstance(new Object[]{this});
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create processor of type " + type + " and name " + this.processorName, e);
        }
    }

    protected Class loadClass(String name) throws ClassNotFoundException {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader != null) {
            try {
                return contextClassLoader.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return ((Object)((Object)this)).getClass().getClassLoader().loadClass(name);
    }

    protected InputStream loadResource(String uri) {
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(uri);
        if (in == null && (in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(uri)) == null) {
            ((Endpoint)this).logger.debug((Object)("Could not find resource: " + uri));
        }
        return in;
    }

    protected ServiceEndpoint createExternalEndpoint() {
        return new JmsExternalEndpoint(this);
    }

    protected void overrideDefinition(Definition def) {
        Service svc = null;
        Port port = null;
        if (this.targetService != null && this.targetEndpoint != null) {
            svc = def.getService(this.targetService);
            port = svc != null ? svc.getPort(this.targetEndpoint) : null;
        } else if (this.targetService != null) {
            svc = def.getService(this.targetService);
            if (svc != null) {
                Iterator it = svc.getPorts().values().iterator();
                port = it.hasNext() ? (Port)it.next() : null;
            }
        } else if (this.targetInterfaceName != null) {
            Iterator it = def.getServices().values().iterator();
            Service service = svc = it.hasNext() ? (Service)it.next() : null;
            if (svc != null) {
                it = svc.getPorts().values().iterator();
                port = it.hasNext() ? (Port)it.next() : null;
            }
        } else {
            svc = def.getService(((Endpoint)this).service);
            Port port2 = port = svc != null ? svc.getPort(((Endpoint)this).endpoint) : null;
        }
        if (port != null) {
            port.getExtensibilityElements().clear();
            svc.getPorts().clear();
            svc.addPort(port);
            ((Endpoint)this).definition = def;
        }
    }

    public String toString() {
        return "JMSEndpoint[service: " + ((Endpoint)this).service + ", " + "endpoint: " + ((Endpoint)this).endpoint + ", " + "address: " + this.jndiDestinationName + "(" + this.destinationStyle + "), " + "soap: " + this.soap + "]";
    }

    public String getProcessorName() {
        return this.processorName;
    }

    public void setProcessorName(String processorName) {
        this.processorName = processorName;
    }

    public JmsConfiguration getConfiguration() {
        JmsLifeCycle lifeCycle = (JmsLifeCycle)this.getServiceUnit().getComponent().getLifeCycle();
        return lifeCycle.getConfiguration();
    }

    public AuthenticationService getAuthenticationService() {
        ComponentLifeCycle lf = this.getServiceUnit().getComponent().getLifeCycle();
        return ((JmsLifeCycle)lf).getAuthenticationService();
    }

    public KeystoreManager getKeystoreManager() {
        ComponentLifeCycle lf = this.getServiceUnit().getComponent().getLifeCycle();
        return ((JmsLifeCycle)lf).getKeystoreManager();
    }
}

