/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jms;

import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.servicemix.jms.JmsEndpoint;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class JmsExternalEndpoint
implements ServiceEndpoint {
    private JmsEndpoint endpoint;

    public JmsExternalEndpoint(JmsEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    public DocumentFragment getAsReference(QName operationName) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            Document doc = dbf.newDocumentBuilder().newDocument();
            DocumentFragment df = doc.createDocumentFragment();
            Element e = doc.createElementNS("urn:servicemix:jms", "epr");
            Text t = doc.createTextNode(this.endpoint.getService() + "#" + this.endpoint.getEndpoint());
            e.appendChild(t);
            df.appendChild(e);
            return df;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create reference", e);
        }
    }

    public String getEndpointName() {
        return this.endpoint.getEndpoint();
    }

    public QName[] getInterfaces() {
        if (this.endpoint.getInterfaceName() != null) {
            return new QName[]{this.endpoint.getInterfaceName()};
        }
        return null;
    }

    public QName getServiceName() {
        return this.endpoint.getService();
    }
}

