/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jms;

import java.net.URI;
import java.util.Map;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.apache.activemq.util.IntrospectionSupport;
import org.apache.activemq.util.URISupport;
import org.apache.servicemix.common.AsyncBaseLifeCycle;
import org.apache.servicemix.common.BaseComponent;
import org.apache.servicemix.common.BaseLifeCycle;
import org.apache.servicemix.common.Endpoint;
import org.apache.servicemix.common.ServiceUnit;
import org.apache.servicemix.jbi.security.auth.AuthenticationService;
import org.apache.servicemix.jbi.security.auth.impl.JAASAuthenticationService;
import org.apache.servicemix.jbi.security.keystore.KeystoreManager;
import org.apache.servicemix.jms.JmsConfiguration;
import org.apache.servicemix.jms.JmsEndpoint;
import org.apache.servicemix.jms.JmsResolvedEndpoint;

public class JmsLifeCycle
extends BaseLifeCycle {
    protected JmsConfiguration configuration = new JmsConfiguration();

    public JmsLifeCycle(BaseComponent component) {
        super(component);
    }

    protected Object getExtensionMBean() throws Exception {
        return this.configuration;
    }

    protected void doInit() throws Exception {
        String name;
        super.doInit();
        this.configuration.setRootDir(((AsyncBaseLifeCycle)this).context.getWorkspaceRoot());
        this.configuration.load();
        if (this.configuration.getKeystoreManager() == null) {
            try {
                name = this.configuration.getKeystoreManagerName();
                Object km = ((AsyncBaseLifeCycle)this).context.getNamingContext().lookup(name);
                this.configuration.setKeystoreManager((KeystoreManager)km);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.configuration.getAuthenticationService() == null) {
            try {
                name = this.configuration.getAuthenticationServiceName();
                Object as = ((AsyncBaseLifeCycle)this).context.getNamingContext().lookup(name);
                this.configuration.setAuthenticationService((AuthenticationService)as);
            }
            catch (Exception e) {
                this.configuration.setAuthenticationService((AuthenticationService)new JAASAuthenticationService());
            }
        }
    }

    public JmsConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(JmsConfiguration configuration) {
        this.configuration = configuration;
    }

    protected QName getEPRServiceName() {
        return JmsResolvedEndpoint.EPR_SERVICE;
    }

    protected Endpoint getResolvedEPR(ServiceEndpoint ep) throws Exception {
        JmsEndpoint jmsEp = new JmsEndpoint();
        jmsEp.setServiceUnit(new ServiceUnit(((AsyncBaseLifeCycle)this).component));
        jmsEp.setService(ep.getServiceName());
        jmsEp.setEndpoint(ep.getEndpointName());
        jmsEp.setRole(MessageExchange.Role.PROVIDER);
        URI uri = new URI(ep.getEndpointName());
        Map map = URISupport.parseQuery((String)uri.getQuery());
        if (IntrospectionSupport.setProperties((Object)((Object)jmsEp), (Map)map, (String)"jms.")) {
            uri = URISupport.createRemainingURI((URI)uri, (Map)map);
        }
        if (uri.getPath() != null) {
            String path = uri.getSchemeSpecificPart();
            while (path.startsWith("/")) {
                path = path.substring(1);
            }
            if (path.startsWith("queue/")) {
                jmsEp.setDestinationStyle("queue");
                jmsEp.setJmsProviderDestinationName(path.substring("queue".length() + 1));
            } else if (path.startsWith("topic/")) {
                jmsEp.setDestinationStyle("topic");
                jmsEp.setJmsProviderDestinationName(path.substring("topic".length() + 1));
            }
        }
        jmsEp.activateDynamic();
        return jmsEp;
    }

    public KeystoreManager getKeystoreManager() {
        return this.configuration.getKeystoreManager();
    }

    public void setKeystoreManager(KeystoreManager keystoreManager) {
        this.configuration.setKeystoreManager(keystoreManager);
    }

    public AuthenticationService getAuthenticationService() {
        return this.configuration.getAuthenticationService();
    }

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.configuration.setAuthenticationService(authenticationService);
    }
}

