/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jms;

import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.apache.servicemix.jbi.util.DOMUtil;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JmsResolvedEndpoint
implements ServiceEndpoint {
    public static final String EPR_URI = "urn:servicemix:jms";
    public static final QName EPR_SERVICE = new QName("urn:servicemix:jms", "JmsComponent");
    public static final String EPR_NAME = "epr";
    private DocumentFragment reference;
    private String epName;

    public JmsResolvedEndpoint(DocumentFragment epr, String epName) {
        this.reference = epr;
        this.epName = epName;
    }

    public DocumentFragment getAsReference(QName operationName) {
        return this.reference;
    }

    public String getEndpointName() {
        return this.epName;
    }

    public QName[] getInterfaces() {
        return null;
    }

    public QName getServiceName() {
        return EPR_SERVICE;
    }

    public static ServiceEndpoint resolveEndpoint(DocumentFragment epr) {
        Node child;
        if (epr.getChildNodes().getLength() == 1 && (child = epr.getFirstChild()) instanceof Element) {
            Element address;
            String uri;
            Element elem = (Element)child;
            String nsUri = elem.getNamespaceURI();
            String name = elem.getLocalName();
            if (EPR_URI.equals(nsUri) && EPR_NAME.equals(name)) {
                return new JmsResolvedEndpoint(epr, DOMUtil.getElementText((Element)elem));
            }
            NodeList nl = elem.getElementsByTagNameNS("http://www.w3.org/2005/08/addressing", "Address");
            if (nl.getLength() == 1 && (uri = DOMUtil.getElementText((Element)(address = (Element)nl.item(0)))) != null && (uri = uri.trim()).startsWith("jms://")) {
                return new JmsResolvedEndpoint(epr, uri);
            }
        }
        return null;
    }
}

