/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jms.multiplexing;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Map;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.common.BaseLifeCycle;
import org.apache.servicemix.common.Endpoint;
import org.apache.servicemix.jms.AbstractJmsProcessor;
import org.apache.servicemix.jms.JmsEndpoint;
import org.apache.servicemix.soap.Context;
import org.apache.servicemix.soap.SoapEndpoint;
import org.apache.servicemix.soap.SoapFault;
import org.apache.servicemix.soap.SoapHelper;
import org.apache.servicemix.soap.marshalers.SoapMessage;
import org.apache.servicemix.soap.marshalers.SoapWriter;

public class MultiplexingConsumerProcessor
extends AbstractJmsProcessor
implements MessageListener {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$servicemix$jms$multiplexing$MultiplexingConsumerProcessor == null ? (class$org$apache$servicemix$jms$multiplexing$MultiplexingConsumerProcessor = MultiplexingConsumerProcessor.class$("org.apache.servicemix.jms.multiplexing.MultiplexingConsumerProcessor")) : class$org$apache$servicemix$jms$multiplexing$MultiplexingConsumerProcessor));
    protected Session session;
    protected Destination destination;
    protected MessageConsumer consumer;
    protected Map pendingMessages = new ConcurrentHashMap();
    protected DeliveryChannel channel;
    protected SoapHelper soapHelper;
    static /* synthetic */ Class class$org$apache$servicemix$jms$multiplexing$MultiplexingConsumerProcessor;
    static /* synthetic */ Class class$javax$jms$Message;

    public MultiplexingConsumerProcessor(JmsEndpoint endpoint) {
        super(endpoint);
        this.soapHelper = new SoapHelper((SoapEndpoint)endpoint);
    }

    protected void doStart(InitialContext ctx) throws Exception {
        this.session = this.connection.createSession(false, 1);
        this.destination = this.endpoint.getDestination();
        if (this.destination == null) {
            if (this.endpoint.getJndiDestinationName() != null) {
                this.destination = (Destination)ctx.lookup(this.endpoint.getJndiDestinationName());
            } else if (this.endpoint.getJmsProviderDestinationName() != null) {
                this.destination = "queue".equals(this.endpoint.getDestinationStyle()) ? this.session.createQueue(this.endpoint.getJmsProviderDestinationName()) : this.session.createTopic(this.endpoint.getJmsProviderDestinationName());
            } else {
                throw new IllegalStateException("No destination provided");
            }
        }
        this.consumer = this.session.createConsumer(this.destination);
        this.consumer.setMessageListener((MessageListener)this);
        this.channel = this.endpoint.getServiceUnit().getComponent().getComponentContext().getDeliveryChannel();
    }

    protected void doStop() throws Exception {
        this.session = null;
        this.destination = null;
        this.consumer = null;
        this.pendingMessages.clear();
    }

    public void onMessage(final Message message) {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Received jms message " + message));
            }
            this.endpoint.getServiceUnit().getComponent().getWorkManager().scheduleWork(new Work(){

                public void release() {
                }

                public void run() {
                    try {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Handling jms message " + message));
                        }
                        ByteArrayInputStream is = null;
                        if (message instanceof TextMessage) {
                            is = new ByteArrayInputStream(((TextMessage)message).getText().getBytes());
                        } else if (message instanceof BytesMessage) {
                            int length = (int)((BytesMessage)message).getBodyLength();
                            byte[] bytes = new byte[length];
                            ((BytesMessage)message).readBytes(bytes);
                            is = new ByteArrayInputStream(bytes);
                        } else {
                            throw new IllegalArgumentException("JMS message should be a text or bytes message");
                        }
                        String contentType = message.getStringProperty("Content-Type");
                        SoapMessage soap = MultiplexingConsumerProcessor.this.soapHelper.getSoapMarshaler().createReader().read((InputStream)is, contentType);
                        Context context = MultiplexingConsumerProcessor.this.soapHelper.createContext(soap);
                        MessageExchange exchange = MultiplexingConsumerProcessor.this.soapHelper.onReceive(context);
                        context.setProperty((class$javax$jms$Message == null ? (class$javax$jms$Message = MultiplexingConsumerProcessor.class$("javax.jms.Message")) : class$javax$jms$Message).getName(), (Object)message);
                        MultiplexingConsumerProcessor.this.pendingMessages.put(exchange.getExchangeId(), context);
                        BaseLifeCycle lf = (BaseLifeCycle)MultiplexingConsumerProcessor.this.endpoint.getServiceUnit().getComponent().getLifeCycle();
                        lf.sendConsumerExchange(exchange, (Endpoint)MultiplexingConsumerProcessor.this.endpoint);
                    }
                    catch (Throwable e) {
                        log.error((Object)"Error while handling jms message", e);
                    }
                }
            });
        }
        catch (WorkException e) {
            log.error((Object)"Error while handling jms message", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(MessageExchange exchange) throws Exception {
        Context context = (Context)this.pendingMessages.remove(exchange.getExchangeId());
        Message message = (Message)context.getProperty((class$javax$jms$Message == null ? (class$javax$jms$Message = MultiplexingConsumerProcessor.class$("javax.jms.Message")) : class$javax$jms$Message).getName());
        MessageProducer producer = null;
        ObjectMessage response = null;
        try {
            if (exchange.getStatus() == ExchangeStatus.ERROR) {
                Exception e = exchange.getError();
                if (e == null) {
                    e = new Exception("Unkown error");
                }
                response = this.session.createObjectMessage((Serializable)e);
            } else if (exchange.getStatus() == ExchangeStatus.ACTIVE) {
                if (exchange.getFault() != null) {
                    SoapFault fault = new SoapFault(SoapFault.RECEIVER, null, null, null, exchange.getFault().getContent());
                    SoapMessage soapFault = this.soapHelper.onFault(context, fault);
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    SoapWriter writer = this.soapHelper.getSoapMarshaler().createWriter(soapFault);
                    writer.write((OutputStream)baos);
                    response = this.session.createTextMessage(baos.toString());
                    response.setStringProperty("Content-Type", writer.getContentType());
                } else {
                    NormalizedMessage outMsg = exchange.getMessage("out");
                    if (outMsg != null) {
                        SoapMessage out = this.soapHelper.onReply(context, outMsg);
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        SoapWriter writer = this.soapHelper.getSoapMarshaler().createWriter(out);
                        writer.write((OutputStream)baos);
                        response = this.session.createTextMessage(baos.toString());
                        response.setStringProperty("Content-Type", writer.getContentType());
                    }
                }
            }
            if (response != null) {
                producer = this.session.createProducer(message.getJMSReplyTo());
                response.setJMSCorrelationID(message.getJMSCorrelationID());
                producer.send((Message)response);
            }
        }
        finally {
            if (producer != null) {
                producer.close();
            }
            if (exchange.getStatus() == ExchangeStatus.ACTIVE) {
                exchange.setStatus(ExchangeStatus.DONE);
                this.channel.send(exchange);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

