/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jms.standard;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.resource.spi.work.Work;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jms.AbstractJmsProcessor;
import org.apache.servicemix.jms.JmsEndpoint;
import org.apache.servicemix.soap.Context;
import org.apache.servicemix.soap.SoapEndpoint;
import org.apache.servicemix.soap.SoapFault;
import org.apache.servicemix.soap.SoapHelper;
import org.apache.servicemix.soap.marshalers.SoapMessage;
import org.apache.servicemix.soap.marshalers.SoapWriter;

public class StandardConsumerProcessor
extends AbstractJmsProcessor {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$servicemix$jms$standard$StandardConsumerProcessor == null ? (class$org$apache$servicemix$jms$standard$StandardConsumerProcessor = StandardConsumerProcessor.class$("org.apache.servicemix.jms.standard.StandardConsumerProcessor")) : class$org$apache$servicemix$jms$standard$StandardConsumerProcessor));
    protected Session session;
    protected Destination destination;
    protected DeliveryChannel channel;
    protected SoapHelper soapHelper;
    protected AtomicBoolean running = new AtomicBoolean(false);
    static /* synthetic */ Class class$org$apache$servicemix$jms$standard$StandardConsumerProcessor;
    static /* synthetic */ Class class$javax$jms$Message;

    public StandardConsumerProcessor(JmsEndpoint endpoint) {
        super(endpoint);
        this.soapHelper = new SoapHelper((SoapEndpoint)endpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStart(InitialContext ctx) throws Exception {
        this.destination = this.endpoint.getDestination();
        if (this.destination == null) {
            if (this.endpoint.getJndiDestinationName() != null) {
                this.destination = (Destination)ctx.lookup(this.endpoint.getJndiDestinationName());
            } else if (this.endpoint.getJmsProviderDestinationName() == null) {
                throw new IllegalStateException("No destination provided");
            }
        }
        this.channel = this.endpoint.getServiceUnit().getComponent().getComponentContext().getDeliveryChannel();
        AtomicBoolean atomicBoolean = this.running;
        synchronized (atomicBoolean) {
            this.endpoint.getServiceUnit().getComponent().getWorkManager().startWork(new Work(){

                public void release() {
                }

                public void run() {
                    StandardConsumerProcessor.this.poll();
                }
            });
            this.running.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws Exception {
        if (this.running.get()) {
            AtomicBoolean atomicBoolean = this.running;
            synchronized (atomicBoolean) {
                if (this.session != null) {
                    this.session.close();
                }
                this.running.wait();
            }
        }
        this.session = null;
        this.destination = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void poll() {
        AtomicBoolean atomicBoolean = this.running;
        synchronized (atomicBoolean) {
            this.running.set(true);
            this.running.notify();
        }
        try {
            this.session = this.connection.createSession(false, 1);
            if (this.destination == null) {
                this.destination = "queue".equals(this.endpoint.getDestinationStyle()) ? this.session.createQueue(this.endpoint.getJmsProviderDestinationName()) : this.session.createTopic(this.endpoint.getJmsProviderDestinationName());
            }
            MessageConsumer consumer = this.session.createConsumer(this.destination);
            while (this.running.get()) {
                Message message = consumer.receive();
                if (message == null) continue;
                this.onMessage(message);
            }
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
        }
        finally {
            AtomicBoolean atomicBoolean2 = this.running;
            synchronized (atomicBoolean2) {
                this.running.set(false);
                this.running.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Received jms message " + message));
            }
            ByteArrayInputStream is = null;
            if (message instanceof TextMessage) {
                is = new ByteArrayInputStream(((TextMessage)message).getText().getBytes());
            } else if (message instanceof BytesMessage) {
                int length = (int)((BytesMessage)message).getBodyLength();
                byte[] bytes = new byte[length];
                ((BytesMessage)message).readBytes(bytes);
                is = new ByteArrayInputStream(bytes);
            } else {
                throw new IllegalArgumentException("JMS message should be a text or bytes message");
            }
            String contentType = message.getStringProperty("Content-Type");
            SoapMessage soap = this.soapHelper.getSoapMarshaler().createReader().read((InputStream)is, contentType);
            Context context = this.soapHelper.createContext(soap);
            MessageExchange exchange = this.soapHelper.onReceive(context);
            context.setProperty((class$javax$jms$Message == null ? (class$javax$jms$Message = StandardConsumerProcessor.class$("javax.jms.Message")) : class$javax$jms$Message).getName(), (Object)message);
            if (!this.channel.sendSync(exchange)) {
                throw new IllegalStateException("Exchange has been aborted");
            }
            MessageProducer producer = null;
            ObjectMessage response = null;
            try {
                if (exchange.getStatus() == ExchangeStatus.ERROR) {
                    Exception e = exchange.getError();
                    if (e == null) {
                        e = new Exception("Unkown error");
                    }
                    response = this.session.createObjectMessage((Serializable)e);
                } else if (exchange.getStatus() == ExchangeStatus.ACTIVE) {
                    if (exchange.getFault() != null) {
                        SoapFault fault = new SoapFault(SoapFault.RECEIVER, null, null, null, exchange.getFault().getContent());
                        SoapMessage soapFault = this.soapHelper.onFault(context, fault);
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        SoapWriter writer = this.soapHelper.getSoapMarshaler().createWriter(soapFault);
                        writer.write((OutputStream)baos);
                        response = this.session.createTextMessage(baos.toString());
                        response.setStringProperty("Content-Type", writer.getContentType());
                    } else {
                        NormalizedMessage outMsg = exchange.getMessage("out");
                        if (outMsg != null) {
                            SoapMessage out = this.soapHelper.onReply(context, outMsg);
                            ByteArrayOutputStream baos = new ByteArrayOutputStream();
                            SoapWriter writer = this.soapHelper.getSoapMarshaler().createWriter(out);
                            writer.write((OutputStream)baos);
                            response = this.session.createTextMessage(baos.toString());
                            response.setStringProperty("Content-Type", writer.getContentType());
                        }
                    }
                }
                if (response != null) {
                    producer = this.session.createProducer(message.getJMSReplyTo());
                    response.setJMSCorrelationID(message.getJMSCorrelationID());
                    producer.send((Message)response);
                }
            }
            finally {
                if (producer != null) {
                    producer.close();
                }
                if (exchange.getStatus() == ExchangeStatus.ACTIVE) {
                    exchange.setStatus(ExchangeStatus.DONE);
                    this.channel.send(exchange);
                }
            }
        }
        catch (Throwable e) {
            log.error((Object)"Error while handling jms message", e);
        }
    }

    public void process(MessageExchange exchange) throws Exception {
        throw new IllegalStateException();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

