/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jms.standard;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.messaging.RobustInOnly;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jms.AbstractJmsProcessor;
import org.apache.servicemix.jms.JmsEndpoint;
import org.apache.servicemix.soap.SoapEndpoint;
import org.apache.servicemix.soap.SoapHelper;
import org.apache.servicemix.soap.marshalers.SoapMessage;
import org.apache.servicemix.soap.marshalers.SoapWriter;

public class StandardProviderProcessor
extends AbstractJmsProcessor {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$servicemix$jms$standard$StandardProviderProcessor == null ? (class$org$apache$servicemix$jms$standard$StandardProviderProcessor = StandardProviderProcessor.class$("org.apache.servicemix.jms.standard.StandardProviderProcessor")) : class$org$apache$servicemix$jms$standard$StandardProviderProcessor));
    protected Session session;
    protected Destination destination;
    protected Destination replyToDestination;
    protected MessageConsumer consumer;
    protected MessageProducer producer;
    protected DeliveryChannel channel;
    protected SoapHelper soapHelper;
    static /* synthetic */ Class class$org$apache$servicemix$jms$standard$StandardProviderProcessor;

    public StandardProviderProcessor(JmsEndpoint endpoint) {
        super(endpoint);
        this.soapHelper = new SoapHelper((SoapEndpoint)endpoint);
    }

    protected void doStart(InitialContext ctx) throws Exception {
        this.channel = this.endpoint.getServiceUnit().getComponent().getComponentContext().getDeliveryChannel();
        this.destination = this.endpoint.getDestination();
        if (this.destination == null) {
            if (this.endpoint.getJndiDestinationName() != null) {
                this.destination = (Destination)ctx.lookup(this.endpoint.getJndiDestinationName());
            } else if (this.endpoint.getJmsProviderDestinationName() == null) {
                throw new IllegalStateException("No destination provided");
            }
        }
    }

    protected void doStop() throws Exception {
        this.session = null;
        this.destination = null;
        this.consumer = null;
        this.producer = null;
        this.replyToDestination = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void process(MessageExchange exchange) throws Exception {
        if (exchange.getStatus() == ExchangeStatus.DONE) {
            return;
        }
        if (exchange.getStatus() == ExchangeStatus.ERROR) {
            return;
        }
        try {
            this.session = this.connection.createSession(false, 1);
            if (this.destination == null) {
                this.destination = "queue".equals(this.endpoint.getDestinationStyle()) ? this.session.createQueue(this.endpoint.getJmsProviderDestinationName()) : this.session.createTopic(this.endpoint.getJmsProviderDestinationName());
            }
            this.producer = this.session.createProducer(this.destination);
            SoapMessage soapMessage = new SoapMessage();
            NormalizedMessage nm = exchange.getMessage("in");
            this.soapHelper.getJBIMarshaler().fromNMS(soapMessage, nm);
            SoapWriter writer = this.soapHelper.getSoapMarshaler().createWriter(soapMessage);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            writer.write((OutputStream)baos);
            TextMessage msg = this.session.createTextMessage(baos.toString());
            msg.setStringProperty("Content-Type", writer.getContentType());
            Map headers = (Map)nm.getProperty("javax.jbi.protocol.headers");
            if (headers != null) {
                Iterator it = headers.keySet().iterator();
                while (it.hasNext()) {
                    String name = (String)it.next();
                    String value = (String)headers.get(name);
                    msg.setStringProperty(name, value);
                }
            }
            if (exchange instanceof InOnly || exchange instanceof RobustInOnly) {
                this.producer.send((Message)msg);
                return;
            } else {
                if (!(exchange instanceof InOut)) throw new IllegalStateException(exchange.getPattern() + " not implemented");
                this.replyToDestination = this.destination instanceof Queue ? this.session.createTemporaryQueue() : this.session.createTemporaryTopic();
                this.consumer = this.session.createConsumer(this.replyToDestination);
                msg.setJMSCorrelationID(exchange.getExchangeId());
                msg.setJMSReplyTo(this.replyToDestination);
                this.producer.send((Message)msg);
                Message message = this.consumer.receive();
                if (message instanceof ObjectMessage) {
                    Serializable o = ((ObjectMessage)message).getObject();
                    if (!(o instanceof Exception)) throw new UnsupportedOperationException("Can not handle objects of type " + o.getClass().getName());
                    exchange.setError((Exception)o);
                } else {
                    ByteArrayInputStream is = null;
                    if (message instanceof TextMessage) {
                        is = new ByteArrayInputStream(((TextMessage)message).getText().getBytes());
                    } else {
                        if (!(message instanceof BytesMessage)) throw new IllegalArgumentException("JMS message should be a text or bytes message");
                        int length = (int)((BytesMessage)message).getBodyLength();
                        byte[] bytes = new byte[length];
                        ((BytesMessage)message).readBytes(bytes);
                        is = new ByteArrayInputStream(bytes);
                    }
                    String contentType = message.getStringProperty("Content-Type");
                    SoapMessage soap = this.soapHelper.getSoapMarshaler().createReader().read((InputStream)is, contentType);
                    NormalizedMessage out = exchange.createMessage();
                    this.soapHelper.getJBIMarshaler().toNMS(out, soap);
                    ((InOut)exchange).setOutMessage(out);
                }
                this.channel.send(exchange);
            }
            return;
        }
        finally {
            if (this.session != null) {
                this.session.close();
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

