/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jbi.JBIException;
import org.apache.servicemix.common.BaseComponent;
import org.apache.servicemix.common.Endpoint;
import org.apache.servicemix.common.EndpointSupport;

public class ServiceUnit {
    protected BaseComponent component;
    protected String name;
    protected String rootPath;
    protected String status = "Shutdown";
    protected Map endpoints = new HashMap();

    public ServiceUnit() {
    }

    public ServiceUnit(BaseComponent component) {
        this.component = component;
    }

    public void start() throws Exception {
        ArrayList<Endpoint> activated = new ArrayList<Endpoint>();
        try {
            Iterator iter = this.getEndpoints().iterator();
            while (iter.hasNext()) {
                Endpoint endpoint = (Endpoint)iter.next();
                endpoint.activate();
                activated.add(endpoint);
            }
            this.status = "Started";
        }
        catch (Exception e) {
            Iterator iter = activated.iterator();
            while (iter.hasNext()) {
                try {
                    Endpoint endpoint = (Endpoint)iter.next();
                    endpoint.deactivate();
                }
                catch (Exception e2) {}
            }
            throw e;
        }
    }

    public void stop() throws Exception {
        this.status = "Stopped";
        Exception exception = null;
        Iterator iter = this.getEndpoints().iterator();
        while (iter.hasNext()) {
            Endpoint endpoint = (Endpoint)iter.next();
            try {
                endpoint.deactivate();
            }
            catch (Exception e) {
                exception = e;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    public void shutDown() throws JBIException {
        this.status = "Shutdown";
    }

    public String getCurrentState() {
        return this.status;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    public BaseComponent getComponent() {
        return this.component;
    }

    public void setComponent(BaseComponent component) {
        this.component = component;
    }

    public Collection getEndpoints() {
        return this.endpoints.values();
    }

    public void addEndpoint(Endpoint endpoint) {
        String key = EndpointSupport.getKey(endpoint);
        if (this.endpoints.put(key, endpoint) != null) {
            throw new IllegalStateException("More than one endpoint found in the SU for key: " + key);
        }
    }

    public Endpoint getEndpoint(String key) {
        return (Endpoint)this.endpoints.get(key);
    }
}

