/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.soap;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.PortType;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.jaxp.W3CDOMStreamWriter;
import org.apache.servicemix.soap.Context;
import org.apache.servicemix.soap.Handler;
import org.apache.servicemix.soap.SoapEndpoint;
import org.apache.servicemix.soap.SoapFault;
import org.apache.servicemix.soap.marshalers.JBIMarshaler;
import org.apache.servicemix.soap.marshalers.SoapMarshaler;
import org.apache.servicemix.soap.marshalers.SoapMessage;
import org.apache.servicemix.soap.marshalers.SoapWriter;
import org.w3c.dom.Document;

public class SoapHelper {
    private static final Log logger = LogFactory.getLog((Class)(class$org$apache$servicemix$soap$SoapHelper == null ? (class$org$apache$servicemix$soap$SoapHelper = SoapHelper.class$("org.apache.servicemix.soap.SoapHelper")) : class$org$apache$servicemix$soap$SoapHelper));
    public static final URI IN_ONLY = URI.create("http://www.w3.org/2004/08/wsdl/in-only");
    public static final URI IN_OUT = URI.create("http://www.w3.org/2004/08/wsdl/in-out");
    public static final URI ROBUST_IN_ONLY = URI.create("http://www.w3.org/2004/08/wsdl/robust-in-only");
    private SoapEndpoint endpoint;
    private List policies;
    private JBIMarshaler jbiMarshaler;
    private SoapMarshaler soapMarshaler;
    private Map definitions;
    static /* synthetic */ Class class$org$apache$servicemix$soap$SoapHelper;

    public SoapHelper(SoapEndpoint endpoint) {
        this.policies = endpoint.getPolicies();
        if (this.policies == null) {
            this.policies = Collections.EMPTY_LIST;
        }
        this.definitions = new HashMap();
        this.jbiMarshaler = new JBIMarshaler();
        this.endpoint = endpoint;
        boolean requireDom = false;
        Iterator iter = this.policies.iterator();
        while (iter.hasNext()) {
            Handler handler = (Handler)iter.next();
            requireDom |= handler.requireDOM();
        }
        this.soapMarshaler = new SoapMarshaler(endpoint.isSoap(), requireDom);
        if (endpoint.isSoap() && "1.1".equals(endpoint.getSoapVersion())) {
            this.soapMarshaler.setSoapUri("http://schemas.xmlsoap.org/soap/envelope/");
        }
    }

    public SoapMarshaler getSoapMarshaler() {
        return this.soapMarshaler;
    }

    public JBIMarshaler getJBIMarshaler() {
        return this.jbiMarshaler;
    }

    public MessageExchange onReceive(Context context) throws Exception {
        String endpointName;
        QName serviceName;
        ComponentContext componentContext;
        ServiceEndpoint se;
        URI mep;
        if (this.policies != null) {
            Iterator it = this.policies.iterator();
            while (it.hasNext()) {
                Handler policy = (Handler)it.next();
                policy.onReceive(context);
            }
        }
        if ((mep = this.findMep(context)) == null) {
            mep = this.endpoint.getDefaultMep();
        }
        MessageExchange exchange = this.createExchange(mep);
        if (context.getProperty("org.apache.servicemix.Service") == null && context.getProperty("org.apache.servicemix.Interface") == null) {
            if (this.endpoint.getDefaultOperation() != null) {
                context.setProperty("org.apache.servicemix.Operation", this.endpoint.getDefaultOperation());
            } else {
                context.setProperty("org.apache.servicemix.Operation", context.getInMessage().getBodyName());
            }
            if (this.endpoint.getTargetInterfaceName() == null && this.endpoint.getTargetService() == null && this.endpoint.getTargetEndpoint() == null) {
                context.setProperty("org.apache.servicemix.Interface", this.endpoint.getInterfaceName());
                context.setProperty("org.apache.servicemix.Service", this.endpoint.getService());
                context.setProperty("org.apache.servicemix.Endpoint", this.endpoint.getEndpoint());
            } else {
                context.setProperty("org.apache.servicemix.Interface", this.endpoint.getTargetInterfaceName());
                context.setProperty("org.apache.servicemix.Service", this.endpoint.getTargetService());
                context.setProperty("org.apache.servicemix.Endpoint", this.endpoint.getTargetEndpoint());
            }
        }
        exchange.setService((QName)context.getProperty("org.apache.servicemix.Service"));
        exchange.setInterfaceName((QName)context.getProperty("org.apache.servicemix.Interface"));
        exchange.setOperation((QName)context.getProperty("org.apache.servicemix.Operation"));
        if (context.getProperty("org.apache.servicemix.Endpoint") != null && (se = (componentContext = this.endpoint.getServiceUnit().getComponent().getComponentContext()).getEndpoint(serviceName = (QName)context.getProperty("org.apache.servicemix.Service"), endpointName = (String)context.getProperty("org.apache.servicemix.Endpoint"))) != null) {
            exchange.setEndpoint(se);
        }
        NormalizedMessage inMessage = exchange.createMessage();
        this.jbiMarshaler.toNMS(inMessage, context.getInMessage());
        exchange.setMessage(inMessage, "in");
        return exchange;
    }

    public SoapMessage onReply(Context context, NormalizedMessage outMsg) throws Exception {
        SoapMessage out = new SoapMessage();
        if (context.getInMessage() != null) {
            out.setEnvelopeName(context.getInMessage().getEnvelopeName());
        }
        this.jbiMarshaler.fromNMS(out, outMsg);
        context.setOutMessage(out);
        if (this.policies != null) {
            Iterator it = this.policies.iterator();
            while (it.hasNext()) {
                Handler policy = (Handler)it.next();
                policy.onReply(context);
            }
        }
        return out;
    }

    public SoapMessage onFault(Context context, SoapFault fault) throws Exception {
        SoapMessage soapFault = new SoapMessage();
        soapFault.setFault(fault);
        if (context == null) {
            context = new Context();
        }
        if (context.getInMessage() != null) {
            soapFault.setEnvelopeName(context.getInMessage().getEnvelopeName());
        }
        context.setFaultMessage(soapFault);
        if (this.policies != null) {
            Iterator it = this.policies.iterator();
            while (it.hasNext()) {
                Handler policy = (Handler)it.next();
                policy.onFault(context);
            }
        }
        return soapFault;
    }

    public void onSend(Context context) throws Exception {
        if (this.policies != null) {
            Iterator it = this.policies.iterator();
            while (it.hasNext()) {
                Handler policy = (Handler)it.next();
                if (policy.requireDOM()) {
                    SoapWriter writer = this.soapMarshaler.createWriter(context.getInMessage());
                    W3CDOMStreamWriter domWriter = new W3CDOMStreamWriter();
                    writer.writeSoapEnvelope((XMLStreamWriter)domWriter);
                    context.getInMessage().setDocument(domWriter.getDocument());
                }
                policy.onSend(context);
            }
        }
    }

    public void onAnswer(Context context) throws Exception {
        if (this.policies != null) {
            Iterator it = this.policies.iterator();
            while (it.hasNext()) {
                Handler policy = (Handler)it.next();
                policy.onAnswer(context);
            }
        }
    }

    public Context createContext(SoapMessage message) {
        Context context = new Context();
        context.setProperty("org.apache.servicemix.AuthenticationService", this.endpoint.getAuthenticationService());
        context.setProperty("org.apache.servicemix.KeystoreManager", this.endpoint.getKeystoreManager());
        context.setInMessage(message);
        return context;
    }

    protected MessageExchange createExchange(URI mep) throws MessagingException {
        ComponentContext context = this.endpoint.getServiceUnit().getComponent().getComponentContext();
        DeliveryChannel channel = context.getDeliveryChannel();
        MessageExchangeFactory factory = channel.createExchangeFactory();
        MessageExchange exchange = factory.createExchange(mep);
        return exchange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected URI findMep(Context context) throws Exception {
        Operation oper;
        PortType portType;
        ServiceEndpoint[] ses;
        QName interfaceName = (QName)context.getProperty("org.apache.servicemix.Interface");
        QName serviceName = (QName)context.getProperty("org.apache.servicemix.Service");
        QName operationName = (QName)context.getProperty("org.apache.servicemix.Operation");
        String endpointName = (String)context.getProperty("org.apache.servicemix.Endpoint");
        ComponentContext componentContext = this.endpoint.getServiceUnit().getComponent().getComponentContext();
        ServiceEndpoint se = null;
        if (serviceName != null && endpointName != null) {
            se = componentContext.getEndpoint(serviceName, endpointName);
        }
        if (se == null && interfaceName != null && (ses = componentContext.getEndpoints(interfaceName)) != null && ses.length > 0) {
            se = ses[0];
        }
        Definition definition = null;
        if (se == null) {
            definition = this.endpoint.getDefinition();
        } else {
            String key = se.getServiceName() + se.getEndpointName();
            Map map = this.definitions;
            synchronized (map) {
                definition = (Definition)this.definitions.get(key);
                if (definition == null) {
                    WSDLFactory factory;
                    block13: {
                        factory = WSDLFactory.newInstance();
                        Document description = componentContext.getEndpointDescriptor(se);
                        if (description != null) {
                            WSDLReader reader = factory.newWSDLReader();
                            try {
                                definition = reader.readWSDL(null, description);
                            }
                            catch (WSDLException e) {
                                logger.info((Object)("Could not read wsdl from endpoint descriptor: " + e.getMessage()));
                                if (!logger.isDebugEnabled()) break block13;
                                logger.debug((Object)"Could not read wsdl from endpoint descriptor", (Throwable)e);
                            }
                        }
                    }
                    if (definition == null) {
                        definition = factory.newDefinition();
                    }
                    this.definitions.put(key, definition);
                }
            }
        }
        URI mep = null;
        if (interfaceName != null && operationName != null && definition != null && (portType = definition.getPortType(interfaceName)) != null && (oper = portType.getOperation(operationName.getLocalPart(), null, null)) != null) {
            boolean faults;
            boolean output = oper.getOutput() != null && oper.getOutput().getMessage() != null && oper.getOutput().getMessage().getParts().size() > 0;
            boolean bl = faults = oper.getFaults().size() > 0;
            mep = output ? IN_OUT : (faults ? ROBUST_IN_ONLY : IN_ONLY);
        }
        return mep;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

