/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.components.crypto;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.apache.commons.discovery.Resource;
import org.apache.commons.discovery.ResourceIterator;
import org.apache.commons.discovery.jdk.JDKHooks;
import org.apache.commons.discovery.resource.DiscoverResources;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.CredentialException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.X509NameTokenizer;

public abstract class AbstractCrypto
implements Crypto {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$ws$security$components$crypto$AbstractCrypto == null ? (class$org$apache$ws$security$components$crypto$AbstractCrypto = AbstractCrypto.class$("org.apache.ws.security.components.crypto.AbstractCrypto")) : class$org$apache$ws$security$components$crypto$AbstractCrypto));
    protected static CertificateFactory certFact;
    protected Properties properties = null;
    protected KeyStore keystore = null;
    static String SKI_OID;
    static /* synthetic */ Class class$org$apache$ws$security$components$crypto$AbstractCrypto;

    public AbstractCrypto(Properties properties) throws CredentialException, IOException {
        this(properties, (class$org$apache$ws$security$components$crypto$AbstractCrypto == null ? (class$org$apache$ws$security$components$crypto$AbstractCrypto = AbstractCrypto.class$("org.apache.ws.security.components.crypto.AbstractCrypto")) : class$org$apache$ws$security$components$crypto$AbstractCrypto).getClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractCrypto(Properties properties, ClassLoader loader) throws CredentialException, IOException {
        if (properties == null) {
            return;
        }
        this.properties = properties;
        String location = this.properties.getProperty("org.apache.ws.security.crypto.merlin.file");
        InputStream is = null;
        DiscoverResources disc = new DiscoverResources();
        disc.addClassLoader(JDKHooks.getJDKHooks().getThreadContextClassLoader());
        disc.addClassLoader(loader);
        ResourceIterator iterator = disc.findResources(location);
        if (iterator.hasNext()) {
            Resource resource = iterator.nextResource();
            is = resource.getResourceAsStream();
        }
        if (is == null) {
            try {
                is = new FileInputStream(location);
            }
            catch (Exception e) {
                throw new CredentialException(3, "proxyNotFound", new Object[]{location});
            }
        }
        try {
            this.load(is);
        }
        finally {
            is.close();
        }
    }

    public synchronized CertificateFactory getCertificateFactory() throws WSSecurityException {
        if (certFact == null) {
            try {
                String provider = this.properties.getProperty("org.apache.ws.security.crypto.merlin.cert.provider");
                certFact = provider == null || provider.length() == 0 ? CertificateFactory.getInstance("X.509") : CertificateFactory.getInstance("X.509", provider);
            }
            catch (CertificateException e) {
                throw new WSSecurityException(7, "unsupportedCertType");
            }
            catch (NoSuchProviderException e) {
                throw new WSSecurityException(7, "noSecProvider");
            }
        }
        return certFact;
    }

    public X509Certificate loadCertificate(InputStream in) throws WSSecurityException {
        X509Certificate cert = null;
        try {
            cert = (X509Certificate)this.getCertificateFactory().generateCertificate(in);
        }
        catch (CertificateException e) {
            throw new WSSecurityException(7, "parseError");
        }
        return cert;
    }

    public PrivateKey getPrivateKey(String alias, String password) throws Exception {
        if (alias == null) {
            throw new Exception("alias is null");
        }
        boolean b = this.keystore.isKeyEntry(alias);
        if (!b) {
            log.error((Object)("Cannot find key for alias: " + alias));
            throw new Exception("Cannot find key for alias: " + alias);
        }
        Key keyTmp = this.keystore.getKey(alias, password.toCharArray());
        if (!(keyTmp instanceof PrivateKey)) {
            throw new Exception("Key is not a private key, alias: " + alias);
        }
        return (PrivateKey)keyTmp;
    }

    private Vector splitAndTrim(String inString) {
        X509NameTokenizer nmTokens = new X509NameTokenizer(inString);
        Vector<String> vr = new Vector<String>();
        while (nmTokens.hasMoreTokens()) {
            vr.add(nmTokens.nextToken());
        }
        Collections.sort(vr);
        return vr;
    }

    public String getAliasForX509Cert(String issuer) throws WSSecurityException {
        return this.getAliasForX509Cert(issuer, null, false);
    }

    public String getAliasForX509Cert(String issuer, BigInteger serialNumber) throws WSSecurityException {
        return this.getAliasForX509Cert(issuer, serialNumber, true);
    }

    private String getAliasForX509Cert(String issuer, BigInteger serialNumber, boolean useSerialNumber) throws WSSecurityException {
        Vector issuerRDN = this.splitAndTrim(issuer);
        X509Certificate x509cert = null;
        Vector certRDN = null;
        Certificate cert = null;
        try {
            Enumeration<String> e = this.keystore.aliases();
            while (e.hasMoreElements()) {
                String alias = e.nextElement();
                Certificate[] certs = this.keystore.getCertificateChain(alias);
                if (certs == null || certs.length == 0) {
                    cert = this.keystore.getCertificate(alias);
                    if (cert == null) {
                        return null;
                    }
                } else {
                    cert = certs[0];
                }
                if (!(cert instanceof X509Certificate)) continue;
                x509cert = (X509Certificate)cert;
                if (useSerialNumber && (!useSerialNumber || x509cert.getSerialNumber().compareTo(serialNumber) != 0) || !(certRDN = this.splitAndTrim(x509cert.getIssuerDN().getName())).equals(issuerRDN)) continue;
                return alias;
            }
        }
        catch (KeyStoreException e) {
            throw new WSSecurityException(0, "keystore");
        }
        return null;
    }

    public String getAliasForX509Cert(byte[] skiBytes) throws WSSecurityException {
        Certificate cert = null;
        boolean found = false;
        try {
            Enumeration<String> e = this.keystore.aliases();
            while (e.hasMoreElements()) {
                byte[] data;
                String alias = e.nextElement();
                Certificate[] certs = this.keystore.getCertificateChain(alias);
                if (certs == null || certs.length == 0) {
                    cert = this.keystore.getCertificate(alias);
                    if (cert == null) {
                        return null;
                    }
                } else {
                    cert = certs[0];
                }
                if (!(cert instanceof X509Certificate) || (data = this.getSKIBytesFromCert((X509Certificate)cert)).length != skiBytes.length || !Arrays.equals(data, skiBytes)) continue;
                return alias;
            }
        }
        catch (KeyStoreException e) {
            throw new WSSecurityException(0, "keystore");
        }
        return null;
    }

    public String getAliasForX509Cert(Certificate cert) throws WSSecurityException {
        try {
            String alias = this.keystore.getCertificateAlias(cert);
            if (alias != null) {
                return alias;
            }
            Enumeration<String> e = this.keystore.aliases();
            while (e.hasMoreElements()) {
                alias = e.nextElement();
                X509Certificate cert2 = (X509Certificate)this.keystore.getCertificate(alias);
                if (!cert2.equals(cert)) continue;
                return alias;
            }
        }
        catch (KeyStoreException e) {
            throw new WSSecurityException(0, "keystore");
        }
        return null;
    }

    public String getDefaultX509Alias() {
        if (this.properties == null) {
            return null;
        }
        return this.properties.getProperty("org.apache.ws.security.crypto.merlin.keystore.alias");
    }

    public X509Certificate[] getCertificates(String alias) throws WSSecurityException {
        Certificate[] certs = null;
        try {
            certs = this.keystore.getCertificateChain(alias);
            if (certs == null || certs.length == 0) {
                Certificate cert = this.keystore.getCertificate(alias);
                if (cert == null) {
                    return null;
                }
                certs = new Certificate[]{cert};
            }
        }
        catch (KeyStoreException e) {
            throw new WSSecurityException(0, "keystore");
        }
        X509Certificate[] x509certs = new X509Certificate[certs.length];
        for (int i = 0; i < certs.length; ++i) {
            x509certs[i] = (X509Certificate)certs[i];
        }
        return x509certs;
    }

    public String getAliasForX509CertThumb(byte[] thumb) throws WSSecurityException {
        Certificate cert = null;
        MessageDigest sha = null;
        try {
            sha = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e1) {
            throw new WSSecurityException(0, "noSHA1availabe");
        }
        try {
            Enumeration<String> e = this.keystore.aliases();
            while (e.hasMoreElements()) {
                String alias = e.nextElement();
                Certificate[] certs = this.keystore.getCertificateChain(alias);
                if (certs == null || certs.length == 0) {
                    cert = this.keystore.getCertificate(alias);
                    if (cert == null) {
                        return null;
                    }
                } else {
                    cert = certs[0];
                }
                if (!(cert instanceof X509Certificate)) continue;
                sha.reset();
                try {
                    sha.update(cert.getEncoded());
                }
                catch (CertificateEncodingException e1) {
                    throw new WSSecurityException(7, "encodeError");
                }
                byte[] data = sha.digest();
                if (!Arrays.equals(data, thumb)) continue;
                return alias;
            }
        }
        catch (KeyStoreException e) {
            throw new WSSecurityException(0, "keystore");
        }
        return null;
    }

    public void setKeyStore(KeyStore ks) {
        this.keystore = ks;
    }

    public void load(InputStream input) throws CredentialException {
        if (input == null) {
            throw new IllegalArgumentException("input stream cannot be null");
        }
        try {
            String provider = this.properties.getProperty("org.apache.ws.security.crypto.merlin.keystore.provider");
            this.keystore = provider == null || provider.length() == 0 ? KeyStore.getInstance(this.properties.getProperty("org.apache.ws.security.crypto.merlin.keystore.type", KeyStore.getDefaultType())) : KeyStore.getInstance(this.properties.getProperty("org.apache.ws.security.crypto.merlin.keystore.type", KeyStore.getDefaultType()), provider);
            String password = this.properties.getProperty("org.apache.ws.security.crypto.merlin.keystore.password", "security");
            this.keystore.load(input, password == null || password.length() == 0 ? new char[]{} : password.toCharArray());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new CredentialException(3, "ioError00", e);
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
            throw new CredentialException(3, "secError00", e);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CredentialException(-1, "error00", e);
        }
    }

    public byte[] getSKIBytesFromCert(X509Certificate cert) throws WSSecurityException {
        byte[] derEncodedValue = cert.getExtensionValue(SKI_OID);
        if (cert.getVersion() < 3 || derEncodedValue == null) {
            MessageDigest sha;
            PublicKey key = cert.getPublicKey();
            if (!(key instanceof RSAPublicKey)) {
                throw new WSSecurityException(1, "noSKIHandling", new Object[]{"Support for RSA key only"});
            }
            byte[] encoded = key.getEncoded();
            byte[] value = new byte[encoded.length - 22];
            System.arraycopy(encoded, 22, value, 0, value.length);
            try {
                sha = MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException ex) {
                throw new WSSecurityException(1, "noSKIHandling", new Object[]{"Wrong certificate version (<3) and no SHA1 message digest availabe"});
            }
            sha.reset();
            sha.update(value);
            return sha.digest();
        }
        byte[] abyte0 = new byte[derEncodedValue.length - 4];
        System.arraycopy(derEncodedValue, 4, abyte0, 0, abyte0.length);
        return abyte0;
    }

    public KeyStore getKeyStore() {
        return this.keystore;
    }

    public String[] getAliasesForDN(String subjectDN) throws WSSecurityException {
        Vector<String> aliases = new Vector<String>();
        Certificate cert = null;
        Vector subjectRDN = this.splitAndTrim(subjectDN);
        try {
            Enumeration<String> e = this.keystore.aliases();
            while (e.hasMoreElements()) {
                Vector foundRDN;
                String alias = e.nextElement();
                Certificate[] certs = this.keystore.getCertificateChain(alias);
                if (certs == null || certs.length == 0) {
                    cert = this.keystore.getCertificate(alias);
                    if (cert == null) {
                        return null;
                    }
                    certs = new Certificate[]{cert};
                } else {
                    cert = certs[0];
                }
                if (!(cert instanceof X509Certificate) || !subjectRDN.equals(foundRDN = this.splitAndTrim(((X509Certificate)cert).getSubjectDN().getName()))) continue;
                aliases.add(alias);
            }
        }
        catch (KeyStoreException e) {
            throw new WSSecurityException(0, "keystore");
        }
        String[] result = new String[aliases.size()];
        for (int i = 0; i < aliases.size(); ++i) {
            result[i] = (String)aliases.elementAt(i);
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        SKI_OID = "2.5.29.14";
    }
}

