/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.message;

import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.Vector;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.SOAPConstants;
import org.apache.ws.security.WSEncryptionPart;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.message.WSSecEncryptedKey;
import org.apache.ws.security.message.WSSecHeader;
import org.apache.ws.security.message.token.Reference;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.xml.security.encryption.EncryptedData;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.apache.xml.security.keys.KeyInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WSSecEncrypt
extends WSSecEncryptedKey {
    private static Log log = LogFactory.getLog((String)(class$org$apache$ws$security$message$WSSecEncrypt == null ? (class$org$apache$ws$security$message$WSSecEncrypt = WSSecEncrypt.class$("org.apache.ws.security.message.WSSecEncrypt")) : class$org$apache$ws$security$message$WSSecEncrypt).getName());
    private static Log tlog = LogFactory.getLog((String)"org.apache.ws.security.TIME");
    protected String symEncAlgo = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
    protected String encCanonAlgo = null;
    protected byte[] embeddedKey = null;
    protected String embeddedKeyName = null;
    protected SecretKey symmetricKey = null;
    protected SecurityTokenReference securityTokenReference = null;
    static /* synthetic */ Class class$org$apache$ws$security$message$WSSecEncrypt;

    public void setKey(byte[] key) {
        this.embeddedKey = key;
    }

    public void setKeyEnc(String keyEnc) {
        this.keyEncAlgo = keyEnc;
    }

    public void setEmbeddedKeyName(String embeddedKeyName) {
        this.embeddedKeyName = embeddedKeyName;
    }

    public void setSymmetricEncAlgorithm(String algo) {
        this.symEncAlgo = algo;
    }

    public void setEncCanonicalization(String algo) {
        this.encCanonAlgo = algo;
    }

    public String getSymmetricEncAlgorithm() {
        return this.symEncAlgo;
    }

    public void prepare(Document doc, Crypto crypto) throws WSSecurityException {
        this.document = doc;
        if (this.symmetricKey == null) {
            KeyGenerator keyGen = this.getKeyGenerator();
            this.symmetricKey = keyGen.generateKey();
        }
        byte[] encKey = this.symmetricKey.getEncoded();
        X509Certificate remoteCert = null;
        if (this.useThisCert != null) {
            remoteCert = this.useThisCert;
        } else {
            X509Certificate[] certs = crypto.getCertificates(this.user);
            if (certs == null || certs.length <= 0) {
                throw new WSSecurityException(0, "invalidX509Data", new Object[]{"for Encryption"});
            }
            remoteCert = certs[0];
        }
        this.prepareInternal(encKey, remoteCert, crypto);
    }

    public Document build(Document doc, Crypto crypto, WSSecHeader secHeader) throws WSSecurityException {
        this.doDebug = log.isDebugEnabled();
        if (this.keyIdentifierType == 5 || this.keyIdentifierType == 6) {
            return this.buildEmbedded(doc, crypto, secHeader);
        }
        if (this.doDebug) {
            log.debug((Object)"Beginning Encryption...");
        }
        this.prepare(doc, crypto);
        SOAPConstants soapConstants = WSSecurityUtil.getSOAPConstants(this.envelope);
        if (this.parts == null) {
            this.parts = new Vector();
            WSEncryptionPart encP = new WSEncryptionPart(soapConstants.getBodyQName().getLocalPart(), soapConstants.getEnvelopeURI(), "Content");
            this.parts.add(encP);
        }
        Element refs = this.encryptForInternalRef(null, this.parts);
        this.addInternalRefElement(refs);
        this.prependToHeader(secHeader);
        if (this.bstToken != null) {
            this.prependBSTElementToHeader(secHeader);
        }
        log.debug((Object)"Encryption complete.");
        return doc;
    }

    public Element encryptForInternalRef(Element dataRef, Vector references) throws WSSecurityException {
        Vector encDataRefs = this.doEncryption(this.document, this.symmetricKey, references);
        Element referenceList = dataRef;
        if (referenceList == null) {
            referenceList = this.document.createElementNS("http://www.w3.org/2001/04/xmlenc#", "xenc:ReferenceList");
        }
        WSSecEncrypt.createDataRefList(this.document, referenceList, encDataRefs);
        return referenceList;
    }

    public Element encryptForExternalRef(Element dataRef, Vector references) throws WSSecurityException {
        KeyInfo keyInfo = new KeyInfo(this.document);
        SecurityTokenReference secToken = new SecurityTokenReference(this.document);
        Reference ref = new Reference(this.document);
        ref.setURI("#" + this.encKeyId);
        secToken.setReference(ref);
        keyInfo.addUnknownElement(secToken.getElement());
        Vector encDataRefs = this.doEncryption(this.document, this.symmetricKey, keyInfo, references);
        Element referenceList = dataRef;
        if (referenceList == null) {
            referenceList = this.document.createElementNS("http://www.w3.org/2001/04/xmlenc#", "xenc:ReferenceList");
        }
        WSSecEncrypt.createDataRefList(this.document, referenceList, encDataRefs);
        return referenceList;
    }

    public void addInternalRefElement(Element dataRef) {
        WSSecurityUtil.appendChildElement(this.document, this.encryptedKeyElement, dataRef);
    }

    public void addExternalRefElement(Element dataRef, WSSecHeader secHeader) {
        WSSecurityUtil.prependChildElement(this.document, secHeader.getSecurityHeader(), dataRef, false);
    }

    private Vector doEncryption(Document doc, SecretKey secretKey, Vector references) throws WSSecurityException {
        return this.doEncryption(doc, secretKey, null, references);
    }

    private Vector doEncryption(Document doc, SecretKey secretKey, KeyInfo keyInfo, Vector references) throws WSSecurityException {
        XMLCipher xmlCipher = null;
        try {
            xmlCipher = XMLCipher.getInstance((String)this.symEncAlgo);
        }
        catch (XMLEncryptionException e3) {
            throw new WSSecurityException(2, null, null, e3);
        }
        Vector<String> encDataRef = new Vector<String>();
        for (int part = 0; part < references.size(); ++part) {
            WSEncryptionPart encPart = (WSEncryptionPart)references.get(part);
            String idToEnc = encPart.getId();
            String elemName = encPart.getName();
            String nmSpace = encPart.getNamespace();
            String modifier = encPart.getEncModifier();
            Element body = null;
            if (idToEnc != null) {
                body = WSSecurityUtil.findElementById(this.document.getDocumentElement(), idToEnc, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
                if (body == null) {
                    body = WSSecurityUtil.findElementById(this.document.getDocumentElement(), idToEnc, null);
                }
            } else {
                body = (Element)WSSecurityUtil.findElement(this.envelope, elemName, nmSpace);
            }
            if (body == null) {
                throw new WSSecurityException(0, "noEncElement", new Object[]{"{" + nmSpace + "}" + elemName});
            }
            boolean content = modifier.equals("Content");
            String xencEncryptedDataId = "EncDataId-" + body.hashCode();
            try {
                xmlCipher.init(1, (Key)secretKey);
                EncryptedData encData = xmlCipher.getEncryptedData();
                encData.setId(xencEncryptedDataId);
                encData.setKeyInfo(keyInfo);
                xmlCipher.doFinal(doc, body, content);
            }
            catch (Exception e2) {
                throw new WSSecurityException(8, null, null, e2);
            }
            encDataRef.add(new String("#" + xencEncryptedDataId));
        }
        return encDataRef;
    }

    private Document buildEmbedded(Document doc, Crypto crypto, WSSecHeader secHeader) throws WSSecurityException {
        this.doDebug = log.isDebugEnabled();
        if (this.doDebug) {
            log.debug((Object)"Beginning Encryption embedded...");
        }
        this.envelope = doc.getDocumentElement();
        this.envelope.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xenc", "http://www.w3.org/2001/04/xmlenc#");
        if (this.symmetricKey == null) {
            if (this.embeddedKey == null) {
                throw new WSSecurityException(0, "noKeySupplied");
            }
            this.symmetricKey = WSSecurityUtil.prepareSecretKey(this.symEncAlgo, this.embeddedKey);
        }
        KeyInfo keyInfo = null;
        if (this.keyIdentifierType == 5) {
            keyInfo = new KeyInfo(doc);
            keyInfo.addKeyName(this.embeddedKeyName == null ? this.user : this.embeddedKeyName);
        } else if (this.keyIdentifierType == 6) {
            if (this.securityTokenReference == null) {
                throw new WSSecurityException(7, "You must set keyInfo element, if the keyIdentifier == EMBED_SECURITY_TOKEN_REF");
            }
            keyInfo = new KeyInfo(doc);
            Element tmpE = this.securityTokenReference.getElement();
            tmpE.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + tmpE.getPrefix(), tmpE.getNamespaceURI());
            keyInfo.addUnknownElement(this.securityTokenReference.getElement());
        }
        SOAPConstants soapConstants = WSSecurityUtil.getSOAPConstants(this.envelope);
        if (this.parts == null) {
            this.parts = new Vector();
            WSEncryptionPart encP = new WSEncryptionPart(soapConstants.getBodyQName().getLocalPart(), soapConstants.getEnvelopeURI(), "Content");
            this.parts.add(encP);
        }
        Vector encDataRefs = this.doEncryption(doc, this.symmetricKey, keyInfo, this.parts);
        Element wsseSecurity = secHeader.getSecurityHeader();
        Element referenceList = doc.createElementNS("http://www.w3.org/2001/04/xmlenc#", "xenc:ReferenceList");
        referenceList = WSSecEncrypt.createDataRefList(doc, referenceList, encDataRefs);
        WSSecurityUtil.prependChildElement(doc, wsseSecurity, referenceList, true);
        return doc;
    }

    private KeyGenerator getKeyGenerator() throws WSSecurityException {
        KeyGenerator keyGen;
        block6: {
            keyGen = null;
            try {
                keyGen = KeyGenerator.getInstance("AES");
                if (this.symEncAlgo.equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#tripledes-cbc")) {
                    keyGen = KeyGenerator.getInstance("DESede");
                    break block6;
                }
                if (this.symEncAlgo.equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#aes128-cbc")) {
                    keyGen.init(128);
                    break block6;
                }
                if (this.symEncAlgo.equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#aes192-cbc")) {
                    keyGen.init(192);
                    break block6;
                }
                if (this.symEncAlgo.equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#aes256-cbc")) {
                    keyGen.init(256);
                    break block6;
                }
                return null;
            }
            catch (NoSuchAlgorithmException e) {
                throw new WSSecurityException(2, null, null, e);
            }
        }
        return keyGen;
    }

    public static Element createDataRefList(Document doc, Element referenceList, Vector encDataRefs) {
        for (int i = 0; i < encDataRefs.size(); ++i) {
            String dataReferenceUri = (String)encDataRefs.get(i);
            Element dataReference = doc.createElementNS("http://www.w3.org/2001/04/xmlenc#", "xenc:DataReference");
            dataReference.setAttributeNS(null, "URI", dataReferenceUri);
            referenceList.appendChild(dataReference);
        }
        return referenceList;
    }

    public SecretKey getSymmetricKey() {
        return this.symmetricKey;
    }

    public void setSymmetricKey(SecretKey key) {
        this.symmetricKey = key;
    }

    public SecurityTokenReference getSecurityTokenReference() {
        return this.securityTokenReference;
    }

    public void setSecurityTokenReference(SecurityTokenReference reference) {
        this.securityTokenReference = reference;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

