/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.xml.transform.Source;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;
import org.apache.servicemix.jms.JmsEndpoint;
import org.apache.servicemix.jms.JmsMarshaler;
import org.apache.servicemix.soap.SoapEndpoint;
import org.apache.servicemix.soap.SoapFault;
import org.apache.servicemix.soap.SoapHelper;
import org.apache.servicemix.soap.marshalers.SoapMessage;
import org.apache.servicemix.soap.marshalers.SoapWriter;

public class DefaultJmsMarshaler
implements JmsMarshaler {
    public static final String CONTENT_TYPE = "MimeContentType";
    public static final String DONE_JMS_PROPERTY = "JBIDone";
    public static final String FAULT_JMS_PROPERTY = "JBIFault";
    public static final String ERROR_JMS_PROPERTY = "JBIError";
    private JmsEndpoint endpoint;

    public DefaultJmsMarshaler(JmsEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    public Message toJMS(Exception e, Session session) throws Exception {
        return session.createObjectMessage((Serializable)e);
    }

    protected Message toJMS(SoapMessage message, Session session) throws Exception {
        SoapHelper soapHelper = new SoapHelper((SoapEndpoint)this.endpoint);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        SoapWriter writer = soapHelper.getSoapMarshaler().createWriter(message);
        writer.write((OutputStream)baos);
        TextMessage msg = session.createTextMessage();
        msg.setText(baos.toString(SourceTransformer.getDefaultCharset()));
        msg.setStringProperty(CONTENT_TYPE, writer.getContentType());
        return msg;
    }

    public Message toJMS(SoapMessage message, Map headers, Session session) throws Exception {
        Message msg = this.toJMS(message, session);
        if (headers != null) {
            for (String name : headers.keySet()) {
                Object value;
                if (!this.shouldIncludeHeader(name, value = headers.get(name))) continue;
                msg.setObjectProperty(name, value);
            }
        }
        if (message.getFault() != null) {
            msg.setBooleanProperty(FAULT_JMS_PROPERTY, true);
        }
        return msg;
    }

    protected InputStream toXmlInputStream(Message message) throws Exception {
        ByteArrayInputStream is = null;
        if (message instanceof ObjectMessage) {
            Serializable o = ((ObjectMessage)message).getObject();
            if (o instanceof Exception) {
                throw (Exception)o;
            }
            throw new UnsupportedOperationException("Can not handle objects of type " + o.getClass().getName());
        }
        if (message instanceof TextMessage) {
            is = new ByteArrayInputStream(((TextMessage)message).getText().getBytes());
        } else if (message instanceof BytesMessage) {
            int length = (int)((BytesMessage)message).getBodyLength();
            byte[] bytes = new byte[length];
            ((BytesMessage)message).readBytes(bytes);
            is = new ByteArrayInputStream(bytes);
        } else {
            throw new IllegalArgumentException("JMS message should be a text or bytes message");
        }
        return is;
    }

    public SoapMessage toSOAP(Message message) throws Exception {
        SoapHelper soapHelper = new SoapHelper((SoapEndpoint)this.endpoint);
        InputStream is = this.toXmlInputStream(message);
        String contentType = message.getStringProperty(CONTENT_TYPE);
        SoapMessage soap = soapHelper.getSoapMarshaler().createReader().read(is, contentType);
        if (message.getBooleanProperty(FAULT_JMS_PROPERTY)) {
            Source src = soap.getSource();
            soap.setSource(null);
            soap.setFault(new SoapFault(SoapFault.SENDER, null, null, null, src));
        }
        return soap;
    }

    private boolean shouldIncludeHeader(String name, Object value) {
        return !(!(value instanceof String) && !(value instanceof Number) && !(value instanceof Date) || this.endpoint.isNeedJavaIdentifiers() && !DefaultJmsMarshaler.isJavaIdentifier(name));
    }

    private static boolean isJavaIdentifier(String s) {
        int n = s.length();
        if (n == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(s.charAt(0))) {
            return false;
        }
        for (int i = 1; i < n; ++i) {
            if (Character.isJavaIdentifierPart(s.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

