/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jms.endpoints;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.activation.DataHandler;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import org.apache.servicemix.jms.endpoints.AbstractJmsMarshaler;
import org.apache.servicemix.jms.endpoints.JmsProviderMarshaler;
import org.apache.servicemix.soap.api.Interceptor;
import org.apache.servicemix.soap.api.Message;
import org.apache.servicemix.soap.core.MessageImpl;
import org.apache.servicemix.soap.core.PhaseInterceptorChain;
import org.apache.servicemix.soap.interceptors.mime.AttachmentsInInterceptor;
import org.apache.servicemix.soap.interceptors.mime.AttachmentsOutInterceptor;
import org.apache.servicemix.soap.interceptors.xml.BodyOutInterceptor;
import org.apache.servicemix.soap.interceptors.xml.StaxInInterceptor;
import org.apache.servicemix.soap.interceptors.xml.StaxOutInterceptor;
import org.apache.servicemix.soap.util.stax.StaxSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultProviderMarshaler
extends AbstractJmsMarshaler
implements JmsProviderMarshaler {
    private Map<String, Object> jmsProperties;

    public Map<String, Object> getJmsProperties() {
        return this.jmsProperties;
    }

    public void setJmsProperties(Map<String, Object> jmsProperties) {
        this.jmsProperties = jmsProperties;
    }

    @Override
    public javax.jms.Message createMessage(MessageExchange exchange, NormalizedMessage in, Session session) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PhaseInterceptorChain chain = new PhaseInterceptorChain();
        chain.add((Interceptor)new AttachmentsOutInterceptor());
        chain.add((Interceptor)new StaxOutInterceptor());
        chain.add((Interceptor)new BodyOutInterceptor());
        MessageImpl msg = new MessageImpl();
        msg.setContent(Source.class, (Object)in.getContent());
        msg.setContent(OutputStream.class, (Object)baos);
        for (String attId : in.getAttachmentNames()) {
            msg.getAttachments().put(attId, in.getAttachment(attId));
        }
        chain.doIntercept((Message)msg);
        TextMessage text = session.createTextMessage(baos.toString());
        if (msg.get((Object)"Content-Type") != null) {
            text.setStringProperty("SOAPJMS_contentType", (String)msg.get((Object)"Content-Type"));
        }
        if (this.jmsProperties != null) {
            for (Map.Entry<String, Object> e : this.jmsProperties.entrySet()) {
                text.setObjectProperty(e.getKey(), e.getValue());
            }
        }
        if (this.isCopyProperties()) {
            this.copyPropertiesFromNM(in, (javax.jms.Message)text);
        }
        return text;
    }

    @Override
    public void populateMessage(javax.jms.Message message, MessageExchange exchange, NormalizedMessage normalizedMessage) throws Exception {
        if (message instanceof TextMessage) {
            PhaseInterceptorChain chain = new PhaseInterceptorChain();
            chain.add((Interceptor)new AttachmentsInInterceptor());
            chain.add((Interceptor)new StaxInInterceptor());
            MessageImpl msg = new MessageImpl();
            msg.setContent(InputStream.class, (Object)new ByteArrayInputStream(((TextMessage)message).getText().getBytes()));
            if (message.propertyExists("SOAPJMS_contentType")) {
                msg.put((Object)"Content-Type", (Object)message.getStringProperty("SOAPJMS_contentType"));
            }
            chain.doIntercept((Message)msg);
            XMLStreamReader xmlReader = (XMLStreamReader)msg.getContent(XMLStreamReader.class);
            normalizedMessage.setContent((Source)new StaxSource(xmlReader));
            for (Map.Entry attachment : msg.getAttachments().entrySet()) {
                normalizedMessage.addAttachment((String)attachment.getKey(), (DataHandler)attachment.getValue());
            }
            if (this.isCopyProperties()) {
                this.copyPropertiesFromJMS(message, normalizedMessage);
            }
        } else {
            throw new UnsupportedOperationException("JMS message is not a TextMessage");
        }
    }
}

