/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jms.endpoints;

import javax.jbi.management.DeploymentException;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import javax.transaction.TransactionManager;
import javax.xml.namespace.QName;
import org.apache.servicemix.common.DefaultComponent;
import org.apache.servicemix.common.ServiceUnit;
import org.apache.servicemix.jms.JmsEndpointType;
import org.apache.servicemix.jms.endpoints.AbstractConsumerEndpoint;
import org.springframework.jms.connection.JmsTransactionManager;
import org.springframework.jms.connection.JmsTransactionManager102;
import org.springframework.jms.listener.AbstractMessageListenerContainer;
import org.springframework.jms.listener.DefaultMessageListenerContainer;
import org.springframework.jms.listener.DefaultMessageListenerContainer102;
import org.springframework.jms.listener.SessionAwareMessageListener;
import org.springframework.jms.listener.SimpleMessageListenerContainer;
import org.springframework.jms.listener.SimpleMessageListenerContainer102;
import org.springframework.jms.listener.serversession.ServerSessionFactory;
import org.springframework.jms.listener.serversession.ServerSessionMessageListenerContainer;
import org.springframework.jms.listener.serversession.ServerSessionMessageListenerContainer102;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.jta.JtaTransactionManager;

public class JmsConsumerEndpoint
extends AbstractConsumerEndpoint
implements JmsEndpointType {
    public static final String LISTENER_TYPE_DEFAULT = "default";
    public static final String LISTENER_TYPE_SIMPLE = "simple";
    public static final String LISTENER_TYPE_SERVER = "server";
    public static final String TRANSACTED_NONE = "none";
    public static final String TRANSACTED_XA = "xa";
    public static final String TRANSACTED_JMS = "jms";
    private String listenerType = "default";
    private String transacted = "none";
    private String clientId;
    private Destination destination;
    private String destinationName;
    private String durableSubscriptionName;
    private ExceptionListener exceptionListener;
    private String messageSelector;
    private int sessionAcknowledgeMode = 1;
    private boolean subscriptionDurable;
    private boolean pubSubNoLocal;
    private int concurrentConsumers = 1;
    private int idleTaskExecutionLimit = 1;
    private int maxConcurrentConsumers = 1;
    private int cacheLevel = 0;
    private long receiveTimeout = 1000L;
    private long recoveryInterval = 5000L;
    private int maxMessagesPerTask = Integer.MIN_VALUE;
    private ServerSessionFactory serverSessionFactory;
    private AbstractMessageListenerContainer listenerContainer;

    public JmsConsumerEndpoint() {
    }

    public JmsConsumerEndpoint(DefaultComponent component, ServiceEndpoint endpoint) {
        super(component, endpoint);
    }

    public JmsConsumerEndpoint(ServiceUnit serviceUnit, QName service, String endpoint) {
        super(serviceUnit, service, endpoint);
    }

    public String getTransacted() {
        return this.transacted;
    }

    public void setTransacted(String transacted) {
        this.transacted = transacted;
    }

    public int getCacheLevel() {
        return this.cacheLevel;
    }

    public void setCacheLevel(int cacheLevel) {
        this.cacheLevel = cacheLevel;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public int getConcurrentConsumers() {
        return this.concurrentConsumers;
    }

    public void setConcurrentConsumers(int concurrentConsumers) {
        this.concurrentConsumers = concurrentConsumers;
    }

    public Destination getDestination() {
        return this.destination;
    }

    public void setDestination(Destination destination) {
        this.destination = destination;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public void setDestinationName(String destinationName) {
        this.destinationName = destinationName;
    }

    public String getDurableSubscriptionName() {
        return this.durableSubscriptionName;
    }

    public void setDurableSubscriptionName(String durableSubscriptionName) {
        this.durableSubscriptionName = durableSubscriptionName;
    }

    public ExceptionListener getExceptionListener() {
        return this.exceptionListener;
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    public int getIdleTaskExecutionLimit() {
        return this.idleTaskExecutionLimit;
    }

    public void setIdleTaskExecutionLimit(int idleTaskExecutionLimit) {
        this.idleTaskExecutionLimit = idleTaskExecutionLimit;
    }

    public String getListenerType() {
        return this.listenerType;
    }

    public void setListenerType(String listenerType) {
        this.listenerType = listenerType;
    }

    public int getMaxConcurrentConsumers() {
        return this.maxConcurrentConsumers;
    }

    public void setMaxConcurrentConsumers(int maxConcurrentConsumers) {
        this.maxConcurrentConsumers = maxConcurrentConsumers;
    }

    public int getMaxMessagesPerTask() {
        return this.maxMessagesPerTask;
    }

    public void setMaxMessagesPerTask(int maxMessagesPerTask) {
        this.maxMessagesPerTask = maxMessagesPerTask;
    }

    public String getMessageSelector() {
        return this.messageSelector;
    }

    public void setMessageSelector(String messageSelector) {
        this.messageSelector = messageSelector;
    }

    public boolean isPubSubNoLocal() {
        return this.pubSubNoLocal;
    }

    public void setPubSubNoLocal(boolean pubSubNoLocal) {
        this.pubSubNoLocal = pubSubNoLocal;
    }

    public long getReceiveTimeout() {
        return this.receiveTimeout;
    }

    public void setReceiveTimeout(long receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }

    public long getRecoveryInterval() {
        return this.recoveryInterval;
    }

    public void setRecoveryInterval(long recoveryInterval) {
        this.recoveryInterval = recoveryInterval;
    }

    public ServerSessionFactory getServerSessionFactory() {
        return this.serverSessionFactory;
    }

    public void setServerSessionFactory(ServerSessionFactory serverSessionFactory) {
        this.serverSessionFactory = serverSessionFactory;
    }

    public int getSessionAcknowledgeMode() {
        return this.sessionAcknowledgeMode;
    }

    public void setSessionAcknowledgeMode(int sessionAcknowledgeMode) {
        this.sessionAcknowledgeMode = sessionAcknowledgeMode;
    }

    public boolean isSubscriptionDurable() {
        return this.subscriptionDurable;
    }

    public void setSubscriptionDurable(boolean subscriptionDurable) {
        this.subscriptionDurable = subscriptionDurable;
    }

    public String getLocationURI() {
        return this.getService() + "#" + this.getEndpoint();
    }

    public synchronized void start() throws Exception {
        this.listenerContainer = this.createListenerContainer();
        this.listenerContainer.setMessageListener((Object)new SessionAwareMessageListener(){

            public void onMessage(Message message, Session session) throws JMSException {
                JmsConsumerEndpoint.this.onMessage(message, session);
            }
        });
        this.listenerContainer.setAutoStartup(true);
        this.listenerContainer.afterPropertiesSet();
        super.start();
    }

    public synchronized void stop() throws Exception {
        if (this.listenerContainer != null) {
            this.listenerContainer.stop();
            this.listenerContainer.shutdown();
            this.listenerContainer = null;
        }
        super.stop();
    }

    public void validate() throws DeploymentException {
        super.validate();
        if (this.getConnectionFactory() == null) {
            throw new DeploymentException("connectionFactory is required");
        }
        if (this.destination == null && this.destinationName == null) {
            throw new DeploymentException("destination or destinationName is required");
        }
        if (!(LISTENER_TYPE_DEFAULT.equals(this.listenerType) || LISTENER_TYPE_SIMPLE.equals(this.listenerType) || LISTENER_TYPE_SERVER.equals(this.listenerType))) {
            throw new DeploymentException("listenerType must be default, simple or server");
        }
        if (TRANSACTED_XA.equals(this.transacted) && !LISTENER_TYPE_DEFAULT.equals(this.listenerType)) {
            throw new DeploymentException("XA transactions are only supported on default listener");
        }
        if (!(TRANSACTED_NONE.equals(this.transacted) || TRANSACTED_JMS.equals(this.transacted) || TRANSACTED_XA.equals(this.transacted))) {
            throw new DeploymentException("transacted must be none, jms or xa");
        }
    }

    protected AbstractMessageListenerContainer createListenerContainer() {
        AbstractMessageListenerContainer container;
        if (LISTENER_TYPE_DEFAULT.equals(this.listenerType)) {
            container = this.createDefaultMessageListenerContainer();
        } else if (LISTENER_TYPE_SIMPLE.equals(this.listenerType)) {
            container = this.createSimpleMessageListenerContainer();
        } else if (LISTENER_TYPE_SERVER.equals(this.listenerType)) {
            container = this.createServerSessionMessageListenerContainer();
        } else {
            throw new IllegalStateException();
        }
        container.setAutoStartup(false);
        container.setClientId(this.clientId);
        container.setConnectionFactory(this.getConnectionFactory());
        if (this.destination != null) {
            container.setDestination(this.destination);
        } else if (this.destinationName != null) {
            container.setDestinationName(this.destinationName);
        }
        if (this.getDestinationResolver() != null) {
            container.setDestinationResolver(this.getDestinationResolver());
        }
        if (this.subscriptionDurable) {
            if (this.durableSubscriptionName == null) {
                this.durableSubscriptionName = this.getService() + "#" + this.getEndpoint();
            }
            container.setDurableSubscriptionName(this.durableSubscriptionName);
        }
        container.setExceptionListener(this.exceptionListener);
        container.setMessageSelector(this.messageSelector);
        container.setPubSubDomain(this.isPubSubDomain());
        container.setSessionAcknowledgeMode(this.sessionAcknowledgeMode);
        container.setSubscriptionDurable(this.subscriptionDurable);
        return container;
    }

    private AbstractMessageListenerContainer createServerSessionMessageListenerContainer() {
        Object cont = this.isJms102() ? new ServerSessionMessageListenerContainer102() : new ServerSessionMessageListenerContainer();
        cont.setMaxMessagesPerTask(this.maxMessagesPerTask > 0 ? this.maxMessagesPerTask : 1);
        cont.setServerSessionFactory(this.serverSessionFactory);
        if (TRANSACTED_JMS.equals(this.transacted)) {
            cont.setSessionTransacted(true);
        }
        return cont;
    }

    private AbstractMessageListenerContainer createSimpleMessageListenerContainer() {
        Object cont = this.isJms102() ? new SimpleMessageListenerContainer102() : new SimpleMessageListenerContainer();
        cont.setConcurrentConsumers(this.concurrentConsumers);
        cont.setPubSubNoLocal(this.pubSubNoLocal);
        cont.setTaskExecutor(null);
        if (TRANSACTED_JMS.equals(this.transacted)) {
            cont.setSessionTransacted(true);
        }
        return cont;
    }

    private AbstractMessageListenerContainer createDefaultMessageListenerContainer() {
        Object cont = this.isJms102() ? new DefaultMessageListenerContainer102() : new DefaultMessageListenerContainer();
        cont.setCacheLevel(this.cacheLevel);
        cont.setConcurrentConsumers(this.concurrentConsumers);
        cont.setIdleTaskExecutionLimit(this.idleTaskExecutionLimit);
        cont.setMaxConcurrentConsumers(this.maxConcurrentConsumers);
        cont.setMaxMessagesPerTask(this.maxMessagesPerTask);
        cont.setPubSubNoLocal(this.pubSubNoLocal);
        cont.setReceiveTimeout(this.receiveTimeout);
        cont.setRecoveryInterval(this.recoveryInterval);
        if (TRANSACTED_XA.equals(this.transacted)) {
            cont.setSessionTransacted(true);
            TransactionManager tm = (TransactionManager)this.getContext().getTransactionManager();
            if (tm == null) {
                throw new IllegalStateException("No TransactionManager available");
            }
            if (tm instanceof PlatformTransactionManager) {
                cont.setTransactionManager((PlatformTransactionManager)tm);
            } else {
                cont.setTransactionManager((PlatformTransactionManager)new JtaTransactionManager(tm));
            }
        } else if (TRANSACTED_JMS.equals(this.transacted)) {
            cont.setSessionTransacted(true);
            if (this.isJms102()) {
                cont.setTransactionManager((PlatformTransactionManager)new JmsTransactionManager102(this.getConnectionFactory(), this.isPubSubDomain()));
            } else {
                cont.setTransactionManager((PlatformTransactionManager)new JmsTransactionManager(this.getConnectionFactory()));
            }
        }
        return cont;
    }
}

