/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jms.standard;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.messaging.RobustInOnly;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import org.apache.servicemix.jms.AbstractJmsProcessor;
import org.apache.servicemix.jms.JmsEndpoint;
import org.apache.servicemix.soap.marshalers.SoapMessage;

public class StandardProviderProcessor
extends AbstractJmsProcessor {
    public StandardProviderProcessor(JmsEndpoint endpoint) throws Exception {
        super(endpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStart(InitialContext ctx) throws Exception {
        try {
            this.commonDoStartTasks(ctx);
        }
        finally {
            if (this.session != null) {
                this.session.close();
            }
        }
    }

    protected void doStop() throws Exception {
        this.destination = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void process(MessageExchange exchange) throws Exception {
        if (exchange.getStatus() == ExchangeStatus.DONE) {
            return;
        }
        if (exchange.getStatus() == ExchangeStatus.ERROR) {
            return;
        }
        Session session = null;
        try {
            session = this.connection.createSession(false, 1);
            MessageProducer producer = session.createProducer(this.destination);
            Message msg = this.createMessageFromExchange(session, exchange);
            if (exchange instanceof InOnly || exchange instanceof RobustInOnly) {
                producer.send(msg);
                exchange.setStatus(ExchangeStatus.DONE);
                this.channel.send(exchange);
                return;
            } else {
                void var5_8;
                if (!(exchange instanceof InOut)) throw new IllegalStateException(exchange.getPattern() + " not implemented");
                if (this.replyToDestination != null) {
                    Destination destination = this.replyToDestination;
                } else if (this.destination instanceof Queue) {
                    TemporaryQueue temporaryQueue = session.createTemporaryQueue();
                } else {
                    TemporaryTopic temporaryTopic = session.createTemporaryTopic();
                }
                MessageConsumer consumer = session.createConsumer((Destination)var5_8);
                msg.setJMSCorrelationID(exchange.getExchangeId());
                msg.setJMSReplyTo((Destination)var5_8);
                producer.send(msg);
                Message message = consumer.receive();
                if (message instanceof ObjectMessage) {
                    Serializable o = ((ObjectMessage)message).getObject();
                    if (!(o instanceof Exception)) throw new UnsupportedOperationException("Can not handle objects of type " + o.getClass().getName());
                    exchange.setError((Exception)o);
                } else {
                    ByteArrayInputStream is = null;
                    if (message instanceof TextMessage) {
                        is = new ByteArrayInputStream(((TextMessage)message).getText().getBytes());
                    } else {
                        if (!(message instanceof BytesMessage)) throw new IllegalArgumentException("JMS message should be a text or bytes message");
                        int length = (int)((BytesMessage)message).getBodyLength();
                        byte[] bytes = new byte[length];
                        ((BytesMessage)message).readBytes(bytes);
                        is = new ByteArrayInputStream(bytes);
                    }
                    String contentType = message.getStringProperty("MimeContentType");
                    SoapMessage soap = this.soapHelper.getSoapMarshaler().createReader().read((InputStream)is, contentType);
                    NormalizedMessage out = exchange.createMessage();
                    this.soapHelper.getJBIMarshaler().toNMS(out, soap);
                    ((InOut)exchange).setOutMessage(out);
                }
                this.channel.send(exchange);
            }
            return;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }
}

